package com.elitescloud.cloudt.ucenter.entity;

import com.elitescloud.boot.model.entity.BaseModel;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Where;
import org.springframework.data.jpa.repository.config.EnableJpaAuditing;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;
import java.time.LocalDateTime;

@Entity
@Table(name = "sys_ad_info", indexes = {
})
@org.hibernate.annotations.Table(appliesTo = "sys_ad_info", comment = "广告信息")
@EnableJpaAuditing
@Data
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
@Where(clause = "delete_flag = 0 or delete_flag is null")
public class AdInfoDO extends BaseModel implements Serializable {

    @Column(name = "ad_code", columnDefinition = "varchar(64) comment '广告编码'")
    private String adCode;

    @Column(name = "ad_title", columnDefinition = "varchar(256) comment '广告标题'")
    private String adTitle;

    @Column(name = "ad_space_id", columnDefinition = "bigint(20) comment '广告位id'")
    private Long adSpaceId;

    @Column(name = "ad_space_code", columnDefinition = "varchar(256) comment '广告位编码'")
    private String adSpaceCode;

    @Column(name = "ad_space_name", columnDefinition = "varchar(256) comment '广告位名称'")
    private String adSpaceName;

    @Column(name = "ad_link_type", columnDefinition = "varchar(16) comment '链接类型 internal-内部链接  external-外部链接  custom-自定义'")
    private String adLinkType;

    @Column(name = "show_flag", columnDefinition = "varchar(16) comment '是否显示 HIDE-隐藏 DISPLAY-显示'")
    private String showFlag;

    @Column(name = "sort_no", columnDefinition = "int(11) comment '广告排序'")
    private Integer sortNo;

    @Column(name = "show_begin_time", columnDefinition = "datetime comment '广告开始时间'")
    private LocalDateTime showBeginTime;

    @Column(name = "show_end_time", columnDefinition = "datetime comment '广告结束时间'")
    private LocalDateTime showEndTime;

    @Column(name = "target_type", columnDefinition = "varchar(32) comment '目标类型(文章)'")
    private String targetType;

    @Column(name = "link_address_id", columnDefinition = "bigint(20) comment '链接地址id'")
    private Long linkAddressId;

    @Column(name = "link_address", columnDefinition = "varchar(256) comment '链接地址'")
    private String  linkAddress;

    @Column(name = "img_file_code", columnDefinition = "varchar(128) comment '图片文件编码，文件服务器上的文件唯一标识'")
    private String imgFileCode;

    @Column(name = "video_file_code", columnDefinition = "varchar(128) comment '视频文件编码，文件服务器上的文件唯一标识'")
    private String videoFileCode;

    @Column(name = "source_type", columnDefinition = "varchar(32) comment '资源类型 1-图片 2-视频'")
    private String sourceType;
}