package com.elitescloud.cloudt.ucenter.entity;

import com.elitescloud.boot.model.entity.BaseModel;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Where;
import org.springframework.data.jpa.repository.config.EnableJpaAuditing;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;

@Entity
@Table(name = "sys_article_category", indexes = {
})
@org.hibernate.annotations.Table(appliesTo = "sys_article_category", comment = "文章分类")
@EnableJpaAuditing
@Data
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
@Where(clause = "delete_flag = 0 or delete_flag is null")
public class ArticleCategoryDO extends BaseModel implements Serializable {

    @Column(name = "category_name", columnDefinition = "varchar(64) comment '分类名称'")
    private String categoryName;

    @Column(name = "sort_no", columnDefinition = "int(11) comment '分类排序'")
    private Integer sortNo;

    @Column(name = "show_flag", columnDefinition = "varchar(32) comment '是否显示 HIDE-隐藏 DISPLAY-显示'")
    private String showFlag;

    @Column(name = "pid", columnDefinition = "bigint(20) comment '父类id'")
    private Long pid;

    @Column(name = "root_id", columnDefinition = "bigint(20) comment '一级id'")
    private Long rootId;

//    @Column(name = "pid_list", columnDefinition = "varchar(256) comment '父级id集合'")
//    private String pidList;
}
