package com.elitescloud.cloudt.ucenter.entity;

import com.elitescloud.boot.model.entity.BaseModel;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Where;
import org.springframework.data.jpa.repository.config.EnableJpaAuditing;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;

@Entity
@Table(name = "sys_article_info", indexes = {
})
@org.hibernate.annotations.Table(appliesTo = "sys_article_info", comment = "文章信息")
@EnableJpaAuditing
@Data
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
@Where(clause = "delete_flag = 0 or delete_flag is null")
public class ArticleInfoDO extends BaseModel implements Serializable {

    @Column(name = "article_author", columnDefinition = "varchar(64) comment '文章作者'")
    private String articleAuthor;

    @Column(name = "article_name", columnDefinition = "varchar(256) comment '文章名称'")
    private String articleName;

    @Column(name = "article_code", columnDefinition = "varchar(64) comment '文章编码'")
    private String articleCode;

    @Column(name = "sort_no", columnDefinition = "int(11) comment '文章排序'")
    private Integer sortNo;

    @Column(name = "show_flag", columnDefinition = "varchar(32) comment '是否显示 HIDE-隐藏 DISPLAY-显示'")
    private String showFlag;

    @Column(name = "category_id", columnDefinition = "bigint(20) comment '分类id'")
    private Long categoryId;

    @Column(name = "category_name", columnDefinition = "varchar(256) comment '分类名称'")
    private String categoryName;

    @Column(name = "article_detail", columnDefinition = "longtext comment '文章详情'")
    private String articleDetail;
}
