package com.elitescloud.cloudt.ucenter.entity;

import com.elitescloud.boot.model.entity.BaseModel;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Where;
import org.springframework.data.jpa.repository.config.EnableJpaAuditing;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;
import java.math.BigDecimal;

@Entity
@Table(name = "sys_common_search")
@org.hibernate.annotations.Table(appliesTo = "sys_common_search", comment = "通用查询")
@EnableJpaAuditing
@Data
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
@Where(clause = "delete_flag = 0 or delete_flag is null")
public class CommonSearchDO extends BaseModel implements Serializable {

    @Column(name = "common_search_id", columnDefinition = "varchar(32) comment '通查ID'")
    private String commonSearchId;

    @Column(name = "common_search_name", columnDefinition = "varchar(32) comment '通查名称'")
    private String commonSearchName;

    @Column(name = "common_search_content", columnDefinition = "varchar(512) comment '通查内容'")
    private String commonSearchContent;

    @Column(name = "common_search_param", columnDefinition = "varchar(512) comment '通查参数'")
    private String commonSearchParam;

    @Column(name = "connection_name", columnDefinition = "varchar(256) comment '连接名字'")
    private String connectionName;

    @Column(name = "database_type", columnDefinition = "varchar(16) comment '数据库类型'")
    private String databaseType;

    @Column(name = "cache_flag", columnDefinition = "tinyint(1) default 0 comment '是否缓存：1是，0否'")
    private Boolean cacheFlag;

    @Column(name = "cache_live_time", columnDefinition = "decimal(8, 0) comment '缓存存活时间'")
    private BigDecimal cacheLiveTime;

    @Column(name = "sub_search", columnDefinition = "varchar(64) comment '子查询'")
    private String subSearch;

    @Column(name = "user_name", columnDefinition = "varchar(32) comment '用户名'")
    private String userName;

    @Column(name = "password", columnDefinition = "varchar(32) comment '密码'")
    private String password;

}