package com.elitescloud.cloudt.ucenter.entity;

import com.elitescloud.boot.model.entity.BaseModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.time.LocalDateTime;

/**
 * @author : http://www.chiner.pre
 * @date : 2023-4-12
 * @desc : 文件信息
 */
@Entity
@Table(name = "sys_file_info")
@org.hibernate.annotations.Table(appliesTo = "sys_file_info", comment = "文件信息")
@Data
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
@Where(clause = "delete_flag = 0")
public class FileInfoDO extends BaseModel {

    @Column(name = "url", columnDefinition = "varchar(255) comment '链接'")
    private String url;

    @Column(name = "file_code", columnDefinition = "varchar(255) comment '编码'")
    private String fileCode;

    @Column(name = "source_id", columnDefinition = "bigint(20) comment '来源id'")
    private Long sourceId;

    @Column(name = "source_type", columnDefinition = "varchar(255) comment '来源类型'")
    private String sourceType;

    @Column(name = "file_name", columnDefinition = "varchar(255) comment '文件名称'")
    private String fileName;

    @Column(name = "old_file_name", columnDefinition = "varchar(255) comment '原始文件名称'")
    private String oldFileName;

    @Column(name = "file_size", columnDefinition = "varchar(255) comment '文件大小'")
    private String fileSize;

    @Column(name = "file_info", columnDefinition = "varchar(255) comment '文件内容'")
    private String fileInfo;

    @Column(name = "original_name", columnDefinition = "varchar(256) comment '文件原名称'")
    private String originalName;

    @Column(name = "suffix", columnDefinition = "varchar(256) comment '文件名后缀'")
    private String suffix;

    @Column(name = "mime_type", columnDefinition = "varchar(256) comment '文件内容类型'")
    private String mimeType;

    @ApiModelProperty(value = "常见的文件类型（IMAGE-图片，AUDIO-音频，VIDEO-视频），为空则表示不常见")
    @Column(name = "file_type", columnDefinition = "varchar(256) comment '常见的文件类型（IMAGE-图片，AUDIO-音频，VIDEO-视频），为空则表示不常见'")
    private String fileType;

    @ApiModelProperty(value = "上传时间")
    @Column(name = "upload_time", columnDefinition = "datetime(6) comment '上传时间'")
    private LocalDateTime uploadTime;

    @ApiModelProperty(value = "文件路径")
    @Column(name = "file_path", columnDefinition = "varchar(256) comment '文件路径'")
    private String filePath;

    @ApiModelProperty(value = "宽度，图片时有值")
    @Column(name = "width", columnDefinition = "int(10) comment '宽度，图片时有值'")
    private Integer width;

    @ApiModelProperty(value = "高度，图片时有值")
    @Column(name = "height", columnDefinition = "int(10) comment '高度，图片时有值'")
    private Integer height;

    @ApiModelProperty(value = "文件预览url")
    @Column(name = "urlPreview", columnDefinition = "varchar(256) comment '文件预览url'")
    private String urlPreview;

    @ApiModelProperty(value = "文件下载uri")
    @Column(name = "uri_down_load", columnDefinition = "varchar(256) comment '文件下载uri'")
    private String uriDownload;

    @ApiModelProperty(value = "文件删除url")
    @Column(name = "url_delete", columnDefinition = "varchar(256) comment '文件删除url'")
    private String urlDelete;

}