package com.elitescloud.cloudt.ucenter.entity;


import com.elitescloud.boot.model.entity.BaseModel;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Where;
import org.springframework.data.jpa.repository.config.EnableJpaAuditing;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;
import java.time.LocalDateTime;

@Entity
@Table(name = "sys_message_info", indexes = {
})
@org.hibernate.annotations.Table(appliesTo = "sys_message_info", comment = "消息信息")
@EnableJpaAuditing
@Data
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
@Where(clause = "delete_flag = 0 or delete_flag is null")
public class MessageInfoDO extends BaseModel implements Serializable {


    @Column(name = "message_title", columnDefinition = "varchar(256) comment '消息标题'")
    private String messageTitle;

    @Column(name = "category_code", columnDefinition = "varchar(256) comment '消息分类code'")
    private String categoryCode;

    @Column(name = "publish_status", columnDefinition = "char(1) comment '发布状态 0-未发布 1-已发布'")
    private String publishStatus;

    @Column(name = "message_detail", columnDefinition = "longtext comment '消息描述'")
    private String messageDetail;

    @Column(name = "total_count", columnDefinition = "int(10) comment '总人数'")
    private Integer totalCount;

    @Column(name = "read_count", columnDefinition = "int(10) comment '已阅读人数'")
    private Integer readCount;

    @Column(name = "publish_time", columnDefinition = "datetime comment '发布时间'")
    private LocalDateTime publishTime;

    @Column(name = "record_id", columnDefinition = "varchar(256) comment '消息记录标识'")
    private String recordId;
}
