package com.elitescloud.cloudt.ucenter.entity;


import com.elitescloud.boot.model.entity.BaseModel;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Where;
import org.springframework.data.jpa.repository.config.EnableJpaAuditing;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;
import java.time.LocalDateTime;

@Entity
@Table(name = "sys_message_receiver", indexes = {
})
@org.hibernate.annotations.Table(appliesTo = "sys_message_receiver", comment = "消息接收者信息")
@EnableJpaAuditing
@Data
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
@Where(clause = "delete_flag = 0 or delete_flag is null")
public class MessageReceiverDO extends BaseModel implements Serializable {


    @Column(name = "message_id", columnDefinition = "bigint(20) comment '消息id'")
    private Long messageId;

    @Column(name = "emp_id", columnDefinition = "bigint(20) comment '员工id'")
    private Long empId;

    @Column(name = "emp_no", columnDefinition = "varchar(64) comment '账号'")
    private String empNo;

    @Column(name = "emp_name", columnDefinition = "varchar(64) comment '员工姓名'")
    private String empName;

    @Column(name = "mobile", columnDefinition = "varchar(64) comment '手机号'")
    private String mobile;

    @Column(name = "dept_name", columnDefinition = "varchar(64) comment '部门名称'")
    private String deptName;

    @Column(name = "read_status", columnDefinition = "char(1) comment '-1-草稿 0-未阅读 1-已阅读 阅读状态'")
    private String readStatus;

    @Column(name = "read_time", columnDefinition = "datetime comment '阅读时间'")
    private LocalDateTime readTime;
}
