package com.elitescloud.cloudt.ucenter.entity;


import com.elitescloud.boot.model.entity.BaseModel;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Where;
import org.springframework.data.jpa.repository.config.EnableJpaAuditing;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;

@Entity
@Table(name = "sys_receipt_source_config")
@org.hibernate.annotations.Table(appliesTo = "sys_receipt_source_config", comment = "单据来源配置")
@EnableJpaAuditing
@Data
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
@Where(clause = "delete_flag = 0 or delete_flag is null")
public class ReceiptSourceConfigDO extends BaseModel implements Serializable {

    @Column(name = "source_no", columnDefinition = "varchar(32) comment '来源编号'")
    private String sourceNo;

    @Column(name = "source_name", columnDefinition = "varchar(128) comment '来源名称'")
    private String sourceName;

    @Column(name = "source_type", columnDefinition = "varchar(32) comment '来源类型'")
    private String sourceType;

    @Column(name = "connect_url", columnDefinition = "varchar(128) comment '接口URL'")
    private String connectUrl;

    @Column(name = "param_value", columnDefinition = "varchar(128) comment '接口参数'")
    private String paramValue;

}
