package com.elitescloud.cloudt.ucenter.entity;

import com.elitescloud.boot.model.entity.BaseModel;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;

/**
 * 网站外观配置信息表
 *
 * @author chaofeng.xia
 * @date 2023/5/23 15:21
 */
@Entity
@Table(name = "sys_website_appearance")
@org.hibernate.annotations.Table(appliesTo = "sys_website_appearance", comment = "网站外观配置信息表")
@Data
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
@Where(clause = "delete_flag = 0 or delete_flag is null")
public class WebsiteAppearanceDO extends BaseModel implements Serializable {

    private static final long serialVersionUID = 864686640564020191L;

    @Column(name = "title", columnDefinition = "varchar(32) comment '标题'")
    private String title;

    @Column(name = "type", columnDefinition = "varchar(32) comment '网站类型'")
    private String type;

    @Column(name = "browser_logo_id", columnDefinition = "varchar(64) comment '浏览器logo图片id'")
    private String browserLogoId;

    @Column(name = "webpage_logo_id", columnDefinition = "varchar(64) comment '网页logo图片id'")
    private String webpageLogoId;

    @Column(name = "theme_color", columnDefinition = "varchar(20) comment '主题色'")
    private String themeColor;

    @Column(name = "font_size", columnDefinition = "int(10) default 12 comment '字体大小'")
    private Integer fontSize;

    @Column(name = "language", columnDefinition = "varchar(32) default 'zh_CN' comment '默认语言，默认中文'")
    private String language;

    @Column(name = "multi_language_flag", columnDefinition = "tinyint(1) default 1 comment '是否支持多语言：1是，0否'")
    private Boolean multiLanguageFlag;

    @Column(name = "menu_unfold_flag", columnDefinition = "tinyint(1) default 1 comment '菜单是否展开：1是，0否'")
    private Boolean menuUnfoldFlag;

    @Column(name = "menu_width", columnDefinition = "int(10) comment '菜单区域宽度'")
    private Integer menuWidth;

    @Column(name = "description", columnDefinition = "varchar(2048) comment '网站描述'")
    private String description;

}
