package com.elitescloud.cloudt.ucenter.entity;

import com.elitescloud.boot.model.entity.BaseModel;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;

/**
 * 网站栏目配置
 *
 * @author chaofeng.xia
 * @date 2023/5/23 15:21
 */
@Entity
@Table(name = "sys_website_bar")
@org.hibernate.annotations.Table(appliesTo = "sys_website_bar", comment = "网站栏目配置")
@Data
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
@Where(clause = "delete_flag = 0 or delete_flag is null")
public class WebsiteBarDO extends BaseModel implements Serializable {

    private static final long serialVersionUID = -2940503672919506239L;

    @Column(name = "bar_name", columnDefinition = "varchar(32) comment '栏位名称'")
    private String barName;

    @Column(name = "bar_type", columnDefinition = "varchar(32) comment '栏位类型'")
    private String barType;

    @Column(name = "bar_code", columnDefinition = "varchar(32) comment '栏位编码'")
    private String barCode;

    @Column(name = "target_type", columnDefinition = "varchar(32) comment '目标类型'")
    private String targetType;

    @Column(name = "window_open_mode", columnDefinition = "varchar(32) comment '打开方式'")
    private String windowOpenMode;

    @Column(name = "home_page_flag", columnDefinition = "tinyint(1) default 0 comment '是否为首页：1是，0否'")
    private Boolean homePageFlag;

    @Column(name = "mall_mode", columnDefinition = "varchar(32) comment '适用商城'")
    private String mallMode;

    @Column(name = "link_address", columnDefinition = "varchar(255) comment '链接地址'")
    private String linkAddress;

    @Column(name = "link_address_id", columnDefinition = "bigInt(20) comment '链接地址'")
    private Long linkAddressId;

    @Column(name = "link_type", columnDefinition = "varchar(32) comment '链接类型'")
    private String linkType;

    @Column(name = "show_flag", columnDefinition = "tinyint(1) default 1 comment '是否显示：1是，0否'")
    private Boolean showFlag;

    @Column(name = "sort_no", columnDefinition = "int(10) comment '排序'")
    private Integer sortNo;

    @Column(name = "pid", columnDefinition = "bigInt(20) comment '上级id'")
    private Long pid;

    @Column(name = "p_name", columnDefinition = "varchar(256) comment '上级栏目名称'")
    private String pName;

}
