package com.elitescloud.cloudt.ucenter.repo;

import com.elitescloud.cloudt.ucenter.entity.AdInfoDO;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.querydsl.QuerydslPredicateExecutor;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

/**
 * @auther JinXK
 * @date 2021/6/12 11:25
 */
public interface AdInfoRepo extends JpaRepository<AdInfoDO, Long>, QuerydslPredicateExecutor<AdInfoDO> {

    List<AdInfoDO> findAllByIdIn(List<Long> ids);

    @Transactional
    @Modifying
    @Query(value = "update ad_info set delete_flag = ?2 where id = ?1", nativeQuery = true)
    void deleteAdInfoById(Long id, String deleteFlag);

    boolean existsByAdCode(String adCode);

    boolean existsByAdTitle(String adTitle);

    @Transactional
    @Modifying
    @Query(value = "update ad_space set delete_flag = ?2 where id = ?1", nativeQuery = true)
    void deleteByAdSpaceId(Long adSpaceId, String deleteFlag);

    @Transactional
    @Modifying
    @Query(value = "update ad_info set delete_flag = ?2 where id in ?1", nativeQuery = true)
    Integer deleteAdInfoByIds(List<Long> deleteIds, String deleteFlag);

    @Query(value = "select id from ad_info where ad_space_id in ?1 and delete_flag = 0", nativeQuery = true)
    List<Long> findBySpaceIds(List<Long> spaceIdList);

    @Query(value = "select id from ad_info where ad_title = ?1 and ad_space_code = ?2 and delete_flag = 0", nativeQuery = true)
    AdInfoDO findByAdTitleSpaceCode(String adTitle, String adSpaceCode);

    @Transactional
    @Modifying
    @Query(value = "update ad_info set sort_no = ?2 where id = ?1", nativeQuery = true)
    Integer updateSortNoById(Long id, int sortNo);

    @Transactional
    @Modifying
    @Query(value = "update ad_info set show_flag = ?2 where id in ?1", nativeQuery = true)
    Integer updateShowFlagByIds(List<Long> ids, String showFlag);

    List<AdInfoDO> findAllByShowFlag(String valueCode);

    @Transactional
    @Modifying
    @Query(value = "update ad_info set show_flag = ?2 where id = ?1", nativeQuery = true)
    Integer updateShowFlagById(Long id, String showFlag);

    List<AdInfoDO> findByAdSpaceIdAndShowFlag(Long adSpaceId,String showFlag);

}
