package com.elitescloud.cloudt.ucenter.repo;


import cn.hutool.core.util.StrUtil;
import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.ucenter.api.dto.AdInfoDTO;
import com.elitescloud.cloudt.ucenter.api.vo.param.AdInfoPagingParam;
import com.elitescloud.cloudt.ucenter.api.vo.param.AdSpacePagingParam;
import com.elitescloud.cloudt.ucenter.entity.AdInfoDO;
import com.elitescloud.cloudt.ucenter.entity.QAdInfoDO;
import com.elitescloud.cloudt.ucenter.entity.QAdSpaceDO;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Repository;

import java.util.ArrayList;
import java.util.List;

@Repository
public class AdInfoRepoProc extends BaseRepoProc<AdInfoDO> {

    private final static QAdInfoDO Q_DO = QAdInfoDO.adInfoDO;

    private final static QAdSpaceDO Q_AD_SPACE_DO = QAdSpaceDO.adSpaceDO;

    protected AdInfoRepoProc() {
        super(Q_DO);
    }

    public PagingVO<AdInfoDTO> findAdInfoPagingResults(AdInfoPagingParam param) {
        JPAQuery<AdInfoDTO> query = select(AdInfoDTO.class)
                .leftJoin(Q_AD_SPACE_DO).on(Q_DO.adSpaceId.eq(Q_AD_SPACE_DO.id));
        List<Predicate> predicates = new ArrayList<>();
        if (StrUtil.isNotEmpty(param.getAdInfoCodeTitle())) {
            String likeStr = "%" + param.getAdInfoCodeTitle() + "%";
            predicates.add(Q_DO.adTitle.like(likeStr).or(Q_DO.adCode.like(likeStr)));
        }
        if (StrUtil.isNotEmpty(param.getShowFlag())) {
            predicates.add(Q_DO.showFlag.eq(param.getShowFlag()));
        }
        if (StrUtil.isNotEmpty(param.getAdLinkType())) {
            predicates.add(Q_DO.adLinkType.eq(param.getAdLinkType()));
        }
        if (StrUtil.isNotEmpty(param.getAdSpaceCode())) {
            predicates.add(Q_DO.adSpaceCode.eq(param.getAdSpaceCode()));
        }
        predicates.add(Q_DO.deleteFlag.eq(0).or(Q_DO.deleteFlag.isNull()));
        query.where(ExpressionUtils.allOf(predicates)).orderBy(Q_DO.showFlag.asc()).orderBy(Q_DO.sortNo.desc());
        param.fillOrders(query, Q_DO);
        param.setPaging(query);
        return PagingVO.<AdInfoDTO>builder()
                .total(query.fetchCount())
                .records(query.fetch())
                .build();
    }

    public List<AdInfoDO> findBySpaceIds(List<Long> spaceIds, String showFlag) {
        return jpaQueryFactory.select(Q_DO)
                .from(Q_DO)
                .where(Q_DO.adSpaceId.in(spaceIds).and(Q_DO.showFlag.eq(showFlag)))
                .fetch();
    }


    private <T> JPAQuery<T> select(Class<T> cls) {
        return jpaQueryFactory.select(Projections.bean(cls,
                Q_DO.id,
                Q_DO.adCode,
                Q_DO.adTitle,
                Q_DO.adSpaceId,
                Q_AD_SPACE_DO.adSpaceCode,
                Q_AD_SPACE_DO.adSpaceName,
                Q_AD_SPACE_DO.adSpaceDesc,
                Q_DO.adLinkType,
                Q_DO.showFlag,
                Q_DO.sortNo,
                Q_DO.showBeginTime,
                Q_DO.showEndTime,
                Q_DO.targetType,
                Q_DO.linkAddress,
                Q_DO.imgFileCode,
                Q_DO.videoFileCode,
                Q_DO.sourceType
        )).from(Q_DO);
    }

    private Predicate buildPredicate(AdSpacePagingParam adSpacePagingParam) {
        Predicate predicate = PredicateBuilder.builder()
                .andLike(StringUtils.isNotBlank(adSpacePagingParam.getAdSpaceCodeName()), Q_DO.adSpaceCode, adSpacePagingParam.getAdSpaceCodeName())
                .buildOr();
        return predicate;
    }
}
