package com.elitescloud.cloudt.ucenter.repo;

import com.elitescloud.cloudt.ucenter.entity.FileInfoDO;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.querydsl.QuerydslPredicateExecutor;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

/**
 * 附件
 *
 * @author chaofeng.xia
 * @date 2023/5/24 16:58
 */
@Repository
public interface FileInfoRepo extends JpaRepository<FileInfoDO, Long>, QuerydslPredicateExecutor<FileInfoDO> {

    List<FileInfoDO> findAllBySourceId(Long sourceId);

    @Transactional
    @Modifying
    @Query(value = "delete from file_info where source_id = ?1", nativeQuery = true)
    void deleteAllBySourceId(Long sourceId);

    @Transactional
    @Modifying
    @Query(value = "update file_info set delete_flag = 1 where source_id in ?1", nativeQuery = true)
    void updateByMessageIdInBatch(List<Long> publishIdList);


    @Transactional
    @Modifying
    @Query(value = "delete from file_info where source_id in ?1", nativeQuery = true)
    void deleteByMessageIdInBatch(List<Long> publishIdList);
}
