package com.elitescloud.cloudt.ucenter.repo;

import com.elitescloud.cloudt.ucenter.entity.MessageInfoDO;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.querydsl.QuerydslPredicateExecutor;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

/**
 * 自定义消息
 *
 * @author chaofeng.xia
 * @date 2023/5/24 16:58
 */
@Repository
public interface MessageInfoRepo extends JpaRepository<MessageInfoDO, Long>, QuerydslPredicateExecutor<MessageInfoDO> {

    @Transactional
    @Modifying
    @Query(value = "update message_info set delete_flag = 1 where id in ?1", nativeQuery = true)
    Integer updateByIdInBatch(List<Long> publishIdList);


    @Transactional
    @Modifying
    @Query(value = "update message_info set record_id = ?2,publish_status =?3,publish_time=now() where id = ?1", nativeQuery = true)
    void updateById(Long messageId, String recordId, String publishStatus);

    @Transactional
    @Modifying
    @Query(value = "update message_info set read_count=?1 where id = ?2", nativeQuery = true)
    void updateReadCount(Integer readCount, Long id);
}

