package com.elitescloud.cloudt.ucenter.repo;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.ucenter.api.vo.param.MessagePagingParam;
import com.elitescloud.cloudt.ucenter.api.vo.resp.MessageRespVO;
import com.elitescloud.cloudt.ucenter.entity.MessageInfoDO;
import com.elitescloud.cloudt.ucenter.entity.QMessageInfoDO;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import org.springframework.stereotype.Repository;

/**
 * 自定义消息
 *
 * @author chaofeng.xia
 * @date 2023/5/24 16:58
 */
@Repository
public class MessageInfoRepoProc extends BaseRepoProc<MessageInfoDO> {


    private final static QMessageInfoDO Q_DO = QMessageInfoDO.messageInfoDO;

    protected MessageInfoRepoProc() {
        super(Q_DO);
    }

    public PagingVO<MessageRespVO> search(MessagePagingParam param) {
        JPAQuery<MessageRespVO> query = select(MessageRespVO.class).
                where(commonBuilder(param).build())
                .orderBy(Q_DO.createTime.desc());
        param.setPaging(query);
        return PagingVO.<MessageRespVO>builder()
                .total(query.fetchCount())
                .records(query.fetch())
                .build();
    }


    private <T> JPAQuery<T> select(Class<T> cls) {
        return jpaQueryFactory.select(Projections.bean(cls,
                Q_DO.id,
                Q_DO.messageTitle,
                Q_DO.categoryCode,
                Q_DO.publishStatus,
                Q_DO.messageDetail,
                Q_DO.totalCount,
                Q_DO.publishTime,
                Q_DO.createTime,
                Q_DO.recordId,
                Q_DO.readCount
        )).from(Q_DO);
    }

    private PredicateBuilder commonBuilder(MessagePagingParam queryVO) {
        return PredicateBuilder.builder()
                .andLike(StrUtil.isNotBlank(queryVO.getMessageTitle()), Q_DO.messageTitle, queryVO.getMessageTitle())
                .andEq(StrUtil.isNotEmpty(queryVO.getCategoryCode()), Q_DO.categoryCode, queryVO.getCategoryCode())
                .andEq(StrUtil.isNotBlank(queryVO.getPublishStatus()), Q_DO.publishStatus, queryVO.getPublishStatus())
                .andGoe(ObjectUtil.isNotNull(queryVO.getBeginTime()), Q_DO.createTime, queryVO.getBeginTime())
                .andLoe(ObjectUtil.isNotNull(queryVO.getEndTime()), Q_DO.createTime, queryVO.getEndTime());
    }
}

