package com.elitescloud.cloudt.ucenter.repo;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.ucenter.api.vo.param.MessageReceiverPagingParam;
import com.elitescloud.cloudt.ucenter.api.vo.resp.MessageReceiverRespVO;
import com.elitescloud.cloudt.ucenter.entity.MessageReceiverDO;
import com.elitescloud.cloudt.ucenter.entity.QMessageReceiverDO;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import org.springframework.stereotype.Repository;

/**
 * 消息接收者
 *
 * @author chaofeng.xia
 * @date 2023/5/24 16:58
 */
@Repository
public class MessageReceiverRepoProc extends BaseRepoProc<MessageReceiverDO> {

    private final static QMessageReceiverDO Q_DO = QMessageReceiverDO.messageReceiverDO;

    protected MessageReceiverRepoProc() {
        super(Q_DO);
    }


    public PagingVO<MessageReceiverRespVO> search(MessageReceiverPagingParam param) {
        JPAQuery<MessageReceiverRespVO> query = select(MessageReceiverRespVO.class).
                where(commonBuilder(param).build());
        param.setPaging(query);
        return PagingVO.<MessageReceiverRespVO>builder()
                .total(query.fetchCount())
                .records(query.fetch())
                .build();
    }


    private <T> JPAQuery<T> select(Class<T> cls) {
        return jpaQueryFactory.select(Projections.bean(cls,
                Q_DO.id,
                Q_DO.messageId,
                Q_DO.empId,
                Q_DO.empNo,
                Q_DO.empName,
                Q_DO.mobile,
                Q_DO.deptName,
                Q_DO.readStatus,
                Q_DO.readTime
        )).from(Q_DO);
    }

    private PredicateBuilder commonBuilder(MessageReceiverPagingParam queryVO) {
        return PredicateBuilder.builder()
                .andLike(StrUtil.isNotBlank(queryVO.getEmpNo()), Q_DO.empNo, queryVO.getEmpNo())
                .andLike(StrUtil.isNotBlank(queryVO.getEmpName()), Q_DO.empName, queryVO.getEmpName())
                .andEq(ObjectUtil.isNotNull(queryVO.getMessageId()), Q_DO.messageId, queryVO.getMessageId())
                .andEq(StrUtil.isNotBlank(queryVO.getReadStatus()), Q_DO.readStatus, queryVO.getReadStatus());
    }
}

