package com.elitescloud.cloudt.ucenter.repo;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.ucenter.api.dto.ReceiptSourceConfigDetailDTO;
import com.elitescloud.cloudt.ucenter.api.vo.param.ReceiptSourceConfigPagingParam;
import com.elitescloud.cloudt.ucenter.entity.QReceiptSourceConfigDO;
import com.elitescloud.cloudt.ucenter.entity.QReceiptSourceConfigDetailDO;
import com.elitescloud.cloudt.ucenter.entity.ReceiptSourceConfigDetailDO;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import org.springframework.stereotype.Repository;

@Repository
public class ReceiptSourceConfigDetailRepoProc extends BaseRepoProc<ReceiptSourceConfigDetailDO> {
    private final static QReceiptSourceConfigDetailDO Q_DO = QReceiptSourceConfigDetailDO.receiptSourceConfigDetailDO;
    private final static QReceiptSourceConfigDO CONFIG_Q_DO = QReceiptSourceConfigDO.receiptSourceConfigDO;

    protected ReceiptSourceConfigDetailRepoProc() {
        super(Q_DO);
    }

    public PagingVO<ReceiptSourceConfigDetailDTO> detailSearchPaging(ReceiptSourceConfigPagingParam param) {
        JPAQuery<ReceiptSourceConfigDetailDTO> query = jpaQueryFactory.select(Projections.bean(
                        ReceiptSourceConfigDetailDTO.class,
                        Q_DO.id,
                        Q_DO.fieldDefinition,
                        Q_DO.fieldName,
                        Q_DO.sourceNo,
                        Q_DO.creator,
                        Q_DO.createTime,
                        Q_DO.updater,
                        Q_DO.modifyTime,
                        CONFIG_Q_DO.sourceName,
                        CONFIG_Q_DO.sourceType
                ))
                .from(Q_DO).innerJoin(CONFIG_Q_DO).on(Q_DO.masId.eq(CONFIG_Q_DO.id))
                .where(query(param).build())
                .orderBy(Q_DO.createTime.desc());
        param.setPaging(query);
        return PagingVO.<ReceiptSourceConfigDetailDTO>builder()
                .total(query.fetchCount())
                .records(query.fetch())
                .build();
    }

    private PredicateBuilder query(ReceiptSourceConfigPagingParam param) {
        return PredicateBuilder.builder()
                .andEq(ObjectUtil.isNotNull(param.getMasId()), Q_DO.masId, param.getMasId())
                .andEq(StrUtil.isNotBlank(param.getSourceNo()), Q_DO.sourceNo, param.getSourceNo());
    }

    public void deleteByMasId(Long masId) {
        jpaQueryFactory.update(Q_DO).set(Q_DO.deleteFlag, 1).where(Q_DO.masId.eq(masId)).execute();
    }
}
