package com.elitescloud.cloudt.ucenter.repo;

import cn.hutool.core.util.StrUtil;
import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.ucenter.api.dto.ReceiptSourceConfigDTO;
import com.elitescloud.cloudt.ucenter.api.vo.param.ReceiptSourceConfigPagingParam;
import com.elitescloud.cloudt.ucenter.entity.QReceiptSourceConfigDO;
import com.elitescloud.cloudt.ucenter.entity.ReceiptSourceConfigDO;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import org.springframework.stereotype.Repository;

import java.util.ArrayList;
import java.util.List;

@Repository
public class ReceiptSourceConfigRepoProc extends BaseRepoProc<ReceiptSourceConfigDO> {
    private final static QReceiptSourceConfigDO Q_DO = QReceiptSourceConfigDO.receiptSourceConfigDO;

    protected ReceiptSourceConfigRepoProc() {
        super(Q_DO);
    }

    public PagingVO<ReceiptSourceConfigDTO> searchPaging(ReceiptSourceConfigPagingParam param) {
        JPAQuery<ReceiptSourceConfigDTO> query = jpaQueryFactory.select(Projections.bean(
                ReceiptSourceConfigDTO.class,
                Q_DO.id,
                Q_DO.sourceNo,
                Q_DO.sourceName,
                Q_DO.sourceType,
                Q_DO.connectUrl,
                Q_DO.creator,
                Q_DO.createTime,
                Q_DO.updater,
                Q_DO.modifyTime,
                Q_DO.paramValue,
                Q_DO.createUserId,
                Q_DO.modifyUserId
        )).from(Q_DO);
        List<Predicate> predicates = new ArrayList<>();

        if (StrUtil.isNotBlank(param.getSourceNo())) {
            var likeStr = "%" + param.getSourceNo() + "%";
            predicates.add(Q_DO.sourceNo.like(likeStr));
        }

        if (StrUtil.isNotBlank(param.getSourceType())) {
            predicates.add(Q_DO.sourceType.eq(param.getSourceType()));
        }
        param.setPaging(query);
        query.where(ExpressionUtils.allOf(predicates));
        query.orderBy(Q_DO.createTime.desc());
        return PagingVO.<ReceiptSourceConfigDTO>builder()
                .total(query.fetchCount())
                .records(query.fetch())
                .build();
    }
}
