package com.elitescloud.cloudt.ucenter.repo;

import com.elitescloud.cloudt.ucenter.entity.WebsiteAppearanceDO;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.querydsl.QuerydslPredicateExecutor;
import org.springframework.stereotype.Repository;

/**
 * 网站外观配置信息
 *
 * @author chaofeng.xia
 * @date 2023/5/24 16:58
 */
@Repository
public interface WebsiteAppearanceRepo extends JpaRepository<WebsiteAppearanceDO, Long>, QuerydslPredicateExecutor<WebsiteAppearanceDO> {

    /**
     * 根据网站类型查询网站配置信息
     *
     * @param type 网站类型
     * @return 网站外观配置
     */
    WebsiteAppearanceDO findByType(String type);


    /**
     * 判断该类型的网站外观配置是否已经存在
     *
     * @param type 网站类型
     * @return 是否存在
     */
    Boolean existsByType(String type);
}

