package com.elitescloud.cloudt.ucenter.repo;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.ucenter.api.dto.WebsiteBarDTO;
import com.elitescloud.cloudt.ucenter.api.vo.param.WebsiteBarPagingParam;
import com.elitescloud.cloudt.ucenter.entity.QWebsiteBarDO;
import com.elitescloud.cloudt.ucenter.entity.WebsiteBarDO;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import org.springframework.stereotype.Repository;

import java.util.List;


/**
 * 网站外观配置信息
 *
 * @author chaofeng.xia
 * @date 2023/5/24 17:04
 */

@Repository
public class WebsiteBarRepoProc extends BaseRepoProc<WebsiteBarDO> {

    private static final QWebsiteBarDO Q_DO = QWebsiteBarDO.websiteBarDO;

    protected WebsiteBarRepoProc() {
        super(Q_DO);
    }

    public List<WebsiteBarDO> findByBarTypeAndPidIsNull(String barType) {
        return select(WebsiteBarDO.class)
                .where(PredicateBuilder.builder()
                        .andIsNull(true, Q_DO.pid)
                        .andEq((StrUtil.isNotBlank(barType)), Q_DO.barType, barType)
                        .build())
                .orderBy(Q_DO.sortNo.asc())
                .orderBy(Q_DO.createTime.desc()).fetch();
    }

    private <T> JPAQuery<T> select(Class<T> cls) {
        return jpaQueryFactory.select(Projections.bean(cls,
                Q_DO.id,
                Q_DO.barCode,
                Q_DO.barName,
                Q_DO.barType,
                Q_DO.targetType,
                Q_DO.linkType,
                Q_DO.linkAddress,
                Q_DO.windowOpenMode,
                Q_DO.homePageFlag,
                Q_DO.showFlag,
                Q_DO.sortNo,
                Q_DO.pid,
                Q_DO.mallMode
        )).from(Q_DO);
    }

    private PredicateBuilder commonBuilder(WebsiteBarPagingParam queryVO) {
        return PredicateBuilder.builder()
                .andLike(StrUtil.isNotEmpty(queryVO.getBarName()), Q_DO.barName, queryVO.getBarName())
                .andLike(StrUtil.isNotEmpty(queryVO.getPName()), Q_DO.pName, queryVO.getPName())
                .andEq(StrUtil.isNotEmpty(queryVO.getWindowOpenMode()), Q_DO.windowOpenMode, queryVO.getWindowOpenMode())
                .andEq(ObjectUtil.isNotNull(queryVO.getShowFlag()), Q_DO.showFlag, queryVO.getShowFlag())
                .andEq(StrUtil.isNotBlank(queryVO.getBarType()), Q_DO.barType, queryVO.getBarType())
                .andEq(StrUtil.isNotBlank(queryVO.getLinkType()), Q_DO.linkType, queryVO.getLinkType())
                .andEq(StrUtil.isNotBlank(queryVO.getMallMode()), Q_DO.mallMode, queryVO.getMallMode())
                .andEq(ObjectUtil.isNotNull(queryVO.getHomePageFlag()), Q_DO.homePageFlag, queryVO.getHomePageFlag());
    }

    public List<WebsiteBarDTO> findAll(WebsiteBarPagingParam param) {
        return select(WebsiteBarDTO.class)
                .where(commonBuilder(param).build())
                .orderBy(Q_DO.showFlag.desc())
                .orderBy(Q_DO.sortNo.desc())
                .orderBy(Q_DO.createTime.desc())
                .fetch();
    }

    public PagingVO<WebsiteBarDTO> search(WebsiteBarPagingParam param) {
        JPAQuery<WebsiteBarDTO> query = select(WebsiteBarDTO.class).
                where(Q_DO.id.in(param.getPidSet()))
                .orderBy(Q_DO.showFlag.desc())
                .orderBy(Q_DO.sortNo.desc())
                .orderBy(Q_DO.createTime.desc());
        param.setPaging(query);
        return PagingVO.<WebsiteBarDTO>builder()
                .total(query.fetchCount())
                .records(query.fetch())
                .build();
    }
}

