package com.elitescloud.cloudt.ucenter.rmi;

import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.exception.BusinessException;
import com.elitescloud.cloudt.core.udc.UdcProvider;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.HashSet;
import java.util.List;
import java.util.Map;

/**
 * @author Danny.Wang
 * @title RmiOrgOuService
 * @Date2023/1/28 15:05
 */
@Slf4j
@Component
public class RmiSysUDCService {

    @Autowired
    private UdcProvider sysUdcService;

    public Map<String, String> getCodeMap(String domain, String udc) {
        try{
            return sysUdcService.getValueMapByUdcCode(domain, udc);
        }catch (Exception e){
            log.error("查询UDC异常:{}", e.getMessage());
            throw new BusinessException(ApiCode.FAIL, "查询UDC信息接口异常");
        }
    }

    public Map<String, Map<String, String>> getCodeMap(String domain, List<String> udcCodes) {
        try{
            return sysUdcService.getValueMapByUdcCode(domain, new HashSet<>(udcCodes));
        }catch (Exception e){
            log.error("查询UDC异常:{}", e.getMessage());
            throw new BusinessException(ApiCode.FAIL, "查询UDC信息接口异常");
        }
    }
}
