package com.elitescloud.cloudt.ucenter.service;

import com.elitescloud.cloudt.ucenter.api.vo.save.WebsiteAppearanceSaveVO;
import com.elitescloud.cloudt.ucenter.api.vo.resp.WebsiteAppearanceVO;
import org.springframework.stereotype.Service;


/**
 * 网站外观配置信息
 *
 * @author chaofeng.xia
 * @date 2023/5/26 16:07
 */
@Service
public interface WebsiteAppearanceService {

    /**
     * 查询-根据网站类型查询
     *
     * @param type 网站类型
     * @return 网站外观配置信息
     */
    WebsiteAppearanceVO findByType(String type);

    /**
     * 保存网站外观配置信息
     *
     * @param appearanceSaveVO 网站外观配置信息
     * @return 网站id
     */
    Long save(WebsiteAppearanceSaveVO appearanceSaveVO);

    /**
     * 查询-根据网站类型查询
     *
     * @param id 网站id
     * @return 网站外观配置信息
     */
    WebsiteAppearanceVO findById(Long id);
}
