package com.elitescloud.cloudt.ucenter.utils;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import com.elitescloud.boot.core.base.UdcProvider;
import com.elitescloud.cloudt.ucenter.common.constant.ConstantsUcenter;
import com.elitescloud.cloudt.ucenter.common.constant.UdcEnum;
import com.elitescloud.cloudt.ucenter.rmi.RmiSysNextNumberService;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

/**
 * @author Chris
 * @date 2021-06-26
 */
@Slf4j
@Service
@RequiredArgsConstructor
public class SysGenerator {
    private final RmiSysNextNumberService rmiSysNextNumberService;
    private final UdcProvider udcProvider;

    public String generateCode(String ruleCode) {
        String code = rmiSysNextNumberService
                .generateCode(ConstantsUcenter.YST_UCENTER, ruleCode, Collections.emptyList());
        return code;
    }

    public String getUdcName(String udcCode, String valueCode) {
        Set<String> udcCodeSet = Arrays.stream(UdcEnum.values()).map(udcEnum -> udcEnum.getCode()).collect(Collectors.toSet());
        Map<String, Map<String, String>> udcCodeValueMap = udcProvider.getValueMapByUdcCode(ConstantsUcenter.YST_UCENTER, udcCodeSet);
        Map<String, String> map = udcCodeValueMap.get(udcCode);
        return CollectionUtil.isEmpty(map) ? null : StrUtil.isBlank(valueCode) ? null : map.get(valueCode);

    }
}
