-- ----------------------------
-- Table structure for com_payment_term table_code
-- ----------------------------
CREATE TABLE IF NOT EXISTS `com_payment_term`
(
    `id`                 bigint(20)   NOT NULL COMMENT '记录唯一ID',
    `pt_code`            varchar(40)  NULL DEFAULT NULL COMMENT '代码',
    `pt_name`            varchar(40)  NULL DEFAULT NULL COMMENT '名称',
    `days`               int(11)      NULL DEFAULT NULL COMMENT '天数',
    `base_day_type`      varchar(40)  NULL DEFAULT NULL COMMENT '基于日期类型',
    `day_calc_method`    varchar(40)  NULL DEFAULT NULL COMMENT '日期计算方式 是否含工作日',
    `valid_from`         datetime     NULL DEFAULT NULL COMMENT '生效日期',
    `valid_to`           datetime     NULL DEFAULT NULL COMMENT '失效日期',
    `enable_flag`        int(11)      NULL DEFAULT 0 COMMENT '是否有效',
    `account_code`       varchar(40)  NULL DEFAULT NULL COMMENT '对账报账编码',
    `tenant_id`          bigint(20)   NULL DEFAULT NULL COMMENT '租户ID',
    `remark`             varchar(255) NULL DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint(20)   NULL DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255) NULL DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime(6)  NULL DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint(20)   NULL DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255) NULL DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime(6)  NULL DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int(11)      NULL DEFAULT NULL COMMENT '记录最后更新时间',
    `audit_data_version` int(11)      NULL DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`          bigint(20)   NULL DEFAULT NULL COMMENT 'sec_bu_id',
    `sec_user_id`        bigint(20)   NULL DEFAULT NULL COMMENT 'sec_user_id',
    `sec_ou_id`          bigint(20)   NULL DEFAULT NULL COMMENT 'sec_ou_id',
    `belong_org_id`      bigint(20)   NULL DEFAULT NULL COMMENT '所属组织ID',
    `tenant_org_id`      bigint(20)   NULL DEFAULT NULL COMMENT '租户组织ID',
    PRIMARY KEY (`id`) USING BTREE
) COMMENT = '支付条款 币种 此表使用CODE来引用，不使用ID。';

-- ----------------------------
-- Table structure for sys_currency_rate
-- ----------------------------
CREATE TABLE IF NOT EXISTS `sys_currency_rate`
(
    `id`                 bigint(20)     NOT NULL COMMENT '记录唯一ID',
    `from_curr`          varchar(255)   NOT NULL COMMENT '自货币码',
    `to_curr`            varchar(255)   NOT NULL COMMENT '至货币码',
    `ratio`              decimal(20, 8) NOT NULL COMMENT '汇率',
    `cal_method`         varchar(255)   NOT NULL COMMENT '算法',
    `enabled`            bit(1)         NULL DEFAULT b'1' COMMENT '是否启用',
    `valid_from`         datetime(6)    NULL DEFAULT NULL COMMENT '有效时间-起始',
    `valid_to`           datetime(6)    NULL DEFAULT NULL COMMENT '有效时间-截止',
    `tenant_id`          bigint(20)     NULL DEFAULT -1 COMMENT '所属租户ID',
    `belong_org_id`      bigint(20)     NULL DEFAULT NULL COMMENT '所属组织ID',
    `tenant_org_id`      bigint(20)     NULL DEFAULT NULL COMMENT '租户组织ID',
    `remark`             varchar(255)   NULL DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint(20)     NULL DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255)   NULL DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime(6)    NULL DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint(20)     NULL DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255)   NULL DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime(6)    NULL DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int(11)        NULL DEFAULT 0 COMMENT '记录最后更新时间',
    `audit_data_version` int(11)        NULL DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`          bigint(20)     NULL DEFAULT NULL COMMENT '数据归属组织id',
    `sec_user_id`        bigint(20)     NULL DEFAULT NULL COMMENT '数据归属雇员id',
    `sec_ou_id`          bigint(20)     NULL DEFAULT NULL COMMENT '数据归属公司id',
    PRIMARY KEY (`id`) USING BTREE,
    INDEX `idx_currency_rate_from` (`from_curr`) USING BTREE
) COMMENT = '汇率';


-- ----------------------------
-- Table structure for sys_dpcr_api_fields
-- ----------------------------
CREATE TABLE IF NOT EXISTS `sys_dpcr_api_fields`
(
    `id`                 bigint(20)   NOT NULL COMMENT '记录唯一ID',
    `role_id`            bigint(20)   NULL DEFAULT NULL COMMENT '角色id',
    `app_code`           varchar(255) NULL DEFAULT NULL COMMENT '应用编码',
    `menu_code`          varchar(255) NULL DEFAULT NULL COMMENT '菜单编码',
    `api_code`           varchar(255) NULL DEFAULT NULL COMMENT '接口编码',
    `field_name`         varchar(255) NULL DEFAULT NULL COMMENT '字段名称',
    `field_remark`       varchar(255) NULL DEFAULT NULL COMMENT '字段描述',
    `field_api_visible`  bit(1)       NULL DEFAULT NULL COMMENT 'api可见',
    `field_form_visible` bit(1)       NULL DEFAULT NULL COMMENT '表单可见',
    `field_form_update`  bit(1)       NULL DEFAULT NULL COMMENT '表单可编辑',
    `tenant_id`          bigint(20)   NULL DEFAULT -1 COMMENT '所属租户ID',
    `belong_org_id`      bigint(20)   NULL DEFAULT NULL COMMENT '所属组织ID',
    `tenant_org_id`      bigint(20)   NULL DEFAULT NULL COMMENT '租户组织ID',
    `remark`             varchar(255) NULL DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint(20)   NULL DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255) NULL DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime(6)  NULL DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint(20)   NULL DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255) NULL DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime(6)  NULL DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int(11)      NULL DEFAULT 0 COMMENT '删除标记',
    `audit_data_version` int(11)      NULL DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`          bigint(20)   NULL DEFAULT NULL COMMENT '数据归属组织id',
    `sec_user_id`        bigint(20)   NULL DEFAULT NULL COMMENT '数据归属雇员id',
    `sec_ou_id`          bigint(20)   NULL DEFAULT NULL COMMENT '数据归属公司id',
    PRIMARY KEY (`id`) USING BTREE,
    INDEX `idx_dpcr_api_field_role` (`role_id`) USING BTREE,
    INDEX `idx_dpcr_api_field_app` (`app_code`) USING BTREE,
    INDEX `idx_dpcr_api_field_menu` (`menu_code`) USING BTREE,
    INDEX `idx_dpcr_api_field_api` (`api_code`) USING BTREE
) COMMENT = '角色-应用-菜单-API-列权限字段权限字符串表 ';

-- ----------------------------
-- Table structure for sys_dpr_role_api_rule
-- ----------------------------
CREATE TABLE IF NOT EXISTS `sys_dpr_role_api_rule`
(
    `id`                        bigint(20)    NOT NULL COMMENT '记录唯一ID',
    `role_id`                   bigint(20)    NULL DEFAULT NULL COMMENT '角色id',
    `app_code`                  varchar(255)  NULL DEFAULT NULL COMMENT '应用编码',
    `menu_code`                 varchar(255)  NULL DEFAULT NULL COMMENT '菜单编码',
    `api_code`                  varchar(255)  NULL DEFAULT NULL COMMENT 'Api Code',
    `dpr_rule_group_id`         bigint(20)    NULL DEFAULT NULL COMMENT '行规则组id',
    `dpr_rule_id`               bigint(20)    NULL DEFAULT NULL COMMENT '行规则id',
    `role_rule_value`           varchar(2000) NULL DEFAULT NULL COMMENT '自定义值',
    `role_rule_value_type`      varchar(200)  NULL DEFAULT NULL COMMENT '自定义值填写类型（组件，自填）',
    `rule_order`                double        NULL DEFAULT NULL COMMENT '规则排序',
    `rule_do_json`              longtext      NULL COMMENT '原始规则Json',
    `tenant_id`                 bigint(20)    NULL DEFAULT -1 COMMENT '所属租户ID',
    `belong_org_id`             bigint(20)    NULL DEFAULT NULL COMMENT '所属组织ID',
    `tenant_org_id`             bigint(20)    NULL DEFAULT NULL COMMENT '租户组织ID',
    `remark`                    varchar(255)  NULL DEFAULT NULL COMMENT '备注',
    `create_user_id`            bigint(20)    NULL DEFAULT NULL COMMENT '记录创建者ID',
    `creator`                   varchar(255)  NULL DEFAULT NULL COMMENT '记录创建者',
    `create_time`               datetime(6)   NULL DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`            bigint(20)    NULL DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`                   varchar(255)  NULL DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`               datetime(6)   NULL DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`               int(11)       NULL DEFAULT 0 COMMENT '记录最后更新时间',
    `audit_data_version`        int(11)       NULL DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`                 bigint(20)    NULL DEFAULT NULL COMMENT '数据归属组织id',
    `sec_user_id`               bigint(20)    NULL DEFAULT NULL COMMENT '数据归属雇员id',
    `sec_ou_id`                 bigint(20)    NULL DEFAULT NULL COMMENT '数据归属公司id',
    `dpr_rule_relation`         varchar(200)  NULL DEFAULT NULL COMMENT '规则关系',
    `dpr_rule_relation_name`    varchar(200)  NULL DEFAULT NULL COMMENT '规则关系名称',
    `dpr_rule_name`             varchar(200)  NULL DEFAULT NULL COMMENT '规则名称',
    `dpr_rule_declare`          varchar(2000) NULL DEFAULT NULL COMMENT '规则描述',
    `dpr_rule_field`            varchar(100)  NULL DEFAULT NULL COMMENT '规则字段',
    `dpr_rule_field_type`       varchar(100)  NULL DEFAULT NULL COMMENT '规则字段类型',
    `dpr_rule_field_type_name`  varchar(200)  NULL DEFAULT NULL COMMENT '规则条件类型名称',
    `dpr_rule_field_declare`    varchar(2000) NULL DEFAULT NULL COMMENT '规则字段描述',
    `dpr_rule_condition`        varchar(200)  NULL DEFAULT NULL COMMENT '规则条件类型',
    `dpr_rule_condition_name`   varchar(200)  NULL DEFAULT NULL COMMENT '规则条件类型名称',
    `dpr_rule_value_type`       varchar(200)  NULL DEFAULT NULL COMMENT '规则值类型',
    `dpr_rule_value_type_name`  varchar(200)  NULL DEFAULT NULL COMMENT '规则值类型名称',
    `dpr_rule_value`            varchar(2000) NULL DEFAULT NULL COMMENT '规则值',
    `dpr_rule_value_declare`    varchar(2000) NULL DEFAULT NULL COMMENT '规则值说明',
    `dpr_sys_internally`        varchar(200)  NULL DEFAULT NULL COMMENT '系统上下文内置类型枚举',
    `dpr_sys_internally_name`   varchar(200)  NULL DEFAULT NULL COMMENT '系统上下文内置类型名称',
    `data_range`                bit(1)        NULL DEFAULT NULL COMMENT '是否是数据范围',
    `dpr_rule_value_name`       varchar(2000) NULL DEFAULT NULL COMMENT '规则值名称',
    `data_set`                  varchar(255)  NULL DEFAULT NULL COMMENT '数据集类型',
    PRIMARY KEY (`id`) USING BTREE,
    INDEX `idx_dpr_row_role` (`role_id`) USING BTREE,
    INDEX `idx_dpr_row_app` (`app_code`) USING BTREE,
    INDEX `idx_dpr_row_menu` (`menu_code`) USING BTREE,
    INDEX `idx_dpr_row_api` (`api_code`) USING BTREE
) COMMENT = '角色-应用-菜单-API-行规则';

-- ----------------------------
-- Table structure for sys_emp_group
-- ----------------------------
CREATE TABLE IF NOT EXISTS `sys_emp_group`
(
    `id`                 bigint(20)   NOT NULL COMMENT '记录唯一ID',
    `code`               varchar(255) NOT NULL COMMENT '员工组编号',
    `name`               varchar(255) NOT NULL COMMENT '员工组名称',
    `type`               varchar(255) NULL DEFAULT NULL COMMENT '类型，[UDC]cloudt-system:empGroupType',
    `sort_no`            int(11)      NULL DEFAULT 0 COMMENT '顺序',
    `enabled`            bit(1)       NULL DEFAULT b'1' COMMENT '是否启用',
    `tenant_id`          bigint(20)   NULL DEFAULT -1 COMMENT '所属租户ID',
    `belong_org_id`      bigint(20)   NULL DEFAULT NULL COMMENT '所属组织ID',
    `tenant_org_id`      bigint(20)   NULL DEFAULT NULL COMMENT '租户组织ID',
    `remark`             varchar(255) NULL DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint(20)   NULL DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255) NULL DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime(6)  NULL DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint(20)   NULL DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255) NULL DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime(6)  NULL DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int(11)      NULL DEFAULT 0 COMMENT '记录最后更新时间',
    `audit_data_version` int(11)      NULL DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`          bigint(20)   NULL DEFAULT NULL COMMENT '数据归属组织id',
    `sec_user_id`        bigint(20)   NULL DEFAULT NULL COMMENT '数据归属雇员id',
    `sec_ou_id`          bigint(20)   NULL DEFAULT NULL COMMENT '数据归属公司id',
    PRIMARY KEY (`id`) USING BTREE,
    INDEX `idx_emp_group_code` (`code`) USING BTREE,
    INDEX `idx_emp_group_type` (`type`) USING BTREE
) COMMENT = '员工组';

-- ----------------------------
-- Table structure for sys_emp_group_emp
-- ----------------------------
CREATE TABLE IF NOT EXISTS `sys_emp_group_emp`
(
    `id`                 bigint(20)   NOT NULL COMMENT '记录唯一ID',
    `group_id`           bigint(20)   NOT NULL COMMENT '员工组ID',
    `emp_id`             bigint(20)   NOT NULL COMMENT '员工ID',
    `tenant_id`          bigint(20)   NULL DEFAULT -1 COMMENT '所属租户ID',
    `belong_org_id`      bigint(20)   NULL DEFAULT NULL COMMENT '所属组织ID',
    `tenant_org_id`      bigint(20)   NULL DEFAULT NULL COMMENT '租户组织ID',
    `remark`             varchar(255) NULL DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint(20)   NULL DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255) NULL DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime(6)  NULL DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint(20)   NULL DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255) NULL DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime(6)  NULL DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int(11)      NULL DEFAULT 0 COMMENT '记录最后更新时间',
    `audit_data_version` int(11)      NULL DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`          bigint(20)   NULL DEFAULT NULL COMMENT '数据归属组织id',
    `sec_user_id`        bigint(20)   NULL DEFAULT NULL COMMENT '数据归属雇员id',
    `sec_ou_id`          bigint(20)   NULL DEFAULT NULL COMMENT '数据归属公司id',
    PRIMARY KEY (`id`) USING BTREE,
    INDEX `idx_emp_group_emp_g` (`group_id`) USING BTREE,
    INDEX `idx_emp_group_emp_e` (`emp_id`) USING BTREE
) COMMENT = '员工组的员工';

-- ----------------------------
-- Table structure for sys_employee
-- ----------------------------
CREATE TABLE IF NOT EXISTS `sys_employee`
(
    `id`                  bigint(20)   NOT NULL COMMENT '记录唯一ID',
    `tenant_id`           bigint(20)   NULL DEFAULT NULL COMMENT '所属租户ID',
    `belong_org_id`       bigint(20)   NULL DEFAULT NULL COMMENT '所属组织ID',
    `remark`              varchar(255) NULL DEFAULT NULL COMMENT '备注',
    `create_user_id`      bigint(20)   NULL DEFAULT NULL COMMENT '记录创建者ID',
    `creator`             varchar(255) NULL DEFAULT NULL COMMENT '记录创建者',
    `create_time`         datetime(6)  NULL DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`      bigint(20)   NULL DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`             varchar(255) NULL DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`         datetime(6)  NULL DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`         int(11)      NULL DEFAULT 0 COMMENT '记录最后更新时间',
    `audit_data_version`  int(11)      NULL DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`           bigint(20)   NULL DEFAULT NULL COMMENT '数据归属组织id',
    `sec_user_id`         bigint(20)   NULL DEFAULT NULL COMMENT '数据归属雇员id',
    `sec_ou_id`           bigint(20)   NULL DEFAULT NULL COMMENT '数据归属公司id',
    `user_id`             bigint(20)   NOT NULL COMMENT '用户账号ID',
    `root_org_id`         bigint(20)   NOT NULL COMMENT '根组织ID',
    `last_name`           varchar(255) NULL DEFAULT NULL COMMENT '姓名-姓氏',
    `first_name`          varchar(255) NULL DEFAULT NULL COMMENT '姓名-名字',
    `gender`              varchar(255) NULL DEFAULT NULL COMMENT '性别，（male-男，female-女，secret-保密）',
    `code`                varchar(255) NULL DEFAULT NULL COMMENT '员工编号',
    `email`               varchar(255) NULL DEFAULT NULL COMMENT '工作邮箱',
    `phone`               varchar(255) NULL DEFAULT NULL COMMENT '办公电话',
    `join_time`           datetime(6)  NULL DEFAULT NULL COMMENT '入职时间',
    `leave_time`          datetime(6)  NULL DEFAULT NULL COMMENT '离职时间',
    `type`                varchar(255) NULL DEFAULT NULL COMMENT '员工类型，[UDC]EMPLOYEE:TYPE',
    `photo`               varchar(255) NULL DEFAULT NULL COMMENT '员工照片',
    `contract_start_time` datetime(6)  NULL DEFAULT NULL COMMENT '合同起始时间',
    `contract_end_time`   datetime(6)  NULL DEFAULT NULL COMMENT '合同截止时间',
    `enabled`             bit(1)       NULL DEFAULT b'1' COMMENT '是否启用',
    `sort_no`             int(11)      NULL DEFAULT 1 COMMENT '顺序',
    `served`              bit(1)       NULL DEFAULT b'1' COMMENT '是否在职',
    `tenant_org_id`       bigint(20)   NULL DEFAULT NULL COMMENT '租户组织ID',
    `duty`                varchar(255) NULL DEFAULT NULL COMMENT '职务',
    `username`            varchar(255) NULL DEFAULT NULL COMMENT '用户账号',
    PRIMARY KEY (`id`) USING BTREE,
    INDEX `idx_sys_emp_user_id` (`user_id`) USING BTREE,
    INDEX `idx_sys_emp_root_org_id` (`root_org_id`) USING BTREE,
    INDEX `idx_sys_emp_code` (`code`) USING BTREE,
    INDEX `idx_sys_emp_type` (`type`) USING BTREE,
    INDEX `idx_sys_emp_email` (`email`) USING BTREE
) COMMENT = '员工';

-- ----------------------------
-- Table structure for sys_employee_org
-- ----------------------------
CREATE TABLE IF NOT EXISTS `sys_employee_org`
(
    `id`                 bigint(20)   NOT NULL COMMENT '记录唯一ID',
    `tenant_id`          bigint(20)   NULL DEFAULT NULL COMMENT '所属租户ID',
    `belong_org_id`      bigint(20)   NULL DEFAULT NULL COMMENT '所属组织ID',
    `remark`             varchar(255) NULL DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint(20)   NULL DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255) NULL DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime(6)  NULL DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint(20)   NULL DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255) NULL DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime(6)  NULL DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int(11)      NULL DEFAULT 0 COMMENT '记录最后更新时间',
    `audit_data_version` int(11)      NULL DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`          bigint(20)   NULL DEFAULT NULL COMMENT '数据归属组织id',
    `sec_user_id`        bigint(20)   NULL DEFAULT NULL COMMENT '数据归属雇员id',
    `sec_ou_id`          bigint(20)   NULL DEFAULT NULL COMMENT '数据归属公司id',
    `user_id`            bigint(20)   NOT NULL COMMENT '用户账号ID',
    `employee_id`        bigint(20)   NOT NULL COMMENT '员工ID',
    `root_org_id`        bigint(20)   NOT NULL COMMENT '所属根组织ID',
    `org_id`             bigint(20)   NOT NULL COMMENT '所属组织ID',
    `join_time`          datetime(6)  NOT NULL COMMENT '加入时间',
    `tenant_org_id`      bigint(20)   NULL DEFAULT NULL COMMENT '租户组织ID',
    `enabled`            bit(1)       NULL DEFAULT b'1' COMMENT '是否启用',
    `leader_user_id`     bigint(20)   NULL DEFAULT NULL COMMENT '领导用户ID',
    `leader_employee_id` bigint(20)   NULL DEFAULT NULL COMMENT '领导的员工ID',
    PRIMARY KEY (`id`) USING BTREE,
    INDEX `idx_sys_emp_org_user_id` (`user_id`) USING BTREE,
    INDEX `idx_sys_emp_org_emp_id` (`employee_id`) USING BTREE,
    INDEX `idx_sys_emp_org_root_org_id` (`root_org_id`) USING BTREE,
    INDEX `idx_sys_emp_org_org_id` (`org_id`) USING BTREE,
    INDEX `idx_sys_emp_org_leader` (`leader_user_id`) USING BTREE,
    INDEX `idx_emp_org_leader_emp` (`leader_employee_id`) USING BTREE
) COMMENT = '员工组织';

-- ----------------------------
-- Table structure for sys_front_table_cfg
-- ----------------------------
CREATE TABLE IF NOT EXISTS `sys_front_table_cfg`
(
    `id`                 bigint(20)   NOT NULL COMMENT '记录唯一ID',
    `table_code`         varchar(255) NOT NULL COMMENT '表格编码',
    `owner_id`           bigint(20)   NOT NULL COMMENT '拥有者ID',
    `owner_type`         varchar(255) NOT NULL COMMENT '拥有者类型',
    `config`             longtext     NULL COMMENT '配置内容',
    `tenant_id`          bigint(20)   NULL DEFAULT -1 COMMENT '所属租户ID',
    `belong_org_id`      bigint(20)   NULL DEFAULT NULL COMMENT '所属组织ID',
    `tenant_org_id`      bigint(20)   NULL DEFAULT NULL COMMENT '租户组织ID',
    `remark`             varchar(255) NULL DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint(20)   NULL DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255) NULL DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime(6)  NULL DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint(20)   NULL DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255) NULL DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime(6)  NULL DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int(11)      NULL DEFAULT 0 COMMENT '删除标记',
    `audit_data_version` int(11)      NULL DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`          bigint(20)   NULL DEFAULT NULL COMMENT '数据归属组织id',
    `sec_user_id`        bigint(20)   NULL DEFAULT NULL COMMENT '数据归属雇员id',
    `sec_ou_id`          bigint(20)   NULL DEFAULT NULL COMMENT '数据归属公司id',
    PRIMARY KEY (`id`) USING BTREE,
    INDEX `idx_front_table_cfg_code` (`table_code`) USING BTREE,
    INDEX `idx_front_table_cfg_owner` (`owner_id`) USING BTREE
) COMMENT = '前端表格配置';

-- ----------------------------
-- Table structure for sys_id_generator
-- ----------------------------
CREATE TABLE IF NOT EXISTS `sys_id_generator`
(
    `id`               varchar(255) NOT NULL COMMENT '主键ID',
    `gen_type`         varchar(255) NOT NULL COMMENT '生成器类型',
    `data_center_name` varchar(255) NOT NULL COMMENT '数据中心名称',
    `data_center_id`   int(11)      NOT NULL COMMENT '数据中心ID',
    `worker_id`        int(11)      NOT NULL COMMENT 'WorkerID',
    `instance_ip`      varchar(255) NULL DEFAULT NULL COMMENT '实例IP',
    `create_time`      datetime(6)  NULL DEFAULT NULL COMMENT '创建时间',
    `modify_time`      datetime(6)  NULL DEFAULT NULL COMMENT '更新时间',
    PRIMARY KEY (`id`) USING BTREE,
    UNIQUE INDEX `idx_id_gen_uid` (`data_center_id`, `worker_id`) USING BTREE,
    INDEX `idx_id_gen_dcname` (`data_center_name`) USING BTREE
);

-- ----------------------------
-- Table structure for sys_menu_favor
-- ----------------------------
CREATE TABLE IF NOT EXISTS `sys_menu_favor`
(
    `id`                 bigint(20)   NOT NULL COMMENT '记录唯一ID',
    `user_id`            bigint(20)   NOT NULL COMMENT '用户ID',
    `menu_code`          varchar(255) NOT NULL COMMENT '原菜单编码',
    `menu_name`          varchar(255) NULL DEFAULT NULL COMMENT '显示名称',
    `sort_no`            int(11)      NULL DEFAULT 0 COMMENT '排序号',
    `enabled`            bit(1)       NULL DEFAULT b'1' COMMENT '是否启用',
    `tenant_id`          bigint(20)   NULL DEFAULT NULL COMMENT '所属租户ID',
    `belong_org_id`      bigint(20)   NULL DEFAULT NULL COMMENT '所属组织ID',
    `remark`             varchar(255) NULL DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint(20)   NULL DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255) NULL DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime(6)  NULL DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint(20)   NULL DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255) NULL DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime(6)  NULL DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int(11)      NULL DEFAULT 0 COMMENT '记录最后更新时间',
    `audit_data_version` int(11)      NULL DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`          bigint(20)   NULL DEFAULT NULL COMMENT '数据归属组织id',
    `sec_user_id`        bigint(20)   NULL DEFAULT NULL COMMENT '数据归属雇员id',
    `sec_ou_id`          bigint(20)   NULL DEFAULT NULL COMMENT '数据归属公司id',
    `tenant_org_id`      bigint(20)   NULL DEFAULT NULL COMMENT '租户组织ID',
    PRIMARY KEY (`id`) USING BTREE,
    INDEX `idx_menu_favor_user` (`user_id`) USING BTREE
) COMMENT = '收藏菜单';

CREATE TABLE IF NOT EXISTS `sys_mq_retry`
(
    `id`                 bigint(20) NOT NULL COMMENT '记录唯一ID',
    `message_id`         varchar(255) DEFAULT NULL COMMENT '消息ID',
    `retry_times`        int(11)      DEFAULT '0' COMMENT '发送重试的次数',
    `send_time`          datetime(6)  DEFAULT NULL COMMENT '上次发送时间',
    `send_time_next`     datetime(6)  DEFAULT NULL COMMENT '下次发送时间',
    `tenant_id`          bigint(20)   DEFAULT '-1' COMMENT '所属租户ID',
    `belong_org_id`      bigint(20)   DEFAULT NULL COMMENT '所属组织ID',
    `tenant_org_id`      bigint(20)   DEFAULT NULL COMMENT '租户组织ID',
    `remark`             varchar(255) DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint(20)   DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255) DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime(6)  DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint(20)   DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime(6)  DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int(11)      DEFAULT '0' COMMENT '删除标记',
    `audit_data_version` int(11)      DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`          bigint(20)   DEFAULT NULL COMMENT '数据归属组织id',
    `sec_user_id`        bigint(20)   DEFAULT NULL COMMENT '数据归属雇员id',
    `sec_ou_id`          bigint(20)   DEFAULT NULL COMMENT '数据归属公司id',
    `consumer`           bit(1)       DEFAULT NULL COMMENT '是否是消费失败',
    PRIMARY KEY (`id`),
    KEY `idx_mq_msg_msgid` (`message_id`)
) COMMENT ='MQ消息发送记录';

CREATE TABLE IF NOT EXISTS `sys_mq_message`
(
    `id`                    bigint(20)   NOT NULL COMMENT '记录唯一ID',
    `app_code`              varchar(255) DEFAULT NULL COMMENT '应用编码',
    `channel`               varchar(255) NOT NULL COMMENT '渠道编码',
    `message_content`       longtext COMMENT '消息内容',
    `send_time`             datetime(6)  DEFAULT NULL COMMENT '发送时间',
    `finish_time`           datetime(6)  DEFAULT NULL COMMENT '发送结束时间',
    `local`                 bit(1)       DEFAULT NULL COMMENT '是否本地化消费',
    `success`               bit(1)       DEFAULT NULL COMMENT '是否发送成功',
    `fail_reason`           longtext COMMENT '发送失败原因',
    `tenant_id`             bigint(20)   DEFAULT '-1' COMMENT '所属租户ID',
    `belong_org_id`         bigint(20)   DEFAULT NULL COMMENT '所属组织ID',
    `tenant_org_id`         bigint(20)   DEFAULT NULL COMMENT '租户组织ID',
    `remark`                varchar(255) DEFAULT NULL COMMENT '备注',
    `create_user_id`        bigint(20)   DEFAULT NULL COMMENT '记录创建者ID',
    `creator`               varchar(255) DEFAULT NULL COMMENT '记录创建者',
    `create_time`           datetime(6)  DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`        bigint(20)   DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`               varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`           datetime(6)  DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`           int(11)      DEFAULT '0' COMMENT '删除标记',
    `audit_data_version`    int(11)      DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`             bigint(20)   DEFAULT NULL COMMENT '数据归属组织id',
    `sec_user_id`           bigint(20)   DEFAULT NULL COMMENT '数据归属雇员id',
    `sec_ou_id`             bigint(20)   DEFAULT NULL COMMENT '数据归属公司id',
    `message_id`            varchar(255) DEFAULT NULL COMMENT '消息ID',
    `sys_tenant_id`         bigint(20)   DEFAULT NULL COMMENT '租户ID',
    `retry_times`           int(11)      DEFAULT '0' COMMENT '发送重试的次数',
    `retried`               bit(1)       DEFAULT b'0' COMMENT '是否是重试消息',
    `retry_fail_reason`     varchar(255) DEFAULT NULL COMMENT '重试失败原因',
    `original_message_id`   varchar(255) DEFAULT NULL COMMENT '原始消息ID',
    `consumed`              bit(1)       DEFAULT b'0' COMMENT '是否已消费',
    `consume_time`          datetime(6)  DEFAULT NULL COMMENT '消费时间',
    `last_retry_message_id` varchar(255) DEFAULT NULL COMMENT '最后一次重试的消息ID',
    PRIMARY KEY (`id`),
    KEY `idx_mq_msg_appcode` (`app_code`),
    KEY `idx_mq_msg_channel` (`channel`),
    KEY `idx_mq_msg_sendtime` (`send_time`),
    KEY `idx_mq_msg_success` (`success`),
    KEY `idx_mq_msg_msgid` (`message_id`),
    KEY `idx_mq_msg_tenantid` (`sys_tenant_id`)
) COMMENT ='MQ消息记录';

CREATE TABLE IF NOT EXISTS `sys_mq_consume`
(
    `id`                  bigint(20) NOT NULL COMMENT '记录唯一ID',
    `message_id`          varchar(255) DEFAULT NULL COMMENT '消息ID',
    `record_id`           bigint(20)   DEFAULT NULL COMMENT '消息记录ID',
    `app_code`            varchar(255) DEFAULT NULL COMMENT '应用编码',
    `consumer_name`       varchar(255) DEFAULT NULL COMMENT '消费者名称',
    `consumer_ip`         varchar(255) DEFAULT NULL COMMENT '消费者IP',
    `consume_time`        datetime(6)  DEFAULT NULL COMMENT '消费时间',
    `success`             bit(1)       DEFAULT b'0' COMMENT '是否消费成功',
    `fail_reason`         longtext COMMENT '消费失败原因',
    `original_message_id` varchar(255) DEFAULT NULL COMMENT '原始消息ID',
    `tenant_id`           bigint(20)   DEFAULT '-1' COMMENT '所属租户ID',
    `belong_org_id`       bigint(20)   DEFAULT NULL COMMENT '所属组织ID',
    `tenant_org_id`       bigint(20)   DEFAULT NULL COMMENT '租户组织ID',
    `remark`              varchar(255) DEFAULT NULL COMMENT '备注',
    `create_user_id`      bigint(20)   DEFAULT NULL COMMENT '记录创建者ID',
    `creator`             varchar(255) DEFAULT NULL COMMENT '记录创建者',
    `create_time`         datetime(6)  DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`      bigint(20)   DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`             varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`         datetime(6)  DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`         int(11)      DEFAULT '0' COMMENT '删除标记',
    `audit_data_version`  int(11)      DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`           bigint(20)   DEFAULT NULL COMMENT '数据归属组织id',
    `sec_user_id`         bigint(20)   DEFAULT NULL COMMENT '数据归属雇员id',
    `sec_ou_id`           bigint(20)   DEFAULT NULL COMMENT '数据归属公司id',
    PRIMARY KEY (`id`),
    KEY `idx_mq_con_msgid` (`message_id`),
    KEY `idx_mq_con_recod` (`record_id`)
) COMMENT ='MQ消息消费记录';

-- ----------------------------
-- Table structure for sys_msg_send_record
-- ----------------------------
CREATE TABLE IF NOT EXISTS `sys_msg_send_record`
(
    `id`                  bigint(20)    NOT NULL COMMENT '记录唯一ID',
    `msg_type`            varchar(40)   NULL DEFAULT NULL COMMENT '消息类型-枚举（模板、自定义）',
    `send_user_id`        varchar(40)   NULL DEFAULT NULL COMMENT '发送人id',
    `send_user_name`      varchar(40)   NULL DEFAULT NULL COMMENT '发送人名称',
    `recipient_user_name` varchar(40)   NULL DEFAULT NULL COMMENT '接收人名称',
    `recipient_user_id`   varchar(40)   NULL DEFAULT NULL COMMENT '接收人id',
    `send_time`           datetime(6)   NULL DEFAULT NULL COMMENT '发送时间',
    `batch_uuid`          varchar(200)  NULL DEFAULT NULL COMMENT '批量号',
    `tenant_id`           bigint(20)    NULL DEFAULT -1 COMMENT '所属租户ID',
    `belong_org_id`       bigint(20)    NULL DEFAULT NULL COMMENT '所属组织ID',
    `tenant_org_id`       bigint(20)    NULL DEFAULT NULL COMMENT '租户组织ID',
    `remark`              varchar(255)  NULL DEFAULT NULL COMMENT '备注',
    `create_user_id`      bigint(20)    NULL DEFAULT NULL COMMENT '记录创建者ID',
    `creator`             varchar(255)  NULL DEFAULT NULL COMMENT '记录创建者',
    `create_time`         datetime(6)   NULL DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`      bigint(20)    NULL DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`             varchar(255)  NULL DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`         datetime(6)   NULL DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`         int(11)       NULL DEFAULT 0 COMMENT '删除标记',
    `audit_data_version`  int(11)       NULL DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`           bigint(20)    NULL DEFAULT NULL COMMENT '数据归属组织id',
    `sec_user_id`         bigint(20)    NULL DEFAULT NULL COMMENT '数据归属雇员id',
    `sec_ou_id`           bigint(20)    NULL DEFAULT NULL COMMENT '数据归属公司id',
    `send_user_code`      varchar(40)   NULL DEFAULT NULL COMMENT '发送人编码',
    `recipient_user_code` varchar(40)   NULL DEFAULT NULL COMMENT '发送人编码',
    `template_code`       varchar(200)  NULL DEFAULT NULL COMMENT '模板编码',
    `template_name`       varchar(200)  NULL DEFAULT NULL COMMENT '模板名称',
    `custom_param_json`   varchar(2000) NULL DEFAULT NULL COMMENT '自定义参数json',
    PRIMARY KEY (`id`) USING BTREE,
    INDEX `index_msgType` (`msg_type`) USING BTREE,
    INDEX `index_sendUserId` (`send_user_id`) USING BTREE,
    INDEX `index_sendTime` (`send_time`) USING BTREE,
    INDEX `index_batchUuid` (`batch_uuid`) USING BTREE,
    INDEX `index_recipientUserName` (`recipient_user_name`) USING BTREE,
    INDEX `index_recipientUserId` (`recipient_user_id`) USING BTREE
) COMMENT = '消息发送主记录';

-- ----------------------------
-- Table structure for sys_msg_send_record_dtl
-- ----------------------------
CREATE TABLE IF NOT EXISTS `sys_msg_send_record_dtl`
(
    `id`                       bigint(20)    NOT NULL COMMENT '记录唯一ID',
    `msg_send_record_id`       bigint(20)    NULL DEFAULT NULL COMMENT '消息发送主表',
    `msg_type`                 varchar(200)  NULL DEFAULT NULL COMMENT '消息类型-枚举-模板-自定义',
    `send_state`               varchar(40)   NULL DEFAULT NULL COMMENT '发送状态-枚举-发送中，成功，失败',
    `sent_type_code`           varchar(200)  NULL DEFAULT NULL COMMENT '发送类型-短信-邮箱-站内信-站内提醒websoket',
    `send_type_name`           varchar(200)  NULL DEFAULT NULL COMMENT '发送类型名称',
    `sent_time_start`          datetime(6)   NULL DEFAULT NULL COMMENT '发送时间',
    `sent_time_end`            datetime(6)   NULL DEFAULT NULL COMMENT '发送回执时间',
    `sent_end_message`         varchar(2000) NULL DEFAULT NULL COMMENT '发送回执信息',
    `sent_err_message`         longtext      NULL COMMENT '发送系统内异常信息',
    `send_user_id`             varchar(40)   NULL DEFAULT NULL COMMENT '发送人id',
    `send_user_name`           varchar(200)  NULL DEFAULT NULL COMMENT '发送人名称',
    `recipient_user_name`      varchar(200)  NULL DEFAULT NULL COMMENT '接收人名称',
    `recipient_user_id`        varchar(40)   NULL DEFAULT NULL COMMENT '接收人id',
    `template_id`              bigint(20)    NULL DEFAULT NULL COMMENT '模板id',
    `template_code`            varchar(200)  NULL DEFAULT NULL COMMENT '模板编码',
    `template_name`            varchar(200)  NULL DEFAULT NULL COMMENT '模板名称',
    `subject`                  varchar(200)  NULL DEFAULT NULL COMMENT '主题-暂定udc',
    `title_content`            varchar(200)  NULL DEFAULT NULL COMMENT '标题内容',
    `message_content`          longtext      NULL COMMENT '消息内容',
    `external_template_id`     varchar(200)  NULL DEFAULT NULL COMMENT '外部模板id',
    `extend1`                  varchar(500)  NULL DEFAULT NULL COMMENT '扩展参数1',
    `extend2`                  varchar(500)  NULL DEFAULT NULL COMMENT '扩展参数2',
    `extend3`                  varchar(500)  NULL DEFAULT NULL COMMENT '扩展参数3',
    `extend4`                  varchar(500)  NULL DEFAULT NULL COMMENT '扩展参数4',
    `extend5`                  varchar(500)  NULL DEFAULT NULL COMMENT '扩展参数5',
    `read_flg`                 bit(1)        NULL DEFAULT NULL COMMENT '是否已读',
    `read_time`                varchar(200)  NULL DEFAULT NULL COMMENT '已读时间',
    `batch_uuid`               varchar(200)  NULL DEFAULT NULL COMMENT '批量号',
    `tenant_id`                bigint(20)    NULL DEFAULT -1 COMMENT '所属租户ID',
    `belong_org_id`            bigint(20)    NULL DEFAULT NULL COMMENT '所属组织ID',
    `tenant_org_id`            bigint(20)    NULL DEFAULT NULL COMMENT '租户组织ID',
    `remark`                   varchar(255)  NULL DEFAULT NULL COMMENT '备注',
    `create_user_id`           bigint(20)    NULL DEFAULT NULL COMMENT '记录创建者ID',
    `creator`                  varchar(255)  NULL DEFAULT NULL COMMENT '记录创建者',
    `create_time`              datetime(6)   NULL DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`           bigint(20)    NULL DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`                  varchar(255)  NULL DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`              datetime(6)   NULL DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`              int(11)       NULL DEFAULT 0 COMMENT '删除标记',
    `audit_data_version`       int(11)       NULL DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`                bigint(20)    NULL DEFAULT NULL COMMENT '数据归属组织id',
    `sec_user_id`              bigint(20)    NULL DEFAULT NULL COMMENT '数据归属雇员id',
    `sec_ou_id`                bigint(20)    NULL DEFAULT NULL COMMENT '数据归属公司id',
    `send_user_code`           varchar(40)   NULL DEFAULT NULL COMMENT '发送人编码',
    `recipient_user_code`      varchar(40)   NULL DEFAULT NULL COMMENT '发送人编码',
    `template_send_param_json` longtext      NULL COMMENT '模板发送参数json',
    `custom_param_json`        varchar(2000) NULL DEFAULT NULL COMMENT '自定义json参数',
    PRIMARY KEY (`id`) USING BTREE,
    INDEX `index_templateCode` (`template_code`) USING BTREE,
    INDEX `index_msgSendRecordId` (`msg_send_record_id`) USING BTREE,
    INDEX `index_sendState` (`send_state`) USING BTREE,
    INDEX `index_sentTypeCode` (`sent_type_code`) USING BTREE,
    INDEX `index_msgType` (`msg_type`) USING BTREE,
    INDEX `index_sendUserId` (`send_user_id`) USING BTREE,
    INDEX `index_sentTimeStart` (`sent_time_start`) USING BTREE,
    INDEX `index_batchUuid` (`batch_uuid`) USING BTREE,
    INDEX `index_recipientUserName` (`recipient_user_name`) USING BTREE,
    INDEX `index_recipientUserId` (`recipient_user_id`) USING BTREE,
    INDEX `idx_msg_rdl_sendusercode` (`send_user_code`) USING BTREE,
    INDEX `idx_msg_rdl_recipentusercode` (`recipient_user_code`) USING BTREE
) COMMENT = '消息发送明细表';

-- ----------------------------
-- Table structure for sys_msg_send_type
-- ----------------------------
CREATE TABLE IF NOT EXISTS `sys_msg_send_type`
(
    `id`                    bigint(20)   NOT NULL COMMENT '记录唯一ID',
    `send_type_code`        varchar(200) NULL DEFAULT NULL COMMENT '类型编码',
    `send_type_name`        varchar(200) NULL DEFAULT NULL COMMENT '类型名称',
    `send_type_config_json` longtext     NULL COMMENT '类型配置json，邮箱，短信等-站内信-站内提醒websoket',
    `tenant_id`             bigint(20)   NULL DEFAULT -1 COMMENT '所属租户ID',
    `belong_org_id`         bigint(20)   NULL DEFAULT NULL COMMENT '所属组织ID',
    `tenant_org_id`         bigint(20)   NULL DEFAULT NULL COMMENT '租户组织ID',
    `remark`                varchar(255) NULL DEFAULT NULL COMMENT '备注',
    `create_user_id`        bigint(20)   NULL DEFAULT NULL COMMENT '记录创建者ID',
    `creator`               varchar(255) NULL DEFAULT NULL COMMENT '记录创建者',
    `create_time`           datetime(6)  NULL DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`        bigint(20)   NULL DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`               varchar(255) NULL DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`           datetime(6)  NULL DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`           int(11)      NULL DEFAULT 0 COMMENT '删除标记',
    `audit_data_version`    int(11)      NULL DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`             bigint(20)   NULL DEFAULT NULL COMMENT '数据归属组织id',
    `sec_user_id`           bigint(20)   NULL DEFAULT NULL COMMENT '数据归属雇员id',
    `sec_ou_id`             bigint(20)   NULL DEFAULT NULL COMMENT '数据归属公司id',
    PRIMARY KEY (`id`) USING BTREE
) COMMENT = '发送类型配置表（暂时配置文件，不建表）';

-- ----------------------------
-- Table structure for sys_msg_template
-- ----------------------------
CREATE TABLE IF NOT EXISTS `sys_msg_template`
(
    `id`                 bigint(20)   NOT NULL COMMENT '记录唯一ID',
    `template_code`      varchar(200) NULL DEFAULT NULL COMMENT '模板编码',
    `template_name`      varchar(200) NULL DEFAULT NULL COMMENT '模板名称',
    `template_group`     varchar(200) NULL DEFAULT NULL COMMENT '模板分组-UDC',
    `template_describe`  varchar(500) NULL DEFAULT NULL COMMENT '模板描述',
    `tenant_id`          bigint(20)   NULL DEFAULT -1 COMMENT '所属租户ID',
    `belong_org_id`      bigint(20)   NULL DEFAULT NULL COMMENT '所属组织ID',
    `tenant_org_id`      bigint(20)   NULL DEFAULT NULL COMMENT '租户组织ID',
    `remark`             varchar(255) NULL DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint(20)   NULL DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255) NULL DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime(6)  NULL DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint(20)   NULL DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255) NULL DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime(6)  NULL DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int(11)      NULL DEFAULT 0 COMMENT '删除标记',
    `audit_data_version` int(11)      NULL DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`          bigint(20)   NULL DEFAULT NULL COMMENT '数据归属组织id',
    `sec_user_id`        bigint(20)   NULL DEFAULT NULL COMMENT '数据归属雇员id',
    `sec_ou_id`          bigint(20)   NULL DEFAULT NULL COMMENT '数据归属公司id',
    PRIMARY KEY (`id`) USING BTREE,
    INDEX `index_templateCode` (`template_code`) USING BTREE,
    INDEX `index_templateName` (`template_name`) USING BTREE
) COMMENT = '消息模板主表';

-- ----------------------------
-- Table structure for sys_msg_template_config
-- ----------------------------
CREATE TABLE IF NOT EXISTS `sys_msg_template_config`
(
    `id`                    bigint(20)   NOT NULL COMMENT '记录唯一ID',
    `template_id`           bigint(20)   NULL DEFAULT NULL COMMENT '模板id',
    `template_code`         varchar(200) NULL DEFAULT NULL COMMENT '模板编码',
    `template_name`         varchar(200) NULL DEFAULT NULL COMMENT '模板名称',
    `send_type_code`        varchar(200) NULL DEFAULT NULL COMMENT '发送类型',
    `send_type_switch`      bit(1)       NULL DEFAULT NULL COMMENT '发送类型开关',
    `send_type_name`        varchar(200) NULL DEFAULT NULL COMMENT '发送类型',
    `mes_subject`           varchar(200) NULL DEFAULT NULL COMMENT '主题-暂定udc/暂时无用',
    `mes_title`             varchar(200) NULL DEFAULT NULL COMMENT '标题',
    `mes_rich_content_sign` bit(1)       NULL DEFAULT NULL COMMENT '是否富文本',
    `external_template_id`  varchar(500) NULL DEFAULT NULL COMMENT '外部模板id',
    `external_sign_name`    varchar(1000) NULL DEFAULT NULL COMMENT '签名',
    `mes_text`              longtext     NULL COMMENT '内容',
    `tenant_id`             bigint(20)   NULL DEFAULT -1 COMMENT '所属租户ID',
    `belong_org_id`         bigint(20)   NULL DEFAULT NULL COMMENT '所属组织ID',
    `tenant_org_id`         bigint(20)   NULL DEFAULT NULL COMMENT '租户组织ID',
    `remark`                varchar(255) NULL DEFAULT NULL COMMENT '备注',
    `create_user_id`        bigint(20)   NULL DEFAULT NULL COMMENT '记录创建者ID',
    `creator`               varchar(255) NULL DEFAULT NULL COMMENT '记录创建者',
    `create_time`           datetime(6)  NULL DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`        bigint(20)   NULL DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`               varchar(255) NULL DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`           datetime(6)  NULL DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`           int(11)      NULL DEFAULT 0 COMMENT '删除标记',
    `audit_data_version`    int(11)      NULL DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`             bigint(20)   NULL DEFAULT NULL COMMENT '数据归属组织id',
    `sec_user_id`           bigint(20)   NULL DEFAULT NULL COMMENT '数据归属雇员id',
    `sec_ou_id`             bigint(20)   NULL DEFAULT NULL COMMENT '数据归属公司id',
    PRIMARY KEY (`id`) USING BTREE,
    INDEX `index_templateId` (`template_id`) USING BTREE,
    INDEX `index_sendTypeCode` (`send_type_code`) USING BTREE,
    INDEX `index_templateCode` (`template_code`) USING BTREE,
    INDEX `index_templateName` (`template_name`) USING BTREE
) COMMENT = '模板发送配置';

-- ----------------------------
-- Table structure for sys_operation_config
-- ----------------------------
CREATE TABLE IF NOT EXISTS `sys_operation_config`
(
    `id`                 bigint(20)   NOT NULL AUTO_INCREMENT COMMENT '配置主键',
    `trigger_terminal`   varchar(64)  NULL DEFAULT NULL COMMENT '触发端(从那里访问,例如中台管理等)',
    `sys_model`          varchar(64)  NULL DEFAULT NULL COMMENT '系统版块,被访问的系统模块',
    `operation_type`     varchar(32)  NULL DEFAULT NULL COMMENT '操作类型,crud 等，当前访问的具体操作',
    `operation_url`      varchar(512) NULL DEFAULT NULL COMMENT '请求地址',
    `enabled`            tinyint(4)   NULL DEFAULT 1 COMMENT '是否可用:1: 可用,0:不可用',
    `tenant_id`          bigint(20)   NULL DEFAULT NULL COMMENT '所属租户ID',
    `belong_org_id`      bigint(20)   NULL DEFAULT NULL COMMENT '所属组织ID',
    `remark`             varchar(255) NULL DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint(20)   NULL DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255) NULL DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime(6)  NULL DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint(20)   NULL DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255) NULL DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime(6)  NULL DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int(11)      NULL DEFAULT 0 COMMENT '删除标记',
    `audit_data_version` int(11)      NULL DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`          bigint(20)   NULL DEFAULT NULL COMMENT '数据归属组织id',
    `sec_user_id`        bigint(20)   NULL DEFAULT NULL COMMENT '数据归属雇员id',
    `sec_ou_id`          bigint(20)   NULL DEFAULT NULL COMMENT '数据归属公司id',
    `tenant_org_id`      bigint(20)   NULL DEFAULT NULL COMMENT '租户组织ID',
    PRIMARY KEY (`id`) USING BTREE,
    INDEX `operation_url_index` (`operation_url`) USING BTREE
) COMMENT = '系统操作日志配置表--根据url查询对应的版块信息等';

-- ----------------------------
-- Table structure for sys_operation_log
-- ----------------------------
CREATE TABLE IF NOT EXISTS `sys_operation_log`
(
    `id`                 bigint(20)   NOT NULL AUTO_INCREMENT COMMENT '日志主键',
    `trigger_terminal`   varchar(64)  NULL DEFAULT NULL COMMENT '触发端(从那里访问,例如中台管理等)',
    `sys_model`          varchar(64)  NULL DEFAULT NULL COMMENT '系统版块,被访问的系统模块',
    `operation_type`     varchar(32)  NULL DEFAULT NULL COMMENT '操作类型,crud 等，当前访问的具体操作',
    `operation_user`     varchar(32)  NULL DEFAULT NULL COMMENT '操作账号',
    `operation_url`      varchar(512) NULL DEFAULT NULL COMMENT '请求地址',
    `operation_time`     datetime     NULL DEFAULT NULL COMMENT '操作时间',
    `operation_ip`       varchar(32)  NULL DEFAULT NULL COMMENT '访问的ip',
    `operation_status`   varchar(16)  NULL DEFAULT NULL COMMENT '操作状态',
    `requ_method`        varchar(16)  NULL DEFAULT NULL COMMENT '请求方式(GET,POST等)',
    `requ_param`         longtext     NULL COMMENT '请求参数',
    `resp_param`         longtext     NULL COMMENT '返回参数',
    `tenant_id`          bigint(20)   NULL DEFAULT NULL COMMENT '所属租户ID',
    `belong_org_id`      bigint(20)   NULL DEFAULT NULL COMMENT '所属组织ID',
    `remark`             varchar(255) NULL DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint(20)   NULL DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255) NULL DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime(6)  NULL DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint(20)   NULL DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255) NULL DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime(6)  NULL DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int(11)      NULL DEFAULT 0 COMMENT '记录最后更新时间',
    `audit_data_version` int(11)      NULL DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`          bigint(20)   NULL DEFAULT NULL COMMENT '数据归属组织id',
    `sec_user_id`        bigint(20)   NULL DEFAULT NULL COMMENT '数据归属雇员id',
    `sec_ou_id`          bigint(20)   NULL DEFAULT NULL COMMENT '数据归属公司id',
    `tenant_org_id`      bigint(20)   NULL DEFAULT NULL COMMENT '租户组织ID',
    PRIMARY KEY (`id`) USING BTREE
) COMMENT = '系统操作日志--从网关获取信息,保存在此';

-- ----------------------------
-- Table structure for sys_org
-- ----------------------------
CREATE TABLE IF NOT EXISTS `sys_org`
(
    `id`                 bigint(20)   NOT NULL COMMENT '记录唯一ID',
    `tenant_id`          bigint(20)   NULL DEFAULT NULL COMMENT '所属租户ID',
    `belong_org_id`      bigint(20)   NULL DEFAULT NULL COMMENT '所属组织ID',
    `remark`             varchar(255) NULL DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint(20)   NULL DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255) NULL DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime(6)  NULL DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint(20)   NULL DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255) NULL DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime(6)  NULL DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int(11)      NULL DEFAULT 0 COMMENT '记录最后更新时间',
    `audit_data_version` int(11)      NULL DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`          bigint(20)   NULL DEFAULT NULL COMMENT '数据归属组织id',
    `sec_user_id`        bigint(20)   NULL DEFAULT NULL COMMENT '数据归属雇员id',
    `sec_ou_id`          bigint(20)   NULL DEFAULT NULL COMMENT '数据归属公司id',
    `p_id`               bigint(20)   NULL DEFAULT -1 COMMENT '上级节点ID',
    `root_id`            bigint(20)   NULL DEFAULT NULL COMMENT '根节点ID',
    `lft`                int(11)      NULL DEFAULT NULL COMMENT '左节点序号',
    `rgt`                int(11)      NULL DEFAULT NULL COMMENT '右节点序号',
    `depth`              int(11)      NULL DEFAULT NULL COMMENT '深度',
    `code`               varchar(255) NOT NULL COMMENT '组织编码',
    `name`               varchar(255) NOT NULL COMMENT '组织名称',
    `parent_code`        varchar(255) NULL DEFAULT NULL COMMENT '上级组织编码',
    `short_name`         varchar(255) NULL DEFAULT NULL COMMENT '简称',
    `type`               varchar(255) NULL DEFAULT NULL COMMENT '类型，[UDC]ORG:TYPE',
    `entity`             bit(1)       NULL DEFAULT b'1' COMMENT '是否是实体组织',
    `sort_no`            int(11)      NULL DEFAULT 0 COMMENT '顺序',
    `enabled`            bit(1)       NULL DEFAULT b'1' COMMENT '是否启用',
    `tenant_org_id`      bigint(20)   NULL DEFAULT NULL COMMENT '租户组织ID',
    `executive`          bit(1)       NULL DEFAULT b'1' COMMENT '是否行政组织',
    `ou_id`              bigint(20)   NULL DEFAULT NULL COMMENT '所属公司ID',
    PRIMARY KEY (`id`) USING BTREE,
    INDEX `idx_org_code` (`code`) USING BTREE,
    INDEX `idx_org_parent_code` (`parent_code`) USING BTREE,
    INDEX `idx_org_parent_type` (`type`) USING BTREE,
    INDEX `idx_org_pid` (`p_id`) USING BTREE,
    INDEX `idx_org_rootid` (`root_id`) USING BTREE,
    INDEX `idx_org_lft` (`lft`) USING BTREE,
    INDEX `idx_org_rgt` (`rgt`) USING BTREE
) COMMENT = '组织';

-- ----------------------------
-- Table structure for sys_ou
-- ----------------------------
CREATE TABLE IF NOT EXISTS `sys_ou`
(
    `id`                 bigint(20)   NOT NULL COMMENT '记录唯一ID',
    `ou_code`            varchar(255) NOT NULL COMMENT '公司编码',
    `ou_name`            varchar(255) NOT NULL COMMENT '公司名称',
    `ou_abbr`            varchar(255) NULL DEFAULT NULL COMMENT '简称',
    `ou_type`            varchar(255) NULL DEFAULT NULL COMMENT '公司类型，[UDC]cloudt-system:ouType',
    `sort_no`            int(11)      NULL DEFAULT 0 COMMENT '顺序',
    `enabled`            bit(1)       NULL DEFAULT b'0' COMMENT '是否启用',
    `legal_person`       varchar(255) NULL DEFAULT NULL COMMENT '公司法人',
    `ic_register_no`     varchar(255) NULL DEFAULT NULL COMMENT '工商登记号',
    `phone`              varchar(255) NULL DEFAULT NULL COMMENT '电话号',
    `email`              varchar(255) NULL DEFAULT NULL COMMENT '公司邮箱',
    `legal_ou_id`        bigint(20)   NULL DEFAULT NULL COMMENT '法人公司ID',
    `region`             varchar(255) NULL DEFAULT NULL COMMENT '所属区域，[UDC]cloudt-system:region',
    `province_code`      varchar(255) NULL DEFAULT NULL COMMENT '所在地-省份编码',
    `city_code`          varchar(255) NULL DEFAULT NULL COMMENT '所在地-市编码',
    `county_code`        varchar(255) NULL DEFAULT NULL COMMENT '所在地-县编码',
    `address`            varchar(255) NULL DEFAULT NULL COMMENT '详细地址',
    `tenant_id`          bigint(20)   NULL DEFAULT -1 COMMENT '所属租户ID',
    `belong_org_id`      bigint(20)   NULL DEFAULT NULL COMMENT '所属组织ID',
    `tenant_org_id`      bigint(20)   NULL DEFAULT NULL COMMENT '租户组织ID',
    `remark`             varchar(255) NULL DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint(20)   NULL DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255) NULL DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime(6)  NULL DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint(20)   NULL DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255) NULL DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime(6)  NULL DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int(11)      NULL DEFAULT 0 COMMENT '记录最后更新时间',
    `audit_data_version` int(11)      NULL DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`          bigint(20)   NULL DEFAULT NULL COMMENT '数据归属组织id',
    `sec_user_id`        bigint(20)   NULL DEFAULT NULL COMMENT '数据归属雇员id',
    `sec_ou_id`          bigint(20)   NULL DEFAULT NULL COMMENT '数据归属公司id',
    `pinyin`             varchar(255) NULL DEFAULT NULL COMMENT '名称拼音',
    PRIMARY KEY (`id`) USING BTREE,
    INDEX `idx_ou_code` (`ou_code`) USING BTREE,
    INDEX `idx_ou_name` (`ou_name`) USING BTREE
) COMMENT = '公司';

-- ----------------------------
-- Table structure for sys_platform_admin_menus
-- ----------------------------
CREATE TABLE IF NOT EXISTS `sys_platform_admin_menus`
(
    `id`                 bigint(20)   NOT NULL COMMENT '记录唯一ID',
    `tenant_id`          bigint(20)   NULL DEFAULT NULL COMMENT '所属租户ID',
    `belong_org_id`      bigint(20)   NULL DEFAULT NULL COMMENT '所属组织ID',
    `remark`             varchar(255) NULL DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint(20)   NULL DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255) NULL DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime(6)  NULL DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint(20)   NULL DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255) NULL DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime(6)  NULL DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int(11)      NULL DEFAULT 0 COMMENT '记录最后更新时间',
    `audit_data_version` int(11)      NULL DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`          bigint(20)   NULL DEFAULT NULL COMMENT '数据归属组织id',
    `sec_user_id`        bigint(20)   NULL DEFAULT NULL COMMENT '数据归属雇员id',
    `sec_ou_id`          bigint(20)   NULL DEFAULT NULL COMMENT '数据归属公司id',
    `admin_type`         varchar(40)  NULL DEFAULT NULL COMMENT '管理员类型',
    `menus_code`         varchar(400) NULL DEFAULT NULL COMMENT '菜单编码',
    `tenant_org_id`      bigint(20)   NULL DEFAULT NULL COMMENT '租户组织ID',
    PRIMARY KEY (`id`) USING BTREE,
    INDEX `idx_admin_menu_type` (`admin_type`) USING BTREE
) COMMENT = '管理员菜单';

-- ----------------------------
-- Table structure for sys_platform_api_manage
-- ----------------------------
CREATE TABLE IF NOT EXISTS `sys_platform_api_manage`
(
    `id`                 bigint(20)   NOT NULL COMMENT '记录唯一ID',
    `app_code`           varchar(255) NULL DEFAULT NULL COMMENT '接口所属应用',
    `api_name`           varchar(255) NULL DEFAULT NULL COMMENT '接口名称',
    `api_code`           varchar(255) NULL DEFAULT NULL COMMENT '接口编号',
    `request_type`       varchar(255) NULL DEFAULT NULL COMMENT '请求类型',
    `api_path`           varchar(255) NULL DEFAULT NULL COMMENT '请求路径',
    `api_describe`       varchar(255) NULL DEFAULT NULL COMMENT '接口描述',
    `tenant_id`          bigint(20)   NULL DEFAULT -1 COMMENT '所属租户ID',
    `belong_org_id`      bigint(20)   NULL DEFAULT NULL COMMENT '所属组织ID',
    `tenant_org_id`      bigint(20)   NULL DEFAULT NULL COMMENT '租户组织ID',
    `remark`             varchar(255) NULL DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint(20)   NULL DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255) NULL DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime(6)  NULL DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint(20)   NULL DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255) NULL DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime(6)  NULL DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int(11)      NULL DEFAULT 0 COMMENT '删除标记',
    `audit_data_version` int(11)      NULL DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`          bigint(20)   NULL DEFAULT NULL COMMENT '数据归属组织id',
    `sec_user_id`        bigint(20)   NULL DEFAULT NULL COMMENT '数据归属雇员id',
    `sec_ou_id`          bigint(20)   NULL DEFAULT NULL COMMENT '数据归属公司id',
    PRIMARY KEY (`id`) USING BTREE,
    UNIQUE INDEX `idx_api_code` (`api_code`) USING BTREE,
    INDEX `idx_api_app` (`app_code`) USING BTREE
) COMMENT = '接口管理';

-- ----------------------------
-- Table structure for sys_platform_api_parameter
-- ----------------------------
CREATE TABLE IF NOT EXISTS `sys_platform_api_parameter`
(
    `id`                 bigint(20)   NOT NULL COMMENT '记录唯一ID',
    `api_id`             bigint(20)   NULL DEFAULT NULL COMMENT '字段所属接口id',
    `api_code`           varchar(255) NULL DEFAULT NULL COMMENT '字段所属接口编码',
    `field_name`         varchar(255) NULL DEFAULT NULL COMMENT '字段名称',
    `field_type`         varchar(255) NULL DEFAULT NULL COMMENT '字段类型',
    `field_is_null`      bit(1)       NULL DEFAULT NULL COMMENT '字段是否可以为空',
    `field_explain`      varchar(255) NULL DEFAULT NULL COMMENT '字段说明',
    `in_out_type`        varchar(32)  NULL DEFAULT NULL COMMENT '字段类型',
    `tenant_id`          bigint(20)   NULL DEFAULT -1 COMMENT '所属租户ID',
    `belong_org_id`      bigint(20)   NULL DEFAULT NULL COMMENT '所属组织ID',
    `tenant_org_id`      bigint(20)   NULL DEFAULT NULL COMMENT '租户组织ID',
    `remark`             varchar(255) NULL DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint(20)   NULL DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255) NULL DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime(6)  NULL DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint(20)   NULL DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255) NULL DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime(6)  NULL DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int(11)      NULL DEFAULT 0 COMMENT '删除标记',
    `audit_data_version` int(11)      NULL DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`          bigint(20)   NULL DEFAULT NULL COMMENT '数据归属组织id',
    `sec_user_id`        bigint(20)   NULL DEFAULT NULL COMMENT '数据归属雇员id',
    `sec_ou_id`          bigint(20)   NULL DEFAULT NULL COMMENT '数据归属公司id',
    PRIMARY KEY (`id`) USING BTREE
) COMMENT = '接口字段';

-- ----------------------------
-- Table structure for sys_platform_api_permission
-- ----------------------------
CREATE TABLE IF NOT EXISTS `sys_platform_api_permission`
(
    `id`                 bigint(20)   NOT NULL COMMENT '记录唯一ID',
    `tenant_id`          bigint(20)   NULL DEFAULT NULL COMMENT '所属租户ID',
    `belong_org_id`      bigint(20)   NULL DEFAULT NULL COMMENT '所属组织ID',
    `remark`             varchar(255) NULL DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint(20)   NULL DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255) NULL DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime(6)  NULL DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint(20)   NULL DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255) NULL DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime(6)  NULL DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int(11)      NULL DEFAULT 0 COMMENT '记录最后更新时间',
    `audit_data_version` int(11)      NULL DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`          bigint(20)   NULL DEFAULT NULL COMMENT '数据归属组织id',
    `sec_user_id`        bigint(20)   NULL DEFAULT NULL COMMENT '数据归属雇员id',
    `sec_ou_id`          bigint(20)   NULL DEFAULT NULL COMMENT '数据归属公司id',
    `app_code`           varchar(255) NULL DEFAULT NULL COMMENT '应用编码',
    `menus_code`         varchar(255) NULL DEFAULT NULL COMMENT '菜单编码',
    `permisson_path`     varchar(255) NULL DEFAULT NULL COMMENT '权限路径',
    `permisson_name`     varchar(255) NULL DEFAULT NULL COMMENT '权限名称',
    `permisson_code`     varchar(255) NULL DEFAULT NULL COMMENT '权限编码',
    `request_type`       varchar(255) NULL DEFAULT NULL COMMENT '请求类型',
    `permisson_describe` varchar(255) NULL DEFAULT NULL COMMENT '描述',
    `tenant_org_id`      bigint(20)   NULL DEFAULT NULL COMMENT '租户组织ID',
    PRIMARY KEY (`id`) USING BTREE,
    UNIQUE INDEX `idx_api_permissioncode` (`permisson_code`) USING BTREE,
    INDEX `idx_api_appcode` (`app_code`) USING BTREE,
    INDEX `idx_api_menucode` (`menus_code`) USING BTREE
) COMMENT = 'api权限配置';

-- ----------------------------
-- Table structure for sys_platform_app
-- ----------------------------
CREATE TABLE IF NOT EXISTS `sys_platform_app`
(
    `id`                 bigint(20)   NOT NULL COMMENT '记录唯一ID',
    `tenant_id`          bigint(20)   NULL DEFAULT NULL COMMENT '所属租户ID',
    `belong_org_id`      bigint(20)   NULL DEFAULT NULL COMMENT '所属组织ID',
    `remark`             varchar(255) NULL DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint(20)   NULL DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255) NULL DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime(6)  NULL DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint(20)   NULL DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255) NULL DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime(6)  NULL DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int(11)      NULL DEFAULT 0 COMMENT '记录最后更新时间',
    `audit_data_version` int(11)      NULL DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`          bigint(20)   NULL DEFAULT NULL COMMENT '数据归属组织id',
    `sec_user_id`        bigint(20)   NULL DEFAULT NULL COMMENT '数据归属雇员id',
    `sec_ou_id`          bigint(20)   NULL DEFAULT NULL COMMENT '数据归属公司id',
    `app_code`           varchar(40)  NULL DEFAULT NULL COMMENT '应用编码',
    `app_name`           varchar(40)  NULL DEFAULT NULL COMMENT '应用名称',
    `app_type`           varchar(40)  NULL DEFAULT NULL COMMENT '应用类型',
    `app_describe`       varchar(40)  NULL DEFAULT NULL COMMENT '描述',
    `app_state`          bit(1)       NULL DEFAULT NULL COMMENT '状态',
    `tenant_org_id`      bigint(20)   NULL DEFAULT NULL COMMENT '租户组织ID',
    `app_order`          int(11)      NULL DEFAULT NULL COMMENT '排序',
    PRIMARY KEY (`id`) USING BTREE,
    UNIQUE INDEX `UK4vrt57roma9gws0oqianml315` (`app_code`) USING BTREE
) COMMENT = '平台应用管理';

-- ----------------------------
-- Table structure for sys_platform_area
-- ----------------------------
CREATE TABLE IF NOT EXISTS `sys_platform_area`
(
    `id`                 bigint(20)   NOT NULL COMMENT '记录唯一ID',
    `area_name`          varchar(255) NOT NULL COMMENT '地区名称',
    `area_code`          varchar(255) NOT NULL COMMENT '地区编码',
    `parent_area_code`   varchar(255) NULL DEFAULT NULL COMMENT '上级地区编码',
    `short_name`         varchar(255) NULL DEFAULT NULL COMMENT '简称',
    `area_type`          varchar(255) NULL DEFAULT NULL COMMENT '类型，UDC[cloudt-system:areaType]',
    `zip_code`           varchar(255) NULL DEFAULT NULL COMMENT '邮编',
    `enabled`            bit(1)       NULL DEFAULT b'1' COMMENT '是否启用，默认是',
    `code_path`          varchar(255) NULL DEFAULT NULL COMMENT '编码路径',
    `tenant_id`          bigint(20)   NULL DEFAULT -1 COMMENT '所属租户ID',
    `belong_org_id`      bigint(20)   NULL DEFAULT NULL COMMENT '所属组织ID',
    `tenant_org_id`      bigint(20)   NULL DEFAULT NULL COMMENT '租户组织ID',
    `remark`             varchar(255) NULL DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint(20)   NULL DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255) NULL DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime(6)  NULL DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint(20)   NULL DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255) NULL DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime(6)  NULL DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int(11)      NULL DEFAULT 0 COMMENT '记录最后更新时间',
    `audit_data_version` int(11)      NULL DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`          bigint(20)   NULL DEFAULT NULL COMMENT '数据归属组织id',
    `sec_user_id`        bigint(20)   NULL DEFAULT NULL COMMENT '数据归属雇员id',
    `sec_ou_id`          bigint(20)   NULL DEFAULT NULL COMMENT '数据归属公司id',
    `p_id`               bigint(20)   NULL DEFAULT -1 COMMENT '上级节点ID',
    `root_id`            bigint(20)   NULL DEFAULT NULL COMMENT '根节点ID',
    `lft`                int(11)      NULL DEFAULT NULL COMMENT '左节点序号',
    `rgt`                int(11)      NULL DEFAULT NULL COMMENT '右节点序号',
    `depth`              int(11)      NULL DEFAULT 0 COMMENT '深度',
    `sort_no`            int(11)      NULL DEFAULT 0 COMMENT '顺序',
    `pinyin`             varchar(255) NULL DEFAULT NULL COMMENT '汉语拼音',
    PRIMARY KEY (`id`) USING BTREE,
    INDEX `idx_area_code` (`area_code`) USING BTREE,
    INDEX `idx_area_parent_code` (`parent_area_code`) USING BTREE,
    INDEX `idx_area_pid` (`p_id`) USING BTREE,
    INDEX `idx_area_rootid` (`root_id`) USING BTREE,
    INDEX `idx_area_lft` (`lft`) USING BTREE,
    INDEX `idx_area_rgt` (`rgt`) USING BTREE
) COMMENT = '行政区域';

-- ----------------------------
-- Table structure for sys_platform_currency
-- ----------------------------
CREATE TABLE IF NOT EXISTS `sys_platform_currency`
(
    `id`                 bigint(20)   NOT NULL COMMENT '记录唯一ID',
    `curr_code`          varchar(255) NOT NULL COMMENT '货币编码',
    `curr_name`          varchar(255) NOT NULL COMMENT '货币名称',
    `disp_decimal`       int(11)      NULL DEFAULT 0 COMMENT '小数位数',
    `enabled`            bit(1)       NULL DEFAULT b'0' COMMENT '是否启用，默认否',
    `tenant_id`          bigint(20)   NULL DEFAULT -1 COMMENT '所属租户ID',
    `belong_org_id`      bigint(20)   NULL DEFAULT NULL COMMENT '所属组织ID',
    `tenant_org_id`      bigint(20)   NULL DEFAULT NULL COMMENT '租户组织ID',
    `remark`             varchar(255) NULL DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint(20)   NULL DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255) NULL DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime(6)  NULL DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint(20)   NULL DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255) NULL DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime(6)  NULL DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int(11)      NULL DEFAULT 0 COMMENT '记录最后更新时间',
    `audit_data_version` int(11)      NULL DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`          bigint(20)   NULL DEFAULT NULL COMMENT '数据归属组织id',
    `sec_user_id`        bigint(20)   NULL DEFAULT NULL COMMENT '数据归属雇员id',
    `sec_ou_id`          bigint(20)   NULL DEFAULT NULL COMMENT '数据归属公司id',
    PRIMARY KEY (`id`) USING BTREE,
    INDEX `idx_currency_code` (`curr_code`) USING BTREE
) COMMENT = '货币';

-- ----------------------------
-- Table structure for sys_platform_menus
-- ----------------------------
CREATE TABLE IF NOT EXISTS `sys_platform_menus`
(
    `id`                 bigint(20)   NOT NULL COMMENT '记录唯一ID',
    `menus_app_code`     varchar(40)  NULL DEFAULT NULL COMMENT '菜单归属应用',
    `menus_name`         varchar(40)  NULL DEFAULT NULL COMMENT '菜单名称',
    `menus_type`         varchar(40)  NULL DEFAULT NULL COMMENT '菜单类型',
    `node_type`          varchar(40)  NULL DEFAULT NULL COMMENT '节点类型',
    `menus_code`         varchar(200) NULL DEFAULT NULL COMMENT '菜单编码',
    `menus_order`        int(11)      NULL DEFAULT NULL COMMENT '排序',
    `menus_state`        bit(1)       NULL DEFAULT NULL COMMENT '菜单状态',
    `menus_parent_code`  varchar(200) NULL DEFAULT NULL COMMENT '上级菜单编码',
    `menus_route`        varchar(200) NULL DEFAULT NULL COMMENT '菜单路由',
    `menus_describe`     varchar(200) NULL DEFAULT NULL COMMENT '描述',
    `menus_icon`         varchar(100) NULL DEFAULT NULL COMMENT '图标',
    `display`            bit(1)       NULL DEFAULT NULL COMMENT '是否展示',
    `tenant_org_id`      bigint(20)   NULL DEFAULT NULL COMMENT '租户组织ID',
    `tenant_id`          bigint(20)   NULL DEFAULT NULL COMMENT '所属租户ID',
    `belong_org_id`      bigint(20)   NULL DEFAULT NULL COMMENT '所属组织ID',
    `remark`             varchar(255) NULL DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint(20)   NULL DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255) NULL DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime(6)  NULL DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint(20)   NULL DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255) NULL DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime(6)  NULL DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int(11)      NULL DEFAULT 0 COMMENT '记录最后更新时间',
    `audit_data_version` int(11)      NULL DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`          bigint(20)   NULL DEFAULT NULL COMMENT '数据归属组织id',
    `sec_user_id`        bigint(20)   NULL DEFAULT NULL COMMENT '数据归属雇员id',
    `sec_ou_id`          bigint(20)   NULL DEFAULT NULL COMMENT '数据归属公司id',
    `outer_link`         bit(1)       NULL DEFAULT NULL COMMENT '是否外链接',
    `outer_link_type`    varchar(255) NULL DEFAULT NULL COMMENT '外链接类型',
    PRIMARY KEY (`id`) USING BTREE,
    UNIQUE INDEX `idx_menu_code` (`menus_code`) USING BTREE
) COMMENT = '平台菜单表';

-- ----------------------------
-- Table structure for sys_platform_menus_api
-- ----------------------------
CREATE TABLE IF NOT EXISTS `sys_platform_menus_api`
(
    `id`                 bigint(20)   NOT NULL COMMENT '记录唯一ID',
    `app_id`             bigint(20)   NULL DEFAULT NULL COMMENT '应用id',
    `menus_id`           bigint(20)   NULL DEFAULT NULL COMMENT '菜单id',
    `api_id`             bigint(20)   NULL DEFAULT NULL COMMENT '接口id',
    `tenant_id`          bigint(20)   NULL DEFAULT -1 COMMENT '所属租户ID',
    `belong_org_id`      bigint(20)   NULL DEFAULT NULL COMMENT '所属组织ID',
    `tenant_org_id`      bigint(20)   NULL DEFAULT NULL COMMENT '租户组织ID',
    `remark`             varchar(255) NULL DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint(20)   NULL DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255) NULL DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime(6)  NULL DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint(20)   NULL DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255) NULL DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime(6)  NULL DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int(11)      NULL DEFAULT 0 COMMENT '删除标记',
    `audit_data_version` int(11)      NULL DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`          bigint(20)   NULL DEFAULT NULL COMMENT '数据归属组织id',
    `sec_user_id`        bigint(20)   NULL DEFAULT NULL COMMENT '数据归属雇员id',
    `sec_ou_id`          bigint(20)   NULL DEFAULT NULL COMMENT '数据归属公司id',
    `app_code`           varchar(255) NOT NULL COMMENT '应用编码',
    `menus_code`         varchar(255) NOT NULL COMMENT '菜单编码',
    PRIMARY KEY (`id`) USING BTREE
) COMMENT = '菜单接口';

-- ----------------------------
-- Table structure for sys_platform_next_number
-- ----------------------------
CREATE TABLE IF NOT EXISTS `sys_platform_next_number`
(
    `id`                 bigint(20)   NOT NULL COMMENT '记录唯一ID',
    `tenant_id`          bigint(20)   NULL DEFAULT NULL COMMENT '所属租户ID',
    `belong_org_id`      bigint(20)   NULL DEFAULT NULL COMMENT '所属组织ID',
    `remark`             varchar(255) NULL DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint(20)   NULL DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255) NULL DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime(6)  NULL DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint(20)   NULL DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255) NULL DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime(6)  NULL DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int(11)      NULL DEFAULT 0 COMMENT '记录最后更新时间',
    `audit_data_version` int(11)      NULL DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`          bigint(20)   NULL DEFAULT NULL COMMENT '数据归属组织id',
    `sec_user_id`        bigint(20)   NULL DEFAULT NULL COMMENT '数据归属雇员id',
    `sec_ou_id`          bigint(20)   NULL DEFAULT NULL COMMENT '数据归属公司id',
    `app_code`           varchar(500) NULL DEFAULT NULL COMMENT '应用编码',
    `code`               varchar(255) NOT NULL COMMENT '下一编号代码',
    `name`               varchar(255) NOT NULL COMMENT '下一编号名称',
    `step`               int(11)      NULL DEFAULT NULL COMMENT '下一编号步长',
    `next_number`        bigint(20)   NULL DEFAULT NULL COMMENT '下一编号取值',
    `nn_period`          varchar(255) NULL DEFAULT NULL COMMENT '下一编号周期',
    `nn_time`            datetime(6)  NULL DEFAULT NULL COMMENT '发号时间',
    `version`            int(11)      NULL DEFAULT NULL COMMENT '乐观锁标记',
    `enabled`            bit(1)       NULL DEFAULT NULL COMMENT '是否启用',
    `internal`           bit(1)       NULL DEFAULT NULL COMMENT '是否系统内置',
    `tenant_org_id`      bigint(20)   NULL DEFAULT NULL COMMENT '租户组织ID',
    PRIMARY KEY (`id`) USING BTREE,
    INDEX `code_appcod_index` (`code`, `app_code`) USING BTREE,
    INDEX `version_next_index` (`version`) USING BTREE
) COMMENT = '取号下一编号表';

-- ----------------------------
-- Table structure for sys_platform_number_rule
-- ----------------------------
CREATE TABLE IF NOT EXISTS `sys_platform_number_rule`
(
    `id`                 bigint(20)   NOT NULL COMMENT '记录唯一ID',
    `tenant_id`          bigint(20)   NULL DEFAULT NULL COMMENT '所属租户ID',
    `belong_org_id`      bigint(20)   NULL DEFAULT NULL COMMENT '所属组织ID',
    `remark`             varchar(255) NULL DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint(20)   NULL DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255) NULL DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime(6)  NULL DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint(20)   NULL DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255) NULL DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime(6)  NULL DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int(11)      NULL DEFAULT 0 COMMENT '记录最后更新时间',
    `audit_data_version` int(11)      NULL DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`          bigint(20)   NULL DEFAULT NULL COMMENT '数据归属组织id',
    `sec_user_id`        bigint(20)   NULL DEFAULT NULL COMMENT '数据归属雇员id',
    `sec_ou_id`          bigint(20)   NULL DEFAULT NULL COMMENT '数据归属公司id',
    `app_code`           varchar(255) NOT NULL COMMENT '应用编号',
    `rule_code`          varchar(255) NOT NULL COMMENT '规则编号',
    `rule_name`          varchar(255) NULL DEFAULT NULL COMMENT '规则名称',
    `sample_code`        varchar(255) NULL DEFAULT NULL COMMENT '取号示例',
    `tenant_org_id`      bigint(20)   NULL DEFAULT NULL COMMENT '租户组织ID',
    `enabled`            bit(1)       NULL DEFAULT b'1' COMMENT '是否启用',
    PRIMARY KEY (`id`) USING BTREE
) COMMENT = '发号器规则';

-- ----------------------------
-- Table structure for sys_platform_number_ruledtl
-- ----------------------------
CREATE TABLE IF NOT EXISTS `sys_platform_number_ruledtl`
(
    `id`                 bigint(20)   NOT NULL COMMENT '记录唯一ID',
    `tenant_id`          bigint(20)   NULL DEFAULT NULL COMMENT '所属租户ID',
    `belong_org_id`      bigint(20)   NULL DEFAULT NULL COMMENT '所属组织ID',
    `remark`             varchar(255) NULL DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint(20)   NULL DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255) NULL DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime(6)  NULL DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint(20)   NULL DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255) NULL DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime(6)  NULL DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int(11)      NULL DEFAULT 0 COMMENT '记录最后更新时间',
    `audit_data_version` int(11)      NULL DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`          bigint(20)   NULL DEFAULT NULL COMMENT '数据归属组织id',
    `sec_user_id`        bigint(20)   NULL DEFAULT NULL COMMENT '数据归属雇员id',
    `sec_ou_id`          bigint(20)   NULL DEFAULT NULL COMMENT '数据归属公司id',
    `app_code`           varchar(255) NOT NULL COMMENT '应用编号',
    `rule_id`            bigint(20)   NULL DEFAULT NULL COMMENT '发号器规则ID',
    `seq`                int(11)      NULL DEFAULT NULL COMMENT '排序号',
    `number_type`        varchar(255) NULL DEFAULT NULL COMMENT '取号类型：sys:numbertype',
    `number_pattern`     varchar(255) NULL DEFAULT NULL COMMENT '取号模式，根据取号类型填写对应的固定字符串、日期格式化字符串、自增序号码',
    `nn_len`             int(11)      NULL DEFAULT NULL COMMENT '自增序号宽度，默认左补零',
    `tenant_org_id`      bigint(20)   NULL DEFAULT NULL COMMENT '租户组织ID',
    PRIMARY KEY (`id`) USING BTREE,
    INDEX `idx_sysplatform_number_ruledtl_rule_id` (`rule_id`) USING BTREE
) COMMENT = '发号器规则明细';

-- ----------------------------
-- Table structure for sys_platform_setting
-- ----------------------------
CREATE TABLE IF NOT EXISTS `sys_platform_setting`
(
    `id`                 bigint(20)   NOT NULL COMMENT '记录唯一ID',
    `tenant_id`          bigint(20)   NULL DEFAULT NULL COMMENT '所属租户ID',
    `belong_org_id`      bigint(20)   NULL DEFAULT NULL COMMENT '所属组织ID',
    `remark`             varchar(255) NULL DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint(20)   NULL DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255) NULL DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime(6)  NULL DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint(20)   NULL DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255) NULL DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime(6)  NULL DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int(11)      NULL DEFAULT 0 COMMENT '记录最后更新时间',
    `audit_data_version` int(11)      NULL DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`          bigint(20)   NULL DEFAULT NULL COMMENT '数据归属组织id',
    `sec_user_id`        bigint(20)   NULL DEFAULT NULL COMMENT '数据归属雇员id',
    `sec_ou_id`          bigint(20)   NULL DEFAULT NULL COMMENT '数据归属公司id',
    `setting_no`         varchar(255) NOT NULL COMMENT '设置的编号',
    `setting_name`       varchar(255) NULL DEFAULT NULL COMMENT '设置名称',
    `setting_type`       varchar(255) NULL DEFAULT NULL COMMENT '设置类型系统,业务',
    `setting_type2`      varchar(255) NULL DEFAULT NULL COMMENT '设置类型2',
    `app_code`           varchar(255) NULL DEFAULT NULL COMMENT '应用编码',
    `setting_group`      varchar(255) NULL DEFAULT NULL COMMENT '设置分组',
    `setting_desc`       varchar(500) NULL DEFAULT NULL COMMENT '设置描述',
    `setting_val`        varchar(500) NULL DEFAULT NULL COMMENT '设置值',
    `def_val`            varchar(500) NULL DEFAULT NULL,
    `sort_no`            int(11)      NULL DEFAULT NULL COMMENT '排序号',
    `tenant_org_id`      bigint(20)   NULL DEFAULT NULL COMMENT '租户组织ID',
    PRIMARY KEY (`id`) USING BTREE,
    UNIQUE INDEX `UK_omi1mbuarplerjd6cn959gn4n` (`setting_no`) USING BTREE
) COMMENT = '参数配置表';

-- ----------------------------
-- Table structure for sys_platform_udc
-- ----------------------------
CREATE TABLE IF NOT EXISTS `sys_platform_udc`
(
    `id`                 bigint(20)   NOT NULL COMMENT '记录唯一ID',
    `tenant_id`          bigint(20)   NULL DEFAULT NULL COMMENT '所属租户ID',
    `belong_org_id`      bigint(20)   NULL DEFAULT NULL COMMENT '所属组织ID',
    `remark`             varchar(255) NULL DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint(20)   NULL DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255) NULL DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime(6)  NULL DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint(20)   NULL DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255) NULL DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime(6)  NULL DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int(11)      NULL DEFAULT 0 COMMENT '记录最后更新时间',
    `audit_data_version` int(11)      NULL DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`          bigint(20)   NULL DEFAULT NULL COMMENT '数据归属组织id',
    `sec_user_id`        bigint(20)   NULL DEFAULT NULL COMMENT '数据归属雇员id',
    `sec_ou_id`          bigint(20)   NULL DEFAULT NULL COMMENT '数据归属公司id',
    `app_code`           varchar(200) NULL DEFAULT NULL COMMENT '应用编码',
    `udc_code`           varchar(200) NULL DEFAULT NULL COMMENT '编码',
    `udc_name`           varchar(200) NULL DEFAULT NULL COMMENT '名称',
    `allow_update`       bit(1)       NULL DEFAULT NULL COMMENT '允许编辑',
    `allow_add_value`    bit(1)       NULL DEFAULT NULL COMMENT '允许新增值',
    `udc_describe`       varchar(200) NULL DEFAULT NULL COMMENT '描述',
    `tenant_org_id`      bigint(20)   NULL DEFAULT NULL COMMENT '租户组织ID',
    `parent_udc_code`    varchar(255) NULL DEFAULT NULL COMMENT '上级UDC编码',
    PRIMARY KEY (`id`) USING BTREE,
    UNIQUE INDEX `UKf1j7tsoktr4f9qm4eynqr0aul` (`app_code`, `udc_code`, `tenant_id`) USING BTREE
) COMMENT = '平台应用udc';

-- ----------------------------
-- Table structure for sys_platform_udc_value
-- ----------------------------
CREATE TABLE IF NOT EXISTS `sys_platform_udc_value`
(
    `id`                    bigint(20)   NOT NULL COMMENT '记录唯一ID',
    `tenant_id`             bigint(20)   NULL DEFAULT NULL COMMENT '所属租户ID',
    `belong_org_id`         bigint(20)   NULL DEFAULT NULL COMMENT '所属组织ID',
    `remark`                varchar(255) NULL DEFAULT NULL COMMENT '备注',
    `create_user_id`        bigint(20)   NULL DEFAULT NULL COMMENT '记录创建者ID',
    `creator`               varchar(255) NULL DEFAULT NULL COMMENT '记录创建者',
    `create_time`           datetime(6)  NULL DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`        bigint(20)   NULL DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`               varchar(255) NULL DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`           datetime(6)  NULL DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`           int(11)      NULL DEFAULT 0 COMMENT '记录最后更新时间',
    `audit_data_version`    int(11)      NULL DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`             bigint(20)   NULL DEFAULT NULL COMMENT '数据归属组织id',
    `sec_user_id`           bigint(20)   NULL DEFAULT NULL COMMENT '数据归属雇员id',
    `sec_ou_id`             bigint(20)   NULL DEFAULT NULL COMMENT '数据归属公司id',
    `app_code`              varchar(200) NULL DEFAULT NULL COMMENT '应用编码',
    `udc_code`              varchar(200) NULL DEFAULT NULL COMMENT 'udc编码',
    `udc_value_code`        varchar(200) NULL DEFAULT NULL COMMENT '值编码',
    `udc_value_name`        varchar(200) NULL DEFAULT NULL COMMENT '值名称',
    `udc_order`             int(11)      NULL DEFAULT NULL COMMENT '排序',
    `allow_start`           bit(1)       NULL DEFAULT NULL COMMENT '是否启用',
    `udc_value_describe`    varchar(200) NULL DEFAULT NULL COMMENT '描述',
    `allow_default`         bit(1)       NULL DEFAULT NULL COMMENT '是否内置',
    `tenant_org_id`         bigint(20)   NULL DEFAULT NULL COMMENT '租户组织ID',
    `parent_udc_value_code` varchar(255) NULL DEFAULT NULL COMMENT '上级值编码',
    PRIMARY KEY (`id`) USING BTREE,
    UNIQUE INDEX `UKd1khpd8wkki803mn7nwki7qxj` (`app_code`, `udc_code`, `udc_value_code`, `tenant_id`) USING BTREE
) COMMENT = 'udc值';

-- ----------------------------
-- Table structure for sys_role
-- ----------------------------
CREATE TABLE IF NOT EXISTS `sys_role`
(
    `id`                 bigint(20)   NOT NULL COMMENT '记录唯一ID',
    `tenant_id`          bigint(20)   NULL DEFAULT NULL COMMENT '所属租户ID',
    `belong_org_id`      bigint(20)   NULL DEFAULT NULL COMMENT '所属组织ID',
    `remark`             varchar(255) NULL DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint(20)   NULL DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255) NULL DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime(6)  NULL DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint(20)   NULL DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255) NULL DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime(6)  NULL DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int(11)      NULL DEFAULT 0 COMMENT '记录最后更新时间',
    `audit_data_version` int(11)      NULL DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`          bigint(20)   NULL DEFAULT NULL COMMENT '数据归属组织id',
    `sec_user_id`        bigint(20)   NULL DEFAULT NULL COMMENT '数据归属雇员id',
    `sec_ou_id`          bigint(20)   NULL DEFAULT NULL COMMENT '数据归属公司id',
    `code`               varchar(255) NOT NULL COMMENT '角色编码',
    `name`               varchar(255) NOT NULL COMMENT '角色名称',
    `enabled`            bit(1)       NULL DEFAULT b'1' COMMENT '是否启用',
    `type`               varchar(255) NULL DEFAULT NULL COMMENT '角色类型',
    `type_id`            varchar(255) NULL DEFAULT NULL COMMENT '类型标识',
    `tenant_org_id`      bigint(20)   NULL DEFAULT NULL COMMENT '租户组织ID',
    `business_key`       varchar(255) NULL DEFAULT 'sys' COMMENT '业务标识，[UDC]cloudt-system:roleBusiness',
    PRIMARY KEY (`id`) USING BTREE,
    INDEX `idx_role_code` (`code`) USING BTREE,
    INDEX `idx_role_type` (`type`) USING BTREE,
    INDEX `idx_role_type_id` (`type_id`) USING BTREE,
    INDEX `idx_role_business` (`business_key`) USING BTREE
) COMMENT = '角色';

-- ----------------------------
-- Table structure for sys_role_permission
-- ----------------------------
CREATE TABLE IF NOT EXISTS `sys_role_permission`
(
    `id`                 bigint(20)   NOT NULL COMMENT '记录唯一ID',
    `tenant_id`          bigint(20)   NULL DEFAULT NULL COMMENT '所属租户ID',
    `belong_org_id`      bigint(20)   NULL DEFAULT NULL COMMENT '所属组织ID',
    `remark`             varchar(255) NULL DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint(20)   NULL DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255) NULL DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime(6)  NULL DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint(20)   NULL DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255) NULL DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime(6)  NULL DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int(11)      NULL DEFAULT 0 COMMENT '记录最后更新时间',
    `audit_data_version` int(11)      NULL DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`          bigint(20)   NULL DEFAULT NULL COMMENT '数据归属组织id',
    `sec_user_id`        bigint(20)   NULL DEFAULT NULL COMMENT '数据归属雇员id',
    `sec_ou_id`          bigint(20)   NULL DEFAULT NULL COMMENT '数据归属公司id',
    `role_id`            bigint(20)   NOT NULL COMMENT '角色ID',
    `permission_id`      bigint(20)   NULL DEFAULT NULL COMMENT '权限ID',
    `permission_code`    varchar(255) NOT NULL COMMENT '权限编码',
    `permission_type`    varchar(255) NOT NULL COMMENT '权限类型',
    `custom`             bit(1)       NULL DEFAULT b'0' COMMENT '是否自定义权限树',
    `tenant_org_id`      bigint(20)   NULL DEFAULT NULL COMMENT '租户组织ID',
    `app_code`           varchar(255) NULL DEFAULT NULL COMMENT '应用编码',
    PRIMARY KEY (`id`) USING BTREE,
    INDEX `idx_role_perm_role_id` (`role_id`) USING BTREE,
    INDEX `idx_role_perm_perm_code` (`permission_code`) USING BTREE,
    INDEX `idx_role_perm_perm_type` (`permission_type`) USING BTREE,
    INDEX `idx_role_perm_perm_app` (`app_code`) USING BTREE
) COMMENT = '角色权限关联';

-- ----------------------------
-- Table structure for sys_setting
-- ----------------------------
CREATE TABLE IF NOT EXISTS `sys_setting`
(
    `id`                 bigint(20)   NOT NULL COMMENT '记录唯一ID',
    `tenant_id`          bigint(20)   NULL DEFAULT NULL COMMENT '所属租户ID',
    `belong_org_id`      bigint(20)   NULL DEFAULT NULL COMMENT '所属组织ID',
    `remark`             varchar(255) NULL DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint(20)   NULL DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255) NULL DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime(6)  NULL DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint(20)   NULL DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255) NULL DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime(6)  NULL DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int(11)      NULL DEFAULT 0 COMMENT '记录最后更新时间',
    `audit_data_version` int(11)      NULL DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`          bigint(20)   NULL DEFAULT NULL COMMENT '数据归属组织id',
    `sec_user_id`        bigint(20)   NULL DEFAULT NULL COMMENT '数据归属雇员id',
    `sec_ou_id`          bigint(20)   NULL DEFAULT NULL COMMENT '数据归属公司id',
    `setting_no`         varchar(255) NOT NULL COMMENT '设置的编号',
    `setting_name`       varchar(255) NULL DEFAULT NULL COMMENT '设置名称',
    `setting_type`       varchar(255) NULL DEFAULT NULL COMMENT '设置类型',
    `setting_type2`      varchar(255) NULL DEFAULT NULL COMMENT '设置类型2',
    `email`              varchar(255) NULL DEFAULT NULL COMMENT '设置类型3',
    `setting_status`     varchar(255) NULL DEFAULT NULL COMMENT '设置状态',
    `setting_desc`       varchar(500) NULL DEFAULT NULL COMMENT '设置描述',
    `setting_val`        varchar(500) NULL DEFAULT NULL COMMENT '设置值',
    `def_val`            varchar(500) NULL DEFAULT NULL,
    `sort_no`            int(11)      NULL DEFAULT NULL COMMENT '排序号',
    `tenant_org_id`      bigint(20)   NULL DEFAULT NULL COMMENT '租户组织ID',
    PRIMARY KEY (`id`) USING BTREE,
    INDEX `UK_qyumypdg9tjvfnplxeyl9642s` (`setting_no`) USING BTREE,
    INDEX `idx_setting_settingNo` (`setting_no`) USING BTREE
) COMMENT = '系统配置表';

-- ----------------------------
-- Table structure for sys_tax_rate
-- ----------------------------
CREATE TABLE IF NOT EXISTS `sys_tax_rate`
(
    `id`                 bigint(20)     NOT NULL COMMENT '记录唯一ID',
    `tax_rate_no`        varchar(255)   NOT NULL COMMENT '税率编号',
    `tax_rate_desc`      varchar(255)   NULL DEFAULT NULL COMMENT '税率说明',
    `valid_from`         datetime(6)    NULL DEFAULT NULL COMMENT '生效日期',
    `valid_to`           datetime(6)    NULL DEFAULT NULL COMMENT '失效日期',
    `tax_rate_value`     decimal(20, 6) NULL DEFAULT NULL COMMENT '税率值',
    `enabled`            bit(1)         NULL DEFAULT b'1' COMMENT '是否启用',
    `tenant_id`          bigint(20)     NULL DEFAULT -1 COMMENT '所属租户ID',
    `belong_org_id`      bigint(20)     NULL DEFAULT NULL COMMENT '所属组织ID',
    `tenant_org_id`      bigint(20)     NULL DEFAULT NULL COMMENT '租户组织ID',
    `remark`             varchar(255)   NULL DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint(20)     NULL DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255)   NULL DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime(6)    NULL DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint(20)     NULL DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255)   NULL DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime(6)    NULL DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int(11)        NULL DEFAULT 0 COMMENT '记录最后更新时间',
    `audit_data_version` int(11)        NULL DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`          bigint(20)     NULL DEFAULT NULL COMMENT '数据归属组织id',
    `sec_user_id`        bigint(20)     NULL DEFAULT NULL COMMENT '数据归属雇员id',
    `sec_ou_id`          bigint(20)     NULL DEFAULT NULL COMMENT '数据归属公司id',
    PRIMARY KEY (`id`) USING BTREE,
    INDEX `idx_tax_rate_no` (`tax_rate_no`) USING BTREE
) COMMENT = '税率';

-- ----------------------------
-- Table structure for sys_tenant
-- ----------------------------
CREATE TABLE IF NOT EXISTS `sys_tenant`
(
    `id`                 bigint(20)   NOT NULL COMMENT '记录唯一ID',
    `tenant_id`          bigint(20)   NULL DEFAULT NULL COMMENT '所属租户ID',
    `belong_org_id`      bigint(20)   NULL DEFAULT NULL COMMENT '所属组织ID',
    `remark`             varchar(255) NULL DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint(20)   NULL DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255) NULL DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime(6)  NULL DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint(20)   NULL DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255) NULL DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime(6)  NULL DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int(11)      NULL DEFAULT 0 COMMENT '记录最后更新时间',
    `audit_data_version` int(11)      NULL DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`          bigint(20)   NULL DEFAULT NULL COMMENT '数据归属组织id',
    `sec_user_id`        bigint(20)   NULL DEFAULT NULL COMMENT '数据归属雇员id',
    `sec_ou_id`          bigint(20)   NULL DEFAULT NULL COMMENT '数据归属公司id',
    `tenant_code`        varchar(255) NOT NULL COMMENT '租户编码',
    `tenant_name`        varchar(255) NOT NULL COMMENT '租户名称',
    `sys_user_id`        bigint(20)   NOT NULL COMMENT '管理员用户ID',
    `admin_account`      varchar(255) NOT NULL COMMENT '管理员登录账号',
    `tenant_type`        varchar(255) NULL DEFAULT NULL COMMENT '租户类型',
    `enabled`            bit(1)       NULL DEFAULT b'0' COMMENT '是否启用',
    `linkman`            varchar(255) NULL DEFAULT NULL COMMENT '联系人',
    `contact_number`     varchar(255) NULL DEFAULT NULL COMMENT '联系电话',
    `address`            varchar(255) NULL DEFAULT NULL COMMENT '联系地址',
    `tenant_isolation`   varchar(255) NULL DEFAULT NULL COMMENT '租户数据隔离策略',
    `db_initialized`     bit(1)       NULL DEFAULT b'0' COMMENT '数据库是否已初始化',
    `base_data_sync_id`  bigint(20)   NULL DEFAULT NULL COMMENT '基础数据同步记录ID',
    `schema_name`        varchar(255) NULL DEFAULT NULL COMMENT 'schema名称',
    `tenant_domain`      varchar(255) NULL DEFAULT NULL COMMENT '域名地址，二级域名部分',
    `custom_domain`      varchar(255) NULL DEFAULT NULL COMMENT '用户自己的域名',
    `industry`           varchar(255) NULL DEFAULT NULL COMMENT '所属行业，[UDC]COM:INDUSTRY',
    `customer`           varchar(255) NULL DEFAULT NULL COMMENT '所属客户，[UDC]SYS:CUSTOMER',
    `tenant_org_id`      bigint(20)   NULL DEFAULT NULL COMMENT '租户组织ID',
    PRIMARY KEY (`id`) USING BTREE,
    INDEX `idx_sys_tenant_code` (`tenant_code`) USING BTREE
) COMMENT = '平台租户表';

-- ----------------------------
-- Table structure for sys_tenant_app
-- ----------------------------
CREATE TABLE IF NOT EXISTS `sys_tenant_app`
(
    `id`                 bigint(20)   NOT NULL COMMENT '记录唯一ID',
    `tenant_id`          bigint(20)   NULL DEFAULT NULL COMMENT '所属租户ID',
    `belong_org_id`      bigint(20)   NULL DEFAULT NULL COMMENT '所属组织ID',
    `remark`             varchar(255) NULL DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint(20)   NULL DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255) NULL DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime(6)  NULL DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint(20)   NULL DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255) NULL DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime(6)  NULL DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int(11)      NULL DEFAULT 0 COMMENT '记录最后更新时间',
    `audit_data_version` int(11)      NULL DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`          bigint(20)   NULL DEFAULT NULL COMMENT '数据归属组织id',
    `sec_user_id`        bigint(20)   NULL DEFAULT NULL COMMENT '数据归属雇员id',
    `sec_ou_id`          bigint(20)   NULL DEFAULT NULL COMMENT '数据归属公司id',
    `sys_tenant_id`      bigint(20)   NOT NULL COMMENT '租户ID',
    `app_code`           varchar(255) NOT NULL COMMENT '应用编码',
    `assign_time`        datetime(6)  NOT NULL COMMENT '分配时间',
    `tenant_org_id`      bigint(20)   NULL DEFAULT NULL COMMENT '租户组织ID',
    PRIMARY KEY (`id`) USING BTREE,
    INDEX `idx_tenant_app_tenant_id` (`sys_tenant_id`) USING BTREE,
    INDEX `idx_tenant_app_app_code` (`app_code`) USING BTREE
) COMMENT = '租户的应用';

CREATE TABLE `sys_tenant_datasource`
(
    `id`                 bigint(20) NOT NULL COMMENT '记录唯一ID',
    `sys_tenant_id`      bigint(20) NOT NULL COMMENT '租户ID',
    `app_code`           varchar(255) DEFAULT NULL COMMENT '应用编码',
    `def`                bit(1)       DEFAULT NULL COMMENT '是否是默认数据源',
    `use_def`            bit(1)       DEFAULT NULL COMMENT '是否使用默认数据源',
    `ds_url`             varchar(255) DEFAULT NULL COMMENT '连接地址',
    `ds_username`        varchar(255) DEFAULT NULL COMMENT '账号',
    `ds_password`        varchar(255) DEFAULT NULL COMMENT '密码',
    `ds_driver`          varchar(255) DEFAULT NULL COMMENT '驱动类',
    `ds_pool_prop`       longtext     DEFAULT NULL COMMENT '连接池配置',
    `enabled`            bit(1)       DEFAULT NULL COMMENT '是否启用',
    `tenant_id`          bigint(20)   DEFAULT '-1' COMMENT '所属租户ID',
    `belong_org_id`      bigint(20)   DEFAULT NULL COMMENT '所属组织ID',
    `tenant_org_id`      bigint(20)   DEFAULT NULL COMMENT '租户组织ID',
    `remark`             varchar(255) DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint(20)   DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255) DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime(6)  DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint(20)   DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime(6)  DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int(11)      DEFAULT '0' COMMENT '删除标记',
    `audit_data_version` int(11)      DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`          bigint(20)   DEFAULT NULL COMMENT '数据归属组织id',
    `sec_user_id`        bigint(20)   DEFAULT NULL COMMENT '数据归属雇员id',
    `sec_ou_id`          bigint(20)   DEFAULT NULL COMMENT '数据归属公司id',
    PRIMARY KEY (`id`),
    UNIQUE KEY `idx_tenant_ds_tenantapp` (`sys_tenant_id`, `app_code`),
    KEY `idx_tenant_ds_tenantid` (`sys_tenant_id`)
) COMMENT ='租户数据源';
-- ----------------------------
-- Table structure for sys_tenant_area
-- ----------------------------
CREATE TABLE IF NOT EXISTS `sys_tenant_area`
(
    `id`                 bigint(20)   NOT NULL COMMENT '记录唯一ID',
    `sys_tenant_id`      bigint(20)   NOT NULL COMMENT '租户ID',
    `enabled`            bit(1)       NOT NULL DEFAULT b'0' COMMENT '是否启用自定义行政区域',
    `tenant_id`          bigint(20)   NULL     DEFAULT -1 COMMENT '所属租户ID',
    `belong_org_id`      bigint(20)   NULL     DEFAULT NULL COMMENT '所属组织ID',
    `tenant_org_id`      bigint(20)   NULL     DEFAULT NULL COMMENT '租户组织ID',
    `remark`             varchar(255) NULL     DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint(20)   NULL     DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255) NULL     DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime(6)  NULL     DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint(20)   NULL     DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255) NULL     DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime(6)  NULL     DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int(11)      NULL     DEFAULT 0 COMMENT '记录最后更新时间',
    `audit_data_version` int(11)      NULL     DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`          bigint(20)   NULL     DEFAULT NULL COMMENT '数据归属组织id',
    `sec_user_id`        bigint(20)   NULL     DEFAULT NULL COMMENT '数据归属雇员id',
    `sec_ou_id`          bigint(20)   NULL     DEFAULT NULL COMMENT '数据归属公司id',
    PRIMARY KEY (`id`) USING BTREE,
    UNIQUE INDEX `idx_sys_tenant_area_tenant` (`sys_tenant_id`) USING BTREE
) COMMENT = '租户自定义行政区域';

-- ----------------------------
-- Table structure for sys_tenant_bdata_sync
-- ----------------------------
CREATE TABLE IF NOT EXISTS `sys_tenant_bdata_sync`
(
    `id`                 bigint(20)   NOT NULL COMMENT '记录唯一ID',
    `tenant_id`          bigint(20)   NULL DEFAULT NULL COMMENT '所属租户ID',
    `belong_org_id`      bigint(20)   NULL DEFAULT NULL COMMENT '所属组织ID',
    `remark`             varchar(255) NULL DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint(20)   NULL DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255) NULL DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime(6)  NULL DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint(20)   NULL DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255) NULL DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime(6)  NULL DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int(11)      NULL DEFAULT 0 COMMENT '记录最后更新时间',
    `audit_data_version` int(11)      NULL DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`          bigint(20)   NULL DEFAULT NULL COMMENT '数据归属组织id',
    `sec_user_id`        bigint(20)   NULL DEFAULT NULL COMMENT '数据归属雇员id',
    `sec_ou_id`          bigint(20)   NULL DEFAULT NULL COMMENT '数据归属公司id',
    `sys_tenant_id`      bigint(20)   NOT NULL COMMENT '租户ID',
    `finished`           bit(1)       NOT NULL COMMENT '是否同步结束',
    `success`            bit(1)       NOT NULL COMMENT '是否同步成功',
    `start_time`         datetime(6)  NULL DEFAULT NULL COMMENT '同步开始时间',
    `end_time`           datetime(6)  NULL DEFAULT NULL COMMENT '同步结束时间',
    `fail_reason`        longtext     NULL COMMENT '同步失败原因',
    `tenant_org_id`      bigint(20)   NULL DEFAULT NULL COMMENT '租户组织ID',
    PRIMARY KEY (`id`) USING BTREE,
    INDEX `idx_tenant_bdata_sync_tenant` (`sys_tenant_id`) USING BTREE
) COMMENT = '租户基础数据同步记录';

-- ----------------------------
-- Table structure for sys_tenant_bdata_sync_detail
-- ----------------------------
CREATE TABLE IF NOT EXISTS `sys_tenant_bdata_sync_detail`
(
    `id`                 bigint(20)   NOT NULL COMMENT '记录唯一ID',
    `tenant_id`          bigint(20)   NULL DEFAULT NULL COMMENT '所属租户ID',
    `belong_org_id`      bigint(20)   NULL DEFAULT NULL COMMENT '所属组织ID',
    `remark`             varchar(255) NULL DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint(20)   NULL DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255) NULL DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime(6)  NULL DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint(20)   NULL DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255) NULL DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime(6)  NULL DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int(11)      NULL DEFAULT 0 COMMENT '记录最后更新时间',
    `audit_data_version` int(11)      NULL DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`          bigint(20)   NULL DEFAULT NULL COMMENT '数据归属组织id',
    `sec_user_id`        bigint(20)   NULL DEFAULT NULL COMMENT '数据归属雇员id',
    `sec_ou_id`          bigint(20)   NULL DEFAULT NULL COMMENT '数据归属公司id',
    `sync_id`            bigint(20)   NOT NULL COMMENT '同步记录ID',
    `data_type`          varchar(255) NOT NULL COMMENT '数据类型',
    `finished`           bit(1)       NOT NULL COMMENT '是否同步结束',
    `success`            bit(1)       NOT NULL COMMENT '是否同步成功',
    `start_time`         datetime(6)  NULL DEFAULT NULL COMMENT '同步开始时间',
    `end_time`           datetime(6)  NULL DEFAULT NULL COMMENT '同步结束时间',
    `fail_reason`        longtext     NULL COMMENT '同步失败原因',
    `tenant_org_id`      bigint(20)   NULL DEFAULT NULL COMMENT '租户组织ID',
    PRIMARY KEY (`id`) USING BTREE,
    INDEX `idx_tenant_bdata_sync_d_sync` (`sync_id`) USING BTREE
) COMMENT = '租户基础数据迁移记录明细';

-- ----------------------------
-- Table structure for sys_tenant_currency
-- ----------------------------
CREATE TABLE IF NOT EXISTS `sys_tenant_currency`
(
    `id`                 bigint(20)   NOT NULL COMMENT '记录唯一ID',
    `sys_tenant_id`      bigint(20)   NOT NULL COMMENT '租户ID',
    `curr_code`          varchar(255) NOT NULL COMMENT '货币编码',
    `enabled`            bit(1)       NOT NULL DEFAULT b'0' COMMENT '是否启用',
    `tenant_id`          bigint(20)   NULL     DEFAULT -1 COMMENT '所属租户ID',
    `belong_org_id`      bigint(20)   NULL     DEFAULT NULL COMMENT '所属组织ID',
    `tenant_org_id`      bigint(20)   NULL     DEFAULT NULL COMMENT '租户组织ID',
    `remark`             varchar(255) NULL     DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint(20)   NULL     DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255) NULL     DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime(6)  NULL     DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint(20)   NULL     DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255) NULL     DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime(6)  NULL     DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int(11)      NULL     DEFAULT 0 COMMENT '记录最后更新时间',
    `audit_data_version` int(11)      NULL     DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`          bigint(20)   NULL     DEFAULT NULL COMMENT '数据归属组织id',
    `sec_user_id`        bigint(20)   NULL     DEFAULT NULL COMMENT '数据归属雇员id',
    `sec_ou_id`          bigint(20)   NULL     DEFAULT NULL COMMENT '数据归属公司id',
    PRIMARY KEY (`id`) USING BTREE,
    INDEX `idx_tenant_currency_tenant` (`sys_tenant_id`) USING BTREE
) COMMENT = '租户的货币';

-- ----------------------------
-- Table structure for sys_tenant_db_migrate
-- ----------------------------
CREATE TABLE IF NOT EXISTS `sys_tenant_db_migrate`
(
    `id`                  bigint(20)   NOT NULL COMMENT '记录唯一ID',
    `tenant_id`           bigint(20)   NULL DEFAULT NULL COMMENT '所属租户ID',
    `belong_org_id`       bigint(20)   NULL DEFAULT NULL COMMENT '所属组织ID',
    `remark`              varchar(255) NULL DEFAULT NULL COMMENT '备注',
    `create_user_id`      bigint(20)   NULL DEFAULT NULL COMMENT '记录创建者ID',
    `creator`             varchar(255) NULL DEFAULT NULL COMMENT '记录创建者',
    `create_time`         datetime(6)  NULL DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`      bigint(20)   NULL DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`             varchar(255) NULL DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`         datetime(6)  NULL DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`         int(11)      NULL DEFAULT 0 COMMENT '记录最后更新时间',
    `audit_data_version`  int(11)      NULL DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`           bigint(20)   NULL DEFAULT NULL COMMENT '数据归属组织id',
    `sec_user_id`         bigint(20)   NULL DEFAULT NULL COMMENT '数据归属雇员id',
    `sec_ou_id`           bigint(20)   NULL DEFAULT NULL COMMENT '数据归属公司id',
    `sys_tenant_id`       bigint(20)   NOT NULL COMMENT '租户ID',
    `app_code`            varchar(255) NOT NULL COMMENT '应用编码',
    `tenant_isolation`    varchar(255) NOT NULL COMMENT '租户数据隔离策略',
    `database_source_id`  bigint(20)   NULL DEFAULT NULL COMMENT '租户数据隔离数据源',
    `schema_name`         varchar(255) NULL DEFAULT NULL COMMENT 'schema名称',
    `migrate_success`     bit(1)       NULL DEFAULT NULL COMMENT '是否已成功',
    `migrate_start_time`  datetime(6)  NULL DEFAULT NULL COMMENT '迁移开始时间',
    `migrate_finish_time` datetime(6)  NULL DEFAULT NULL COMMENT '迁移结束时间',
    `fail_reason`         longtext     NULL COMMENT '失败原因',
    `tenant_org_id`       bigint(20)   NULL DEFAULT NULL COMMENT '租户组织ID',
    PRIMARY KEY (`id`) USING BTREE,
    INDEX `idx_tenant_db_migrate_tenant_id` (`sys_tenant_id`) USING BTREE
) COMMENT = '租户数据库的创建记录';

-- ----------------------------
-- Table structure for sys_tenant_menu
-- ----------------------------
CREATE TABLE IF NOT EXISTS `sys_tenant_menu`
(
    `id`                 bigint(20)   NOT NULL COMMENT '记录唯一ID',
    `tenant_id`          bigint(20)   NULL     DEFAULT NULL COMMENT '所属租户ID',
    `belong_org_id`      bigint(20)   NULL     DEFAULT NULL COMMENT '所属组织ID',
    `remark`             varchar(255) NULL     DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint(20)   NULL     DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255) NULL     DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime(6)  NULL     DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint(20)   NULL     DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255) NULL     DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime(6)  NULL     DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int(11)      NULL     DEFAULT 0 COMMENT '记录最后更新时间',
    `audit_data_version` int(11)      NULL     DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`          bigint(20)   NULL     DEFAULT NULL COMMENT '数据归属组织id',
    `sec_user_id`        bigint(20)   NULL     DEFAULT NULL COMMENT '数据归属雇员id',
    `sec_ou_id`          bigint(20)   NULL     DEFAULT NULL COMMENT '数据归属公司id',
    `sys_tenant_id`      bigint(20)   NOT NULL COMMENT '租户ID',
    `enabled`            bit(1)       NOT NULL DEFAULT b'0' COMMENT '是否启用自定义菜单树',
    `tenant_org_id`      bigint(20)   NULL     DEFAULT NULL COMMENT '租户组织ID',
    PRIMARY KEY (`id`) USING BTREE,
    UNIQUE INDEX `idx_sys_tenant_menu_tenant` (`sys_tenant_id`) USING BTREE
) COMMENT = '员工';

-- ----------------------------
-- Table structure for sys_tenant_menu_tree
-- ----------------------------
CREATE TABLE IF NOT EXISTS `sys_tenant_menu_tree`
(
    `id`                 bigint(20)   NOT NULL COMMENT '记录唯一ID',
    `tenant_id`          bigint(20)   NULL DEFAULT NULL COMMENT '所属租户ID',
    `belong_org_id`      bigint(20)   NULL DEFAULT NULL COMMENT '所属组织ID',
    `remark`             varchar(255) NULL DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint(20)   NULL DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255) NULL DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime(6)  NULL DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint(20)   NULL DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255) NULL DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime(6)  NULL DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int(11)      NULL DEFAULT 0 COMMENT '记录最后更新时间',
    `audit_data_version` int(11)      NULL DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`          bigint(20)   NULL DEFAULT NULL COMMENT '数据归属组织id',
    `sec_user_id`        bigint(20)   NULL DEFAULT NULL COMMENT '数据归属雇员id',
    `sec_ou_id`          bigint(20)   NULL DEFAULT NULL COMMENT '数据归属公司id',
    `sys_tenant_id`      bigint(20)   NOT NULL COMMENT '租户ID',
    `menu_code`          varchar(255) NOT NULL COMMENT '菜单编码',
    `menu_name`          varchar(255) NULL DEFAULT NULL COMMENT '菜单名称',
    `node_type`          varchar(255) NULL DEFAULT NULL COMMENT '节点类型（MENU-菜单, APP-应用）',
    `parent_menu_code`   varchar(255) NULL DEFAULT NULL COMMENT '父菜单编码',
    `icon`               varchar(255) NULL DEFAULT NULL COMMENT '菜单图标',
    `custom`             bit(1)       NULL DEFAULT b'0' COMMENT '是否自定义菜单',
    `sort_no`            int(11)      NULL DEFAULT 0 COMMENT '排序号',
    `tenant_org_id`      bigint(20)   NULL DEFAULT NULL COMMENT '租户组织ID',
    PRIMARY KEY (`id`) USING BTREE,
    INDEX `idx_tenant_menu_tree_tenant` (`sys_tenant_id`) USING BTREE,
    INDEX `idx_tenant_menu_tree_menu` (`menu_code`) USING BTREE
) COMMENT = '自定义菜单树';

-- ----------------------------
-- Table structure for sys_tenant_org
-- ----------------------------
CREATE TABLE IF NOT EXISTS `sys_tenant_org`
(
    `id`                 bigint(20)   NOT NULL COMMENT '记录唯一ID',
    `tenant_id`          bigint(20)   NULL DEFAULT NULL COMMENT '所属租户ID',
    `belong_org_id`      bigint(20)   NULL DEFAULT NULL COMMENT '所属组织ID',
    `remark`             varchar(255) NULL DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint(20)   NULL DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255) NULL DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime(6)  NULL DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint(20)   NULL DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255) NULL DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime(6)  NULL DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int(11)      NULL DEFAULT 0 COMMENT '记录最后更新时间',
    `audit_data_version` int(11)      NULL DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`          bigint(20)   NULL DEFAULT NULL COMMENT '数据归属组织id',
    `sec_user_id`        bigint(20)   NULL DEFAULT NULL COMMENT '数据归属雇员id',
    `sec_ou_id`          bigint(20)   NULL DEFAULT NULL COMMENT '数据归属公司id',
    `org_id`             bigint(20)   NOT NULL COMMENT '组织ID',
    `admin_id`           bigint(20)   NULL DEFAULT NULL COMMENT '管理员用户ID',
    `enabled`            bit(1)       NULL DEFAULT b'1' COMMENT '是否启用',
    `tenant_org_id`      bigint(20)   NULL DEFAULT NULL COMMENT '租户组织ID',
    PRIMARY KEY (`id`) USING BTREE,
    INDEX `idx_tenant_org_org_id` (`org_id`) USING BTREE,
    INDEX `idx_tenant_org_admin_id` (`admin_id`) USING BTREE
) COMMENT = '租户组织';

-- ----------------------------
-- Table structure for sys_tenant_user
-- ----------------------------
CREATE TABLE IF NOT EXISTS `sys_tenant_user`
(
    `id`                 bigint(20)   NOT NULL COMMENT '记录唯一ID',
    `tenant_id`          bigint(20)   NULL DEFAULT NULL COMMENT '所属租户ID',
    `belong_org_id`      bigint(20)   NULL DEFAULT NULL COMMENT '所属组织ID',
    `remark`             varchar(255) NULL DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint(20)   NULL DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255) NULL DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime(6)  NULL DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint(20)   NULL DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255) NULL DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime(6)  NULL DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int(11)      NULL DEFAULT 0 COMMENT '记录最后更新时间',
    `audit_data_version` int(11)      NULL DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`          bigint(20)   NULL DEFAULT NULL COMMENT '数据归属组织id',
    `sec_user_id`        bigint(20)   NULL DEFAULT NULL COMMENT '数据归属雇员id',
    `sec_ou_id`          bigint(20)   NULL DEFAULT NULL COMMENT '数据归属公司id',
    `sys_user_id`        bigint(20)   NOT NULL COMMENT '用户ID',
    `sys_tenant_id`      bigint(20)   NOT NULL COMMENT '租户ID',
    `bind_time`          datetime(6)  NULL DEFAULT NULL COMMENT '绑定时间',
    `last_login_time`    datetime(6)  NULL DEFAULT NULL COMMENT '上次登录时间',
    `expired_time`       datetime(6)  NULL DEFAULT NULL COMMENT '账号过期时间',
    `enabled`            bit(1)       NULL DEFAULT b'1' COMMENT '是否启用',
    `def`                bit(1)       NULL DEFAULT b'0' COMMENT '是否是默认租户',
    `tenant_org_id`      bigint(20)   NULL DEFAULT NULL COMMENT '租户组织ID',
    PRIMARY KEY (`id`) USING BTREE,
    INDEX `idx_tenant_user_user_id` (`sys_user_id`) USING BTREE,
    INDEX `idx_tenant_user_tenant_id` (`sys_tenant_id`) USING BTREE
) COMMENT = '用户与租户的绑定关系';

CREATE TABLE `sys_third_api_log`
(
    `id`                     bigint(20) NOT NULL COMMENT '记录唯一ID',
    `sys_tenant_id`          bigint(20)   DEFAULT NULL COMMENT '租户ID',
    `app_code`               varchar(255) DEFAULT NULL COMMENT '应用编码',
    `restful`                bit(1)       DEFAULT b'1' COMMENT '是否是Restful接口',
    `server`                 bit(1)       DEFAULT b'0' COMMENT '当前是否是服务端',
    `server_addr`            varchar(255) DEFAULT NULL COMMENT '服务端地址，当不是服务端时，不能为空',
    `client_id`              varchar(255) DEFAULT NULL COMMENT '客户端ID',
    `user_id`                bigint(20)   DEFAULT NULL COMMENT '请求用户ID',
    `username`               varchar(255) DEFAULT NULL COMMENT '请求用户',
    `third_app`              varchar(255) DEFAULT NULL COMMENT '外部应用名称，作为客户端时，不能为空',
    `business_type`          varchar(255) DEFAULT NULL COMMENT '业务类型',
    `business_key`           varchar(255) DEFAULT NULL COMMENT '业务数据key',
    `uri`                    varchar(255) DEFAULT NULL COMMENT '请求的接口地址',
    `req_method`             varchar(255) DEFAULT NULL COMMENT '请求方式',
    `req_query_params_json`  longtext COMMENT '请求的查询参数',
    `req_body`               longtext COMMENT '请求体',
    `req_headers_json`       longtext COMMENT '请求头',
    `req_success`            bit(1)       DEFAULT b'0' COMMENT '是否请求成功',
    `req_fail_msg`           longtext COMMENT '请求失败信息',
    `req_time`               datetime(6)  DEFAULT NULL COMMENT '请求时间',
    `req_ip`                 varchar(255) DEFAULT NULL COMMENT '请求者IP',
    `resp_body`              longtext COMMENT '响应体',
    `resp_success`           bit(1)       DEFAULT b'0' COMMENT '是否响应成功',
    `resp_fail_msg`          longtext COMMENT '响应失败信息',
    `resp_time`              datetime(6)  DEFAULT NULL COMMENT '响应时间',
    `need_retry`             bit(1)       DEFAULT b'0' COMMENT '是否需要重试',
    `retry_times`            int(11)      DEFAULT '0' COMMENT '重试次数',
    `retry_fail_reason`      longtext COMMENT '重试失败原因',
    `retried`                bit(1)       DEFAULT b'0' COMMENT '是否是重试记录',
    `original_id`            bigint(20)   DEFAULT NULL COMMENT '原始记录ID',
    `last_retry_id`          bigint(20)   DEFAULT NULL COMMENT '最后一次重试的ID',
    `manual_retry`           bit(1)       DEFAULT b'0' COMMENT '是否是手动重试',
    `detected_operator_auth` bit(1)       DEFAULT b'0' COMMENT '自动获取操作人的token',
    `retry_param_json`       longtext COMMENT '重试参数',
    `tenant_id`              bigint(20)   DEFAULT '-1' COMMENT '所属租户ID',
    `belong_org_id`          bigint(20)   DEFAULT NULL COMMENT '所属组织ID',
    `tenant_org_id`          bigint(20)   DEFAULT NULL COMMENT '租户组织ID',
    `remark`                 varchar(255) DEFAULT NULL COMMENT '备注',
    `create_user_id`         bigint(20)   DEFAULT NULL COMMENT '记录创建者ID',
    `creator`                varchar(255) DEFAULT NULL COMMENT '记录创建者',
    `create_time`            datetime(6)  DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`         bigint(20)   DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`                varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`            datetime(6)  DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`            int(11)      DEFAULT '0' COMMENT '删除标记',
    `audit_data_version`     int(11)      DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`              bigint(20)   DEFAULT NULL COMMENT '数据归属组织id',
    `sec_user_id`            bigint(20)   DEFAULT NULL COMMENT '数据归属雇员id',
    `sec_ou_id`              bigint(20)   DEFAULT NULL COMMENT '数据归属公司id',
    PRIMARY KEY (`id`),
    KEY `idx_thirdapi_log_tenant` (`sys_tenant_id`),
    KEY `idx_thirdapi_log_app` (`app_code`),
    KEY `idx_thirdapi_log_server` (`server`),
    KEY `idx_thirdapi_log_uri` (`uri`),
    KEY `idx_thirdapi_log_reqsuc` (`req_success`),
    KEY `idx_thirdapi_log_respsuc` (`resp_success`),
    KEY `idx_thirdapi_log_third` (`third_app`),
    KEY `idx_thirdapi_log_bustype` (`business_type`),
    KEY `idx_thirdapi_log_buskey` (`business_key`)
) COMMENT ='三方接口调用日志';

CREATE TABLE `sys_third_api_retry`
(
    `id`                 bigint(20) NOT NULL COMMENT '记录唯一ID',
    `sys_tenant_id`      bigint(20)   DEFAULT NULL COMMENT '租户ID',
    `record_log_id`      bigint(20)   DEFAULT NULL COMMENT '原始记录ID',
    `retry_times`        int(11)      DEFAULT '0' COMMENT '发送重试的次数',
    `send_time`          datetime(6)  DEFAULT NULL COMMENT '上次发送时间',
    `send_time_next`     datetime(6)  DEFAULT NULL COMMENT '下次发送时间',
    `tenant_id`          bigint(20)   DEFAULT '-1' COMMENT '所属租户ID',
    `belong_org_id`      bigint(20)   DEFAULT NULL COMMENT '所属组织ID',
    `tenant_org_id`      bigint(20)   DEFAULT NULL COMMENT '租户组织ID',
    `remark`             varchar(255) DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint(20)   DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255) DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime(6)  DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint(20)   DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime(6)  DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int(11)      DEFAULT '0' COMMENT '删除标记',
    `audit_data_version` int(11)      DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`          bigint(20)   DEFAULT NULL COMMENT '数据归属组织id',
    `sec_user_id`        bigint(20)   DEFAULT NULL COMMENT '数据归属雇员id',
    `sec_ou_id`          bigint(20)   DEFAULT NULL COMMENT '数据归属公司id',
    PRIMARY KEY (`id`),
    KEY `idx_thirdapi_log_tenant` (`sys_tenant_id`),
    KEY `idx_thirdapi_log_record` (`record_log_id`)
) COMMENT ='三方接口调用重试记录';

CREATE TABLE `sys_third_api_business`
(
    `id`                 bigint(20) NOT NULL COMMENT '记录唯一ID',
    `sys_tenant_id`      bigint(20)   DEFAULT NULL COMMENT '租户ID',
    `business_type`      varchar(255) DEFAULT NULL COMMENT '业务类型',
    `business_key`       varchar(255) DEFAULT NULL COMMENT '业务数据key',
    `success`            bit(1)       DEFAULT b'0' COMMENT '是否成功',
    `tenant_id`          bigint(20)   DEFAULT '-1' COMMENT '所属租户ID',
    `belong_org_id`      bigint(20)   DEFAULT NULL COMMENT '所属组织ID',
    `tenant_org_id`      bigint(20)   DEFAULT NULL COMMENT '租户组织ID',
    `remark`             varchar(255) DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint(20)   DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255) DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime(6)  DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint(20)   DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime(6)  DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int(11)      DEFAULT '0' COMMENT '删除标记',
    `audit_data_version` int(11)      DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`          bigint(20)   DEFAULT NULL COMMENT '数据归属组织id',
    `sec_user_id`        bigint(20)   DEFAULT NULL COMMENT '数据归属雇员id',
    `sec_ou_id`          bigint(20)   DEFAULT NULL COMMENT '数据归属公司id',
    `success_time`       datetime(6)  DEFAULT NULL COMMENT '请求成功时间',
    PRIMARY KEY (`id`),
    KEY `idx_thirdapi_bus_type` (`business_type`),
    KEY `idx_thirdapi_bus_key` (`business_key`)
) COMMENT ='三方接口调用业务状态';

-- ----------------------------
-- Table structure for sys_third_party_account
-- ----------------------------
CREATE TABLE IF NOT EXISTS `sys_third_party_account`
(
    `id`                 bigint(20)   NOT NULL COMMENT '记录唯一ID',
    `sys_tenant_id`      bigint(20)   NOT NULL COMMENT '租户ID',
    `name`               varchar(255) NOT NULL COMMENT '账号名称',
    `account`            varchar(255) NOT NULL COMMENT '账号',
    `account_type`       varchar(255) NOT NULL COMMENT '账号类型',
    `enabled`            bit(1)       NULL DEFAULT b'1' COMMENT '是否启用',
    `config_json`        longtext     NULL COMMENT 'json格式的配置内容',
    `tenant_id`          bigint(20)   NULL DEFAULT -1 COMMENT '所属租户ID',
    `belong_org_id`      bigint(20)   NULL DEFAULT NULL COMMENT '所属组织ID',
    `tenant_org_id`      bigint(20)   NULL DEFAULT NULL COMMENT '租户组织ID',
    `remark`             varchar(255) NULL DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint(20)   NULL DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255) NULL DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime(6)  NULL DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint(20)   NULL DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255) NULL DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime(6)  NULL DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int(11)      NULL DEFAULT 0 COMMENT '记录最后更新时间',
    `audit_data_version` int(11)      NULL DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`          bigint(20)   NULL DEFAULT NULL COMMENT '数据归属组织id',
    `sec_user_id`        bigint(20)   NULL DEFAULT NULL COMMENT '数据归属雇员id',
    `sec_ou_id`          bigint(20)   NULL DEFAULT NULL COMMENT '数据归属公司id',
    `cas_id`             bigint(20)   NULL DEFAULT NULL COMMENT '统一认证中心的ID',
    `business_type`      varchar(255) NULL DEFAULT NULL COMMENT '业务类型',
    PRIMARY KEY (`id`) USING BTREE,
    UNIQUE INDEX `idx_third_part_account` (`account`) USING BTREE,
    INDEX `idx_third_part_tenant` (`sys_tenant_id`) USING BTREE,
    INDEX `idx_third_part_account_t` (`account_type`) USING BTREE
) COMMENT = '第三方账号';

-- ----------------------------
-- Table structure for sys_tmpl
-- ----------------------------
CREATE TABLE IF NOT EXISTS `sys_tmpl`
(
    `id`                    bigint(20)   NOT NULL COMMENT '记录唯一ID',
    `name`                  varchar(255) NOT NULL COMMENT '模板名称',
    `code_`                 varchar(255) NOT NULL COMMENT '模板编号',
    `file_code`             varchar(255) NULL DEFAULT NULL COMMENT '模板文件标识',
    `file_name`             varchar(255) NULL DEFAULT NULL COMMENT '模板文件名称',
    `export`                bit(1)       NULL DEFAULT b'1' COMMENT '是否是导出模板',
    `head_row`              int(11)      NULL DEFAULT NULL COMMENT '头部所占行数，头部以下都是数据部分',
    `field_type_row`        int(11)      NULL DEFAULT NULL COMMENT '数据字段类型所在行，fieldTypeRow不能大于headRow',
    `enabled`               bit(1)       NULL DEFAULT b'1' COMMENT '是否启用',
    `data_limit_per`        int(11)      NULL DEFAULT -1 COMMENT '导入数据限制，每次允许导入的记录数量，-1表示无限制',
    `async_threshold`       int(11)      NULL DEFAULT -1 COMMENT '异步导入阀值，导入数据超过阀值后将转为异步的方式，-1表示无限制',
    `concurrent_limit`      int(11)      NULL DEFAULT -1 COMMENT '并发限制，同一模板可并发导入的最大数量，-1表示无限制',
    `attribute_list`        longtext     NULL COMMENT '属性列表',
    `export_sheet_limit`    int(11)      NULL DEFAULT 1000000 COMMENT '导出时每个sheet限制的记录数，最大100万',
    `export_sheet_strategy` varchar(255) NULL DEFAULT NULL COMMENT '导出时超出sheet限制后的策略',
    `tenant_id`             bigint(20)   NULL DEFAULT -1 COMMENT '所属租户ID',
    `belong_org_id`         bigint(20)   NULL DEFAULT NULL COMMENT '所属组织ID',
    `tenant_org_id`         bigint(20)   NULL DEFAULT NULL COMMENT '租户组织ID',
    `remark`                varchar(255) NULL DEFAULT NULL COMMENT '备注',
    `create_user_id`        bigint(20)   NULL DEFAULT NULL COMMENT '记录创建者ID',
    `creator`               varchar(255) NULL DEFAULT NULL COMMENT '记录创建者',
    `create_time`           datetime(6)  NULL DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`        bigint(20)   NULL DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`               varchar(255) NULL DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`           datetime(6)  NULL DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`           int(11)      NULL DEFAULT 0 COMMENT '记录最后更新时间',
    `audit_data_version`    int(11)      NULL DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`             bigint(20)   NULL DEFAULT NULL COMMENT '数据归属组织id',
    `sec_user_id`           bigint(20)   NULL DEFAULT NULL COMMENT '数据归属雇员id',
    `sec_ou_id`             bigint(20)   NULL DEFAULT NULL COMMENT '数据归属公司id',
    `app_code`              varchar(255) NOT NULL COMMENT '应用编码',
    PRIMARY KEY (`id`) USING BTREE,
    UNIQUE INDEX `idx_tmpl_code` (`code_`) USING BTREE,
    INDEX `idx_tmpl_app` (`app_code`) USING BTREE
) COMMENT = '导入导出模板';

-- ----------------------------
-- Table structure for sys_tmpl_import_file
-- ----------------------------
CREATE TABLE IF NOT EXISTS `sys_tmpl_import_file`
(
    `id`                 bigint(20)   NOT NULL COMMENT '记录唯一ID',
    `record_id`          bigint(20)   NOT NULL COMMENT '导入导出记录ID',
    `tmpl_id`            bigint(20)   NOT NULL COMMENT '模板文件ID',
    `file_code`          varchar(255) NOT NULL COMMENT '文件编码',
    `file_order`         int(11)      NULL DEFAULT 0 COMMENT '文件顺序',
    `file_name`          varchar(255) NULL DEFAULT NULL COMMENT '文件名称',
    `tenant_id`          bigint(20)   NULL DEFAULT -1 COMMENT '所属租户ID',
    `belong_org_id`      bigint(20)   NULL DEFAULT NULL COMMENT '所属组织ID',
    `tenant_org_id`      bigint(20)   NULL DEFAULT NULL COMMENT '租户组织ID',
    `remark`             varchar(255) NULL DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint(20)   NULL DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255) NULL DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime(6)  NULL DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint(20)   NULL DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255) NULL DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime(6)  NULL DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int(11)      NULL DEFAULT 0 COMMENT '记录最后更新时间',
    `audit_data_version` int(11)      NULL DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`          bigint(20)   NULL DEFAULT NULL COMMENT '数据归属组织id',
    `sec_user_id`        bigint(20)   NULL DEFAULT NULL COMMENT '数据归属雇员id',
    `sec_ou_id`          bigint(20)   NULL DEFAULT NULL COMMENT '数据归属公司id',
    PRIMARY KEY (`id`) USING BTREE,
    INDEX `idx_tmpl_import_file_tmpl_id` (`tmpl_id`) USING BTREE,
    INDEX `idx_tmpl_import_file_record_id` (`record_id`) USING BTREE
) COMMENT = '导入导出的文件记录';

-- ----------------------------
-- Table structure for sys_tmpl_import_record
-- ----------------------------
CREATE TABLE IF NOT EXISTS `sys_tmpl_import_record`
(
    `id`                 bigint(20)   NOT NULL COMMENT '记录唯一ID',
    `tmpl_id`            bigint(20)   NOT NULL COMMENT '模板ID',
    `file_code`          varchar(255) NULL DEFAULT NULL COMMENT '文件的标识',
    `export`             bit(1)       NULL DEFAULT b'1' COMMENT '是否是导出',
    `user_id`            bigint(20)   NULL DEFAULT NULL COMMENT '操作用户ID',
    `user_name`          varchar(255) NULL DEFAULT NULL COMMENT '操作用户名称',
    `time_import`        datetime(6)  NULL DEFAULT NULL COMMENT '开始时间',
    `time_finish`        datetime(6)  NULL DEFAULT NULL COMMENT '结束时间',
    `finish`             bit(1)       NULL DEFAULT b'0' COMMENT '是否结束',
    `succ`               bit(1)       NULL DEFAULT b'0' COMMENT '是否成功',
    `fail_reason`        longtext     NULL COMMENT '失败原因',
    `num_total`          bigint(20)   NULL DEFAULT 0 COMMENT '总数量',
    `num_suc`            bigint(20)   NULL DEFAULT 0 COMMENT '成功数量',
    `query_param`        longtext     NULL COMMENT '查询参数',
    `tenant_id`          bigint(20)   NULL DEFAULT -1 COMMENT '所属租户ID',
    `belong_org_id`      bigint(20)   NULL DEFAULT NULL COMMENT '所属组织ID',
    `tenant_org_id`      bigint(20)   NULL DEFAULT NULL COMMENT '租户组织ID',
    `remark`             varchar(255) NULL DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint(20)   NULL DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255) NULL DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime(6)  NULL DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint(20)   NULL DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255) NULL DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime(6)  NULL DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int(11)      NULL DEFAULT 0 COMMENT '记录最后更新时间',
    `audit_data_version` int(11)      NULL DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`          bigint(20)   NULL DEFAULT NULL COMMENT '数据归属组织id',
    `sec_user_id`        bigint(20)   NULL DEFAULT NULL COMMENT '数据归属雇员id',
    `sec_ou_id`          bigint(20)   NULL DEFAULT NULL COMMENT '数据归属公司id',
    `fail_file_code`     varchar(255) NULL DEFAULT NULL COMMENT '失败记录的文件编码',
    PRIMARY KEY (`id`) USING BTREE,
    INDEX `idx_tmpl_imp_record_tmpl` (`tmpl_id`) USING BTREE
) COMMENT = '导入导出历史记录';

-- ----------------------------
-- Table structure for sys_user
-- ----------------------------
CREATE TABLE IF NOT EXISTS `sys_user`
(
    `id`                    bigint(20)   NOT NULL COMMENT '记录唯一ID',
    `tenant_id`             bigint(20)   NULL DEFAULT NULL COMMENT '所属租户ID',
    `belong_org_id`         bigint(20)   NULL DEFAULT NULL COMMENT '所属组织ID',
    `remark`                varchar(255) NULL DEFAULT NULL COMMENT '备注',
    `create_user_id`        bigint(20)   NULL DEFAULT NULL COMMENT '记录创建者ID',
    `creator`               varchar(255) NULL DEFAULT NULL COMMENT '记录创建者',
    `create_time`           datetime(6)  NULL DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`        bigint(20)   NULL DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`               varchar(255) NULL DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`           datetime(6)  NULL DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`           int(11)      NULL DEFAULT 0 COMMENT '记录最后更新时间',
    `audit_data_version`    int(11)      NULL DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`             bigint(20)   NULL DEFAULT NULL COMMENT '数据归属组织id',
    `sec_user_id`           bigint(20)   NULL DEFAULT NULL COMMENT '数据归属雇员id',
    `sec_ou_id`             bigint(20)   NULL DEFAULT NULL COMMENT '数据归属公司id',
    `username`              varchar(255) NOT NULL COMMENT '登录账号',
    `password`              varchar(255) NOT NULL COMMENT '登录密码',
    `need_reset`            bit(1)       NULL DEFAULT b'1' COMMENT '密码是否需要重新设置',
    `last_name`             varchar(255) NULL DEFAULT NULL COMMENT '姓名-姓氏',
    `first_name`            varchar(255) NULL DEFAULT NULL COMMENT '姓名-名字',
    `gender`                varchar(255) NULL DEFAULT NULL COMMENT '性别，（male-男，female-女，secret-保密）',
    `nick_name`             varchar(255) NULL DEFAULT NULL COMMENT '昵称',
    `birth_date`            date         NULL DEFAULT NULL COMMENT '生日',
    `mobile`                varchar(255) NULL DEFAULT NULL COMMENT '手机号',
    `email`                 varchar(255) NULL DEFAULT NULL COMMENT '邮箱',
    `enabled`               bit(1)       NULL DEFAULT b'1' COMMENT '是否启用',
    `last_login_time`       datetime(6)  NULL DEFAULT NULL COMMENT '上次登录时间',
    `expired_time`          datetime(6)  NULL DEFAULT NULL COMMENT '账号过期时间',
    `id_card`               varchar(255) NULL DEFAULT NULL COMMENT '身份证号',
    `province_code`         varchar(255) NULL DEFAULT NULL COMMENT '省编码',
    `city_code`             varchar(255) NULL DEFAULT NULL COMMENT '市编码',
    `address`               varchar(255) NULL DEFAULT NULL COMMENT '详细地址',
    `personal_sign`         varchar(255) NULL DEFAULT NULL COMMENT '个性签名',
    `source_type`           varchar(255) NULL DEFAULT NULL COMMENT '账号来源, sys： 系统创建；wec：微信创建；oth：其他方式',
    `avatar_url`            longtext     NULL COMMENT '用户头像地址，可直接访问，如微信头像地址等',
    `avatar_code`           varchar(255) NULL DEFAULT NULL COMMENT '用户头像在文件服务器中的标识',
    `tenant_org_id`         bigint(20)   NULL DEFAULT NULL COMMENT '租户组织ID',
    `sync_cas`              bit(1)       NULL DEFAULT b'1' COMMENT '是否需要向统一身份认证中心同步',
    `cas_user_id`           bigint(20)   NULL DEFAULT NULL COMMENT '在统一身份认证中心的ID',
    `password_expired_time` datetime(6)  NULL DEFAULT NULL COMMENT '密码过期时间',
    `county_code`           varchar(255) NULL DEFAULT NULL COMMENT '县编码',
    PRIMARY KEY (`id`) USING BTREE,
    UNIQUE INDEX `idx_sys_user_username` (`username`) USING BTREE,
    INDEX `idx_sys_user_mobile` (`mobile`) USING BTREE,
    INDEX `idx_sys_user_email` (`email`) USING BTREE,
    INDEX `idx_sys_user_source` (`source_type`) USING BTREE,
    INDEX `idx_sys_user_cas_user` (`cas_user_id`) USING BTREE
) COMMENT = '系统用户账号';

-- ----------------------------
-- Table structure for sys_user_company
-- ----------------------------
CREATE TABLE IF NOT EXISTS `sys_user_company`
(
    `id`                 bigint(20)   NOT NULL COMMENT '记录唯一ID',
    `tenant_id`          bigint(20)   NULL DEFAULT NULL COMMENT '所属租户ID',
    `belong_org_id`      bigint(20)   NULL DEFAULT NULL COMMENT '所属组织ID',
    `remark`             varchar(255) NULL DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint(20)   NULL DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255) NULL DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime(6)  NULL DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint(20)   NULL DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255) NULL DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime(6)  NULL DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int(11)      NULL DEFAULT 0 COMMENT '记录最后更新时间',
    `audit_data_version` int(11)      NULL DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`          bigint(20)   NULL DEFAULT NULL COMMENT '数据归属组织id',
    `sec_user_id`        bigint(20)   NULL DEFAULT NULL COMMENT '数据归属雇员id',
    `sec_ou_id`          bigint(20)   NULL DEFAULT NULL COMMENT '数据归属公司id',
    `sys_user_id`        bigint(20)   NULL DEFAULT NULL COMMENT '用户ID',
    `ou_id`              bigint(20)   NULL DEFAULT NULL COMMENT '公司ID',
    `ou_code`            varchar(255) NULL DEFAULT NULL COMMENT '公司编码',
    `ou_name`            varchar(255) NULL DEFAULT NULL COMMENT '公司名称',
    `bind_time`          datetime(6)  NULL DEFAULT NULL COMMENT '绑定时间',
    `tenant_org_id`      bigint(20)   NULL DEFAULT NULL COMMENT '租户组织ID',
    PRIMARY KEY (`id`) USING BTREE,
    INDEX `idx_sys_user_company_user_id` (`sys_user_id`) USING BTREE,
    INDEX `idx_sys_user_company_ou_id` (`ou_id`) USING BTREE
) COMMENT = '用户与公司关联表';

-- ----------------------------
-- Table structure for sys_user_role
-- ----------------------------
CREATE TABLE IF NOT EXISTS `sys_user_role`
(
    `id`                 bigint(20)   NOT NULL COMMENT '记录唯一ID',
    `tenant_id`          bigint(20)   NULL DEFAULT NULL COMMENT '所属租户ID',
    `belong_org_id`      bigint(20)   NULL DEFAULT NULL COMMENT '所属组织ID',
    `remark`             varchar(255) NULL DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint(20)   NULL DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255) NULL DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime(6)  NULL DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint(20)   NULL DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255) NULL DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime(6)  NULL DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int(11)      NULL DEFAULT 0 COMMENT '记录最后更新时间',
    `audit_data_version` int(11)      NULL DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`          bigint(20)   NULL DEFAULT NULL COMMENT '数据归属组织id',
    `sec_user_id`        bigint(20)   NULL DEFAULT NULL COMMENT '数据归属雇员id',
    `sec_ou_id`          bigint(20)   NULL DEFAULT NULL COMMENT '数据归属公司id',
    `user_id`            bigint(20)   NOT NULL COMMENT '用户ID',
    `role_id`            bigint(20)   NOT NULL COMMENT '角色ID',
    `tenant_org_id`      bigint(20)   NULL DEFAULT NULL COMMENT '租户组织ID',
    PRIMARY KEY (`id`) USING BTREE,
    INDEX `idx_sys_user_role_user_id` (`user_id`) USING BTREE,
    INDEX `idx_sys_user_role_role_id` (`role_id`) USING BTREE
) COMMENT = '用户角色关联表';

-- ----------------------------
-- Table structure for sys_user_terminal
-- ----------------------------
CREATE TABLE IF NOT EXISTS `sys_user_terminal`
(
    `id`                 bigint(20)   NOT NULL COMMENT '记录唯一ID',
    `tenant_id`          bigint(20)   NULL DEFAULT NULL COMMENT '所属租户ID',
    `belong_org_id`      bigint(20)   NULL DEFAULT NULL COMMENT '所属组织ID',
    `remark`             varchar(255) NULL DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint(20)   NULL DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255) NULL DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime(6)  NULL DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint(20)   NULL DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255) NULL DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime(6)  NULL DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int(11)      NULL DEFAULT 0 COMMENT '记录最后更新时间',
    `audit_data_version` int(11)      NULL DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`          bigint(20)   NULL DEFAULT NULL COMMENT '数据归属组织id',
    `sec_user_id`        bigint(20)   NULL DEFAULT NULL COMMENT '数据归属雇员id',
    `sec_ou_id`          bigint(20)   NULL DEFAULT NULL COMMENT '数据归属公司id',
    `user_id`            bigint(20)   NULL DEFAULT NULL COMMENT '用户ID',
    `terminal_code`      varchar(255) NULL DEFAULT NULL COMMENT '终端编码，Terminal枚举类',
    `time_bind`          datetime(6)  NULL DEFAULT NULL COMMENT '绑定时间',
    `tenant_org_id`      bigint(20)   NULL DEFAULT NULL COMMENT '租户组织ID',
    PRIMARY KEY (`id`) USING BTREE,
    INDEX `idx_sys_user_terminal_user` (`user_id`) USING BTREE
) COMMENT = '用户与终端的关联';

-- ----------------------------
-- Table structure for sys_user_type
-- ----------------------------
CREATE TABLE IF NOT EXISTS `sys_user_type`
(
    `id`                 bigint(20)   NOT NULL COMMENT '记录唯一ID',
    `user_id`            bigint(20)   NOT NULL COMMENT '用户ID',
    `type`               varchar(255) NOT NULL COMMENT '用户类型',
    `tenant_id`          bigint(20)   NULL DEFAULT NULL COMMENT '所属租户ID',
    `belong_org_id`      bigint(20)   NULL DEFAULT NULL COMMENT '所属组织ID',
    `remark`             varchar(255) NULL DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint(20)   NULL DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255) NULL DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime(6)  NULL DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint(20)   NULL DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255) NULL DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime(6)  NULL DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int(11)      NULL DEFAULT 0 COMMENT '记录最后更新时间',
    `audit_data_version` int(11)      NULL DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`          bigint(20)   NULL DEFAULT NULL COMMENT '数据归属组织id',
    `sec_user_id`        bigint(20)   NULL DEFAULT NULL COMMENT '数据归属雇员id',
    `sec_ou_id`          bigint(20)   NULL DEFAULT NULL COMMENT '数据归属公司id',
    `tenant_org_id`      bigint(20)   NULL DEFAULT NULL COMMENT '租户组织ID',
    `sys_tenant_id`      bigint(20)   NULL DEFAULT NULL COMMENT '所属租户',
    PRIMARY KEY (`id`) USING BTREE,
    INDEX `idx_sys_user_type_user_id` (`user_id`) USING BTREE,
    INDEX `idx_sys_user_type_type` (`type`) USING BTREE
) COMMENT = '用户类型';

-- ----------------------------
-- Table structure for sys_watermark_config
-- ----------------------------
CREATE TABLE IF NOT EXISTS `sys_watermark_config`
(
    `id`                 bigint(20)   NOT NULL COMMENT '记录唯一ID',
    `tenant_id`          bigint(20)   NULL DEFAULT NULL COMMENT '所属租户ID',
    `belong_org_id`      bigint(20)   NULL DEFAULT NULL COMMENT '所属组织ID',
    `remark`             varchar(255) NULL DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint(20)   NULL DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255) NULL DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime(6)  NULL DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint(20)   NULL DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255) NULL DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime(6)  NULL DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int(11)      NULL DEFAULT 0 COMMENT '记录最后更新时间',
    `audit_data_version` int(11)      NULL DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`          bigint(20)   NULL DEFAULT NULL COMMENT '数据归属组织id',
    `sec_user_id`        bigint(20)   NULL DEFAULT NULL COMMENT '数据归属雇员id',
    `sec_ou_id`          bigint(20)   NULL DEFAULT NULL COMMENT '数据归属公司id',
    `dynamic_font`       varchar(255) NULL DEFAULT NULL COMMENT '动态文字',
    `custom_field`       varchar(255) NULL DEFAULT NULL COMMENT '自定义文字',
    `font_size`          int(11)      NULL DEFAULT NULL COMMENT '文字大小',
    `font_color`         varchar(255) NULL DEFAULT NULL COMMENT '颜色深浅',
    `rotate`             int(11)      NULL DEFAULT NULL COMMENT '旋转角度',
    `stacking_deep`      int(11)      NULL DEFAULT NULL COMMENT '层叠深度',
    `tenant_org_id`      bigint(20)   NULL DEFAULT NULL COMMENT '租户组织ID',
    PRIMARY KEY (`id`) USING BTREE
) COMMENT = '系统水印配置';

CREATE TABLE `sys_resource_byte`
(
    `id`                 bigint(20)   NOT NULL COMMENT '记录唯一ID',
    `resource_type`      varchar(255) NOT NULL COMMENT '资源类型',
    `resource_key`       varchar(255) NOT NULL COMMENT '资源唯一标识',
    `resource`           longblob     NOT NULL COMMENT '资源',
    `mime_type`          varchar(255) DEFAULT NULL COMMENT '文件mime-type',
    `suffix`             varchar(255) DEFAULT NULL COMMENT '扩展名',
    `resource_name`      varchar(255) DEFAULT NULL COMMENT '原始名称',
    `show_name`          varchar(255) DEFAULT NULL COMMENT '显示名称',
    `size`               bigint(20)   DEFAULT NULL COMMENT '文件大小',
    `temp`               bit(1)       DEFAULT b'1' COMMENT '是否是临时文件',
    `tenant_id`          bigint(20)   DEFAULT '-1' COMMENT '所属租户ID',
    `belong_org_id`      bigint(20)   DEFAULT NULL COMMENT '所属组织ID',
    `tenant_org_id`      bigint(20)   DEFAULT NULL COMMENT '租户组织ID',
    `remark`             varchar(255) DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint(20)   DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255) DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime(6)  DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint(20)   DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime(6)  DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int(11)      DEFAULT '0' COMMENT '删除标记',
    `audit_data_version` int(11)      DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`          bigint(20)   DEFAULT NULL COMMENT '数据归属组织id',
    `sec_user_id`        bigint(20)   DEFAULT NULL COMMENT '数据归属雇员id',
    `sec_ou_id`          bigint(20)   DEFAULT NULL COMMENT '数据归属公司id',
    PRIMARY KEY (`id`),
    KEY `idx_res_byte_restype` (`resource_type`),
    KEY `idx_res_byte_reskey` (`resource_key`),
    KEY `idx_res_byte_temp` (`temp`)
) COMMENT ='资源表';