-- niuchen 增加页面字段配置表
# DROP TABLE IF EXISTS sys_page_field_config;
CREATE TABLE IF NOT EXISTS sys_page_field_config
(
    `id`                 BIGINT(20) NOT NULL COMMENT 'id',
    `app_code`           VARCHAR(255) NOT NULL COMMENT '所属应用',
    `app_name`           VARCHAR(255) NOT NULL COMMENT '所属应用名称',
    `config_name`        VARCHAR(255) NOT NULL COMMENT '配置名称',
    `config_code`        VARCHAR(255) NOT NULL COMMENT '配置编码',
    `tenant_id`          BIGINT(20) COMMENT '租户id',
    `belong_org_id`      BIGINT(20) COMMENT '所属组织',
    `remark`             VARCHAR(255) COMMENT '8',
    `create_user_id`     BIGINT(20) COMMENT '创建人id',
    `creator`            VARCHAR(255) COMMENT '创建者',
    `create_time`        DATE COMMENT '创建时间',
    `modify_user_id`     BIGINT(20) COMMENT '更新人id',
    `updater`            VARCHAR(255) COMMENT '更新人',
    `modify_time`        VARCHAR(255) COMMENT '更新时间',
    `delete_flag`        Int COMMENT '是否删除1是 0否',
    `audit_data_version` DECIMAL(24, 6) COMMENT '版本号',
    `sec_bu_id`          BIGINT(20) COMMENT '所属组织',
    `sec_user_id`        BIGINT(20)   COMMENT '所属员工',
    `sec_ou_id`          BIGINT(20) COMMENT '所属公司',
    `user_id`            BIGINT(20) COMMENT '用户id',
    `role_id`            BIGINT(20) COMMENT '角色id',
    `tenant_org_id`      BIGINT(20) COMMENT '租户组织ID',
    `enabled`            INT          NOT NULL COMMENT '是否可用',
    PRIMARY KEY (id)
) COMMENT = '页面字段配置';

CREATE INDEX index_configCode ON sys_page_field_config (config_code);
CREATE INDEX index_appCode ON sys_page_field_config (app_code);





# DROP TABLE IF EXISTS sys_page_field_config_dtl;
CREATE TABLE IF NOT EXISTS  sys_page_field_config_dtl
(
    `id`                 BIGINT(20)  NOT NULL COMMENT 'id',
    `app_code`           VARCHAR(255)   NOT NULL COMMENT '所属应用',
    `app_name`           VARCHAR(255)   NOT NULL COMMENT '所属应用名称',
    `config_name`        VARCHAR(255)   NOT NULL COMMENT '配置名称',
    `config_code`        VARCHAR(255)   NOT NULL COMMENT '配置编码',
    `field_name`         VARCHAR(255)   NOT NULL COMMENT '字段名称',
    `field_code`         VARCHAR(255)   NOT NULL COMMENT '字段编码',
    `field_required`     INT    COMMENT '是否必填',
    `field_alias`        VARCHAR(255)    COMMENT '字段别名',
    `linenum`            DECIMAL(24, 6) NOT NULL COMMENT '行号',
    `tenant_id`          BIGINT(20) COMMENT '租户id',
    `belong_org_id`      BIGINT(20) COMMENT '所属组织',
    `remark`             VARCHAR(255) COMMENT '8',
    `create_user_id`     BIGINT(20) COMMENT '创建人id',
    `creator`            VARCHAR(255) COMMENT '创建者',
    `create_time`        DATE COMMENT '创建时间',
    `modify_user_id`     BIGINT(20) COMMENT '更新人id',
    `updater`            VARCHAR(255) COMMENT '更新人',
    `modify_time`        VARCHAR(255) COMMENT '更新时间',
    `delete_flag`        INT COMMENT '是否删除1是 0否',
    `audit_data_version` DECIMAL(24, 6) COMMENT '版本号',
    `sec_bu_id`          BIGINT(20) COMMENT '所属组织',
    `sec_user_id`        BIGINT(20)  COMMENT '所属员工',
    `sec_ou_id`          BIGINT(20) COMMENT '所属公司',
    `user_id`            BIGINT(20) COMMENT '用户id',
    `role_id`            BIGINT(20) COMMENT '角色id',
    `tenant_org_id`      BIGINT(20) COMMENT '租户组织ID',

    PRIMARY KEY (id)
) COMMENT = '页面字段配置明细';


CREATE INDEX index_appCode ON sys_page_field_config_dtl (app_code);
CREATE INDEX index_configCode ON sys_page_field_config_dtl (config_code);
CREATE INDEX index_fieldCode ON sys_page_field_config_dtl (field_code);

