alter table sys_msg_send_record
    add column send_param_json longtext comment '发送参数json';
alter table sys_msg_send_record_dtl
    add column files_code_json varchar(2000) comment '附件编码json';
alter table sys_tmpl_import_record
    add column tmpl_code varchar(255) comment '模板编码';
create index idx_tmpl_imp_record_tmplc on sys_tmpl_import_record (tmpl_code);

CREATE TABLE `sys_version`
(
    `id`                 bigint(20)   NOT NULL COMMENT '记录唯一ID',
    `version_no`         varchar(255) NOT NULL COMMENT '版本号',
    `describe_msg`       varchar(255) DEFAULT NULL COMMENT '版本描述',
    `release_time`       datetime(6)  DEFAULT NULL COMMENT '发布时间',
    `change_content`     varchar(255) DEFAULT NULL COMMENT '变更日志',
    `status`             bit(1)       DEFAULT NULL COMMENT '生效状态',
    `tenant_id`          bigint(20)   DEFAULT NULL COMMENT '所属租户ID',
    `belong_org_id`      bigint(20)   DEFAULT NULL COMMENT '所属组织ID',
    `remark`             varchar(255) DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint(20)   DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255) DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime(6)  DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint(20)   DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime(6)  DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int(11)      DEFAULT NULL COMMENT '删除标记',
    `audit_data_version` int(11)      DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`          bigint(20)   DEFAULT NULL COMMENT '数据归属组织id',
    `sec_user_id`        bigint(20)   DEFAULT NULL COMMENT '数据归属雇员id',
    `sec_ou_id`          bigint(20)   DEFAULT NULL COMMENT '数据归属公司id',
    `tenant_org_id`      bigint(20)   DEFAULT NULL COMMENT '租户组织ID',
    PRIMARY KEY (`id`)
) COMMENT ='标产版本';

alter table sys_role
    add column group_id bigint default -1 comment '分组ID';
create index idx_role_group on sys_role (group_id);
CREATE TABLE `sys_role_group`
(
    `id`                 bigint(20)   NOT NULL COMMENT '记录唯一ID',
    `group_code`         varchar(255) DEFAULT NULL COMMENT '分组编码',
    `group_name`         varchar(255) NOT NULL COMMENT '分组名称',
    `enabled`            bit(1)       DEFAULT b'1' COMMENT '启用状态',
    `description`        varchar(255) DEFAULT NULL COMMENT '描述',
    `tenant_id`          bigint(20)   DEFAULT '-1' COMMENT '所属租户ID',
    `belong_org_id`      bigint(20)   DEFAULT NULL COMMENT '所属组织ID',
    `tenant_org_id`      bigint(20)   DEFAULT NULL COMMENT '租户组织ID',
    `remark`             varchar(255) DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint(20)   DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255) DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime(6)  DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint(20)   DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime(6)  DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int(11)      DEFAULT '0' COMMENT '删除标记',
    `audit_data_version` int(11)      DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`          bigint(20)   DEFAULT NULL COMMENT '数据归属组织id',
    `sec_user_id`        bigint(20)   DEFAULT NULL COMMENT '数据归属雇员id',
    `sec_ou_id`          bigint(20)   DEFAULT NULL COMMENT '数据归属公司id',
    PRIMARY KEY (`id`)
) COMMENT ='角色分组';
CREATE TABLE `sys_basic_record`
(
    `id`                 bigint(20) NOT NULL COMMENT '记录唯一ID',
    `record_type`        varchar(255) DEFAULT NULL COMMENT '记录类型',
    `all_data`           bit(1)       DEFAULT b'0' COMMENT '是否全量',
    `data_version`       varchar(255) DEFAULT NULL COMMENT '数据版本',
    `data_type`          varchar(255) DEFAULT NULL COMMENT '数据类型',
    `tenant_code`        varchar(255) DEFAULT NULL COMMENT '租户编码',
    `description`        varchar(255) DEFAULT NULL COMMENT '说明',
    `data_file_code`     varchar(255) DEFAULT NULL COMMENT '数据文件',
    `attribute`          longtext COMMENT '属性列表',
    `operate_time`       datetime(6)  DEFAULT NULL COMMENT '操作时间',
    `success`            bit(1)       DEFAULT b'0' COMMENT '是否成功',
    `finished`           bit(1)       DEFAULT b'0' COMMENT '是否结束',
    `finish_time`        datetime(6)  DEFAULT NULL COMMENT '结束时间',
    `fail_reason`        longtext COMMENT '失败原因',
    `tenant_id`          bigint(20)   DEFAULT '-1' COMMENT '所属租户ID',
    `belong_org_id`      bigint(20)   DEFAULT NULL COMMENT '所属组织ID',
    `tenant_org_id`      bigint(20)   DEFAULT NULL COMMENT '租户组织ID',
    `remark`             varchar(255) DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint(20)   DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255) DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime(6)  DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint(20)   DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime(6)  DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int(11)      DEFAULT '0' COMMENT '删除标记',
    `audit_data_version` int(11)      DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`          bigint(20)   DEFAULT NULL COMMENT '数据归属组织id',
    `sec_user_id`        bigint(20)   DEFAULT NULL COMMENT '数据归属雇员id',
    `sec_ou_id`          bigint(20)   DEFAULT NULL COMMENT '数据归属公司id',
    PRIMARY KEY (`id`)
) COMMENT ='基础数据同步记录';
alter table sys_dpr_role_api_rule add column bs1 longtext comment '特用字段1' ;
alter table sys_dpr_role_api_rule add column bs2 longtext comment '特用字段2' ;
alter table sys_dpr_role_api_rule add column bs3 longtext comment '特用字段3' ;