package com.elitescloud.cloudt.comm.rpc;

import com.elitescloud.cloudt.comm.consumer.dto.ComPaymentTermRpcDTO;
import com.elitescloud.cloudt.comm.consumer.param.ComPaymentTermRpcDtoParam;
import com.elitescloud.cloudt.comm.service.ComPaymentTermProviderService;
import com.elitescloud.cloudt.comm.vo.param.ComPaymentTermQueryParamVO;
import com.elitescloud.cloudt.comm.vo.resp.ComPaymentTermRespVO;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.system.service.IComPaymentTermService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * 2022/7/27
 */
@RestController
@RequestMapping(value = ComPaymentTermProviderService.URI, produces = MediaType.APPLICATION_JSON_VALUE)
public class ComPaymentTermRpcServiceImpl implements ComPaymentTermProviderService {

    @Autowired
    private IComPaymentTermService comPaymentTermService;

    @Override
    public PagingVO<ComPaymentTermRespVO> search(ComPaymentTermQueryParamVO queryParam) {
        return comPaymentTermService.search(queryParam);
    }

    @Override
    public ComPaymentTermRespVO getCodeOne(String code) {
        return comPaymentTermService.getCodeOne(code);
    }

    @Override
    public ComPaymentTermRespVO getIdOne(Long id) {
        return comPaymentTermService.getIdOne(id);
    }

    @Override
    public List<ComPaymentTermRespVO> findIdBatch(List<Long> idList) {
        return comPaymentTermService.findIdBatch(idList);
    }

    @Override
    public List<ComPaymentTermRespVO> list() {
        return comPaymentTermService.list();
    }

    @Override
    public List<ComPaymentTermRespVO> findCodeBatch(List<String> paymentTermCodes) {
        return comPaymentTermService.findCodeBatch(paymentTermCodes);
    }

    @Override
    public List<ComPaymentTermRpcDTO> findPaymentTermRpcDtoByParam(ComPaymentTermRpcDtoParam param) {
        return comPaymentTermService.findPaymentTermRpcDtoByParam(param);
    }
}
