package com.elitescloud.cloudt.log.model.vo.param;

import com.elitescloud.cloudt.log.common.LogLevel;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * 日志查询参数.
 *
 * @author Kaiser（wang shao）
 * 2021/07/31
 */
@Data
@ApiModel(description = "日志查询参数")
public class LogStashQueryParam implements Serializable {
    private static final long serialVersionUID = -8064626096450929629L;

    @ApiModelProperty(value = "页码，如1", position = 0)
    private Integer page;

    @ApiModelProperty(value = "页码大小，如20", position = 1)
    private Integer pageSize;

    @ApiModelProperty(value = "关键词，如系统错误，请联系管理员", position = 2)
    private String keyword;

    @ApiModelProperty(value = "关键词高亮设置", position = 3, hidden = true)
    private Highlight highlight;

    @ApiModelProperty(value = "应用名称，如cloudt-system", position = 10)
    private String appName;

    @ApiModelProperty(value = "日志级别，如ERROR", allowableValues = "TRACE, DEBUG, INFO, WARN, ERROR, FATAL, OFF", position = 11)
    private LogLevel logLevel;

    @ApiModelProperty(value = "最低日志级别，如DEBUG", allowableValues = "TRACE, DEBUG, INFO, WARN, ERROR, FATAL, OFF", position = 12)
    private LogLevel logLevelMin;

    @ApiModelProperty(value = "开始时间，如2021-07-31 10:00:00", position = 13)
    private LocalDateTime startTime;

    @ApiModelProperty(value = "截止时间，如2021-07-31 10:00:00", position = 14)
    private LocalDateTime endTime;

    @ApiModelProperty(value = "踪迹ID，如traceId:ca67472b7a0d45e1b877d8b4aca0d47e.303.16273622812550019", position = 15)
    private String traceId;

    @ApiModelProperty(value = "线程ID，如threadId:1ff40d15-26d4-411e-b652-3eb937ec11cd", position = 16)
    private String threadId;

    @Data
    @ApiModel(value = "LogStashQueryParam_Highlight", description = "关键字高亮设置")
    public static class Highlight implements Serializable{
        private static final long serialVersionUID = -8485001949689582952L;

        @ApiModelProperty(value = "前标签", example = "<font color='red'>", position = 1)
        private String preTag;

        @ApiModelProperty(value = "后标签", example = "</font>", position = 2)
        private String postTag;
    }
}
