package com.elitescloud.cloudt.log.service;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.log.model.vo.param.LogStashQueryParam;
import com.elitescloud.cloudt.log.model.vo.resp.LogStashRecordRespVO;

import java.time.LocalDateTime;
import java.util.List;

/**
 * 日志服务接口.
 *
 * @author Kaiser（wang shao）
 * 2021/07/31
 */
public interface LogStashService {

    /**
     * 日志查询参数
     *
     * @param queryParam 查询参数
     * @return 查询结果
     */
    ApiResult<PagingVO<LogStashRecordRespVO>> search(LogStashQueryParam queryParam);

    /**
     * 获取所有的日志级别
     *
     * @return 日志级别
     */
    ApiResult<List<String>> logLevelList();

    /**
     * 获取appName列表
     *
     * @param size  获取的最大数量
     * @param start 开始时间
     * @param end   结束时间
     * @return appName列表
     */
    ApiResult<List<String>> appNameList(Integer size, LocalDateTime start, LocalDateTime end);
}
