//package com.elitescloud.cloudt.log.service.impl;
//
//import com.alibaba.fastjson.JSONObject;
//import com.elitescloud.boot.core.base.BaseServiceImpl;
//import com.elitescloud.cloudt.common.base.ApiResult;
//import com.elitescloud.cloudt.common.base.PagingVO;
//import com.elitescloud.cloudt.core.annotation.TenantOrgTransaction;
//import com.elitescloud.cloudt.core.annotation.TenantTransaction;
//import com.elitescloud.cloudt.core.annotation.common.TenantIsolateType;
//import com.elitescloud.cloudt.log.convert.OperationConfigConvert;
//import com.elitescloud.cloudt.log.model.vo.param.OperationConfigQueryParam;
//import com.elitescloud.cloudt.log.model.vo.resp.OperationConfigVO;
//import com.elitescloud.cloudt.log.service.OperationConfigService;
//import com.elitescloud.cloudt.log.service.repo.OperationConfigRepo;
//import com.elitescloud.cloudt.log.service.repo.OperationConfigRepoProc;
//import com.elitescloud.cloudt.system.service.model.entity.SysOperationConfigDO;
//import lombok.extern.log4j.Log4j2;
//import org.springframework.beans.factory.annotation.Autowired;
//import org.springframework.data.redis.core.RedisTemplate;
//import org.springframework.stereotype.Service;
//import org.springframework.transaction.annotation.Transactional;
//
//import java.util.List;
//import java.util.stream.Collectors;
//
///**
// * @author James.Huang
// * @version 2022.1
// * @date 2023/6/27 11:37
// * @Description:
// */
//@TenantTransaction(isolateType = TenantIsolateType.TENANT)
//@TenantOrgTransaction(useTenantOrg = false)
//@Service
//@Log4j2
//public class OperationConfigServiceImpl  extends BaseServiceImpl implements OperationConfigService {
//
//    private static final OperationConfigConvert CONVERT = OperationConfigConvert.INSTANCE;
//    @Autowired
//    private OperationConfigRepoProc operationConfigRepoProc;
//    @Autowired
//    private OperationConfigRepo operationConfigRepo;
//    @Autowired
//    private RedisTemplate redisTemplate;
//
//    @Transactional(rollbackFor = Exception.class)
//    @Override
//    public ApiResult<Long> saveOperConfig(OperationConfigVO operationConfigVO) {
//        SysOperationConfigDO sysOperationConfigDO=CONVERT.saveVo2Do(operationConfigVO);
//        SysOperationConfigDO ocDO= operationConfigRepo.save(sysOperationConfigDO);
//
//        OperationConfigVO currOC=CONVERT.do2VO(ocDO);
//        String operationConfigKey="OPERATION-CONFIG-KEY";
//        if(currOC.getEnabled()==1){
//            String ocJson= JSONObject.toJSONString(currOC);
//            redisTemplate.opsForHash().put(operationConfigKey,currOC.getOperationUrl(),ocJson);
//        }else{
//            if(redisTemplate.opsForHash().hasKey(operationConfigKey,currOC.getOperationUrl())){
//                redisTemplate.opsForHash().delete(operationConfigKey,currOC.getOperationUrl());
//            }
//        }
//
//        return ApiResult.ok(ocDO.getId());
//    }
//
//    @Override
//    public ApiResult<OperationConfigVO> getOperConfig(Long id) {
//        SysOperationConfigDO sysOperationConfigDO=operationConfigRepoProc.get(id);
//        OperationConfigVO operationConfigVO=CONVERT.do2VO(sysOperationConfigDO);
//        return ApiResult.ok(operationConfigVO);
//    }
//
//    @Override
//    public List<OperationConfigVO> findOperationConfigList() {
//        List<SysOperationConfigDO> ocDOList=operationConfigRepoProc.listOfOperationConfig();
//        var configLsit=ocDOList.stream().map(CONVERT::do2VO).collect(Collectors.toList());
//        return configLsit;
//    }
//
//    @Override
//    public ApiResult<PagingVO<OperationConfigVO>> page(OperationConfigQueryParam operationConfigQueryParam) {
//
//        var pageData = operationConfigRepoProc.pageOperation(operationConfigQueryParam);
//        if (pageData.isEmpty()) {
//            return ApiResult.ok(PagingVO.empty());
//        }
//        var pageResult = pageData.map(CONVERT::do2VO);
//        return ApiResult.ok(pageResult);
//    }
//
//    @Transactional(rollbackFor = Exception.class)
//    @Override
//    public ApiResult<Long> deleteValue(Long id) {
//        SysOperationConfigDO sysOperationConfigDO=operationConfigRepoProc.get(id);
//        String operationConfigKey="OPERATION-CONFIG-KEY";
//        String operationUrl=sysOperationConfigDO.getOperationUrl();
//        if(redisTemplate.opsForHash().hasKey(operationConfigKey,operationUrl)){
//            redisTemplate.opsForHash().delete(operationConfigKey,operationUrl);
//        }
//        operationConfigRepoProc.delete(id);
//
//        return ApiResult.ok(id);
//    }
//
//
//}
