package com.elitescloud.cloudt.system.cas;

import com.elitescloud.boot.auth.client.config.support.AuthenticationCallable;
import com.elitescloud.cloudt.security.entity.GeneralUserDetails;
import com.elitescloud.cloudt.system.service.UserMngService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.security.core.Authentication;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.IOException;
import java.time.LocalDateTime;
import java.util.concurrent.CompletableFuture;

/**
 * 系统域的登录回调.
 *
 * @author Kaiser（wang shao）
 * @date 2024/4/17
 */
@Slf4j
public class SystemLoginCallback implements AuthenticationCallable {

    private final UserMngService userMngService;

    public SystemLoginCallback(UserMngService userMngService) {
        this.userMngService = userMngService;
    }

    @Override
    public void onLogin(HttpServletRequest request, HttpServletResponse response, @NotBlank String token, @NotNull Authentication authentication) throws IOException, ServletException {
        GeneralUserDetails user = authentication.getPrincipal() instanceof GeneralUserDetails
                ? (GeneralUserDetails) authentication.getPrincipal() : null;
        if (user == null) {
            return;
        }

        CompletableFuture.runAsync(() -> userMngService.updateLastLoginTime(user.getUserId(), user.getTenantId(), LocalDateTime.now())).whenComplete((r, e) -> {
            if (e != null) {
                log.error("记录登录日志异常：", e);
            }
        });
    }
}
