package com.elitescloud.cloudt.system.cas;

import com.elitescloud.boot.auth.client.config.AuthorizationProperties;
import com.elitescloud.boot.auth.provider.provider.user.AbstractUserDetailManager;
import com.elitescloud.cloudt.security.entity.GeneralUserDetails;
import com.elitescloud.cloudt.system.service.old.ISysUserService;
import com.elitescloud.cloudt.system.vo.SysUserDTO;
import lombok.extern.log4j.Log4j2;

import javax.validation.constraints.NotBlank;
import java.util.function.Supplier;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * 2022/12/20
 */
@Log4j2
@SuppressWarnings({"deprecation", "removal"})
public class SystemUserDetailManager extends AbstractUserDetailManager {

    private final ISysUserService sysUserService;

    public SystemUserDetailManager(AuthorizationProperties authorizationProperties, ISysUserService sysUserService) {
        super(authorizationProperties);
        this.sysUserService = sysUserService;
    }

    @Override
    public GeneralUserDetails loadUserByUsername(@NotBlank String s) {
        return loadUser(() -> sysUserService.getUserByUsername(s));
    }

    @Override
    public GeneralUserDetails loadUserByMobile(String s) {
        return loadUser(() -> sysUserService.getUserByMobile(s));
    }

    @Override
    public GeneralUserDetails loadUserByEmail(String s) {
        return loadUser(() -> sysUserService.getUserByEmail(s));
    }

    @Override
    public GeneralUserDetails loadUserById(String s) {
        return loadUser(() -> sysUserService.getUserById(Long.parseLong(s)));
    }

    @Override
    public GeneralUserDetails loadUserByAccount(String s) {
        return loadUser(() -> sysUserService.getUserByAccount(s));
    }

    @Override
    public GeneralUserDetails loadUserByWechatOpenid(String s) {
        return loadUser(() -> sysUserService.getUserByWechatOpenid(s));
    }

    private GeneralUserDetails loadUser(Supplier<SysUserDTO> userDTOSupplier) {
        // 查询用户信息
        SysUserDTO user = userDTOSupplier.get();
        if (user == null) {
            return null;
        }

        return super.wrapUserDetails(user);
    }
}
