package com.elitescloud.cloudt.system.controller.devops;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.system.model.vo.resp.devops.ServiceInstanceClassInfoRespVO;
import com.elitescloud.cloudt.system.model.vo.resp.devops.ServiceInstanceInfoRespVO;
import com.elitescloud.cloudt.system.service.ServiceInstanceService;
import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import javax.validation.constraints.NotBlank;

/**
 * 服务实例.
 *
 * @author Kaiser（wang shao）
 * @date 2024/7/8
 */
@Api(tags = "服务实例")
@RestController
@RequestMapping(value = "/devops/serviceInstance", produces = MediaType.APPLICATION_JSON_VALUE)
@Validated
@Slf4j
public class ServiceInstanceController {

    private ServiceInstanceService service;

    @ApiOperation(value = "获取服务实例信息")
    @ApiOperationSupport(order = 1)
    @ApiImplicitParams({
            @ApiImplicitParam(name = "serviceId", value = "服务实例ID", required = true),
            @ApiImplicitParam(name = "url", value = "服务实例URL", required = false),
    })
    @GetMapping(value = "/instanceInfo")
    public ApiResult<ServiceInstanceInfoRespVO> getServiceInstanceInfo(@RequestParam(name = "serviceId") @NotBlank(message = "服务实例ID为空") String serviceId,
                                                                       @RequestParam(name = "url", required = false) String url) {
        return service.getServiceInstanceInfo(serviceId, url);
    }

    @ApiOperation(value = "获取配置信息")
    @ApiOperationSupport(order = 2)
    @ApiImplicitParams({
            @ApiImplicitParam(name = "serviceId", value = "服务实例ID", required = true),
            @ApiImplicitParam(name = "url", value = "服务实例URL", required = false),
            @ApiImplicitParam(name = "propertyName", value = "配置名称", required = true),
    })
    @GetMapping(value = "/property")
    public ApiResult<Object> getProperty(@RequestParam(name = "serviceId") @NotBlank(message = "服务实例ID为空") String serviceId,
                                         @RequestParam(name = "url", required = false) String url,
                                         @RequestParam(name = "propertyName") @NotBlank(message = "属性名称为空") String propertyName) {
        return service.getProperty(serviceId, url, propertyName);
    }

    @ApiOperation(value = "获取类的信息")
    @ApiOperationSupport(order = 2)
    @ApiImplicitParams({
            @ApiImplicitParam(name = "serviceId", value = "服务实例ID", required = true),
            @ApiImplicitParam(name = "url", value = "服务实例URL", required = false),
            @ApiImplicitParam(name = "className", value = "类名称", required = true),
    })
    @GetMapping(value = "/classInfo")
    public ApiResult<ServiceInstanceClassInfoRespVO> getClass(@RequestParam(name = "serviceId") @NotBlank(message = "服务实例ID为空") String serviceId,
                                                              @RequestParam(name = "url", required = false) String url,
                                                              @RequestParam(name = "className") @NotBlank(message = "类名称为空") String className) {
        return service.getClass(serviceId, url, className);
    }

    @Autowired
    public void setService(ServiceInstanceService service) {
        this.service = service;
    }
}
