package com.elitescloud.cloudt.system.controller.mng.common;

import com.elitescloud.boot.common.annotation.BusinessObject;
import com.elitescloud.boot.common.annotation.BusinessObjectOperation;
import com.elitescloud.boot.common.annotation.businessobject.OperationTypeEnum;
import com.elitescloud.boot.common.param.IdCodeNameParam;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.system.constant.BusinessObjectConstant;
import com.elitescloud.cloudt.system.model.vo.resp.common.CommonMenuTreeNodeRespVO;
import com.elitescloud.cloudt.system.service.MenuQueryService;
import com.elitescloud.cloudt.system.service.RoleQueryService;
import com.elitescloud.cloudt.system.service.common.constant.BelongType;
import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2/17/2023
 */
@BusinessObject(businessType = BusinessObjectConstant.SYS_COMMON)
@Api(tags = "通用权限接口")
@RestController
@RequestMapping(value = "/mng/common/permission", produces = MediaType.APPLICATION_JSON_VALUE)
@Validated
public class CommonPermissionController {

    private RoleQueryService roleQueryService;
    private MenuQueryService menuQueryService;

    @BusinessObjectOperation(operationType = OperationTypeEnum.SELECT, operationDescription = "[通用组件]查询角色列表", dataPermissionEnabled = true)
    @GetMapping(value = "/roles")
    @ApiOperation(value = "[通用组件]查询角色列表")
    @ApiOperationSupport(order = 1)
    @ApiImplicitParams({
            @ApiImplicitParam(name = "businessKey", value = "业务标识，[UDC]cloudt-system:roleBusiness"),
            @ApiImplicitParam(name = "roleName", value = "角色名称"),
    })
    public ApiResult<List<IdCodeNameParam>> queryRoleList(@RequestParam(name = "businessKey", required = false) String businessKey,
                                                          @RequestParam(name = "roleName", required = false) String roleName) {
        return roleQueryService.listRole(businessKey, roleName);
    }

    @BusinessObjectOperation(operationType = OperationTypeEnum.SELECT, operationDescription = "[通用组件]查询角色分组列表", dataPermissionEnabled = true)
    @GetMapping(value = "/roleGroups")
    @ApiOperation(value = "[通用组件]查询角色分组列表")
    @ApiOperationSupport(order = 2)
    public ApiResult<List<IdCodeNameParam>> queryRoleGroupList() {
        return roleQueryService.listAllRoleGroup(BelongType.getBelonger());
    }

    @ApiOperation(value = "[通用组件]获取系统菜单")
    @ApiOperationSupport(order = 5)
    @ApiImplicitParams({
            @ApiImplicitParam(name = "appCode", value = "应用编码"),
            @ApiImplicitParam(name = "withSys", value = "是否显示管理菜单", defaultValue = "false", dataType = "boolean"),
            @ApiImplicitParam(name = "withBusiness", value = "是否显示业务菜单", defaultValue = "true", dataType = "boolean"),
            @ApiImplicitParam(name = "withMenu", value = "是否显示菜单", defaultValue = "true", dataType = "boolean"),
            @ApiImplicitParam(name = "withAction", value = "是否显示按钮", defaultValue = "false", dataType = "boolean"),
            @ApiImplicitParam(name = "defTree", value = "是否使用默认树", defaultValue = "false", dataType = "boolean"),
            @ApiImplicitParam(name = "tree", value = "是否显示树状", defaultValue = "true", dataType = "boolean"),
    })
    @GetMapping(value = "/tenantMenu")
    public ApiResult<List<CommonMenuTreeNodeRespVO>> menuTreeSystem(@RequestParam(name = "appCode", required = false) String appCode,
                                                                    @RequestParam(name = "withSys", required = false, defaultValue = "false") Boolean withSys,
                                                                    @RequestParam(name = "withBusiness", required = false, defaultValue = "true") Boolean withBusiness,
                                                                    @RequestParam(name = "withMenu", required = false, defaultValue = "true") Boolean withMenu,
                                                                    @RequestParam(name = "withAction", required = false, defaultValue = "false") Boolean withAction,
                                                                    @RequestParam(name = "defTree", required = false, defaultValue = "false") Boolean defTree,
                                                                    @RequestParam(name = "tree", required = false, defaultValue = "true") Boolean tree) {

        return menuQueryService.menuTreeSystem(appCode, withSys, withBusiness, withMenu, withAction, defTree, tree);
    }

    @Autowired
    public void setRoleQueryService(RoleQueryService roleQueryService) {
        this.roleQueryService = roleQueryService;
    }

    @Autowired
    public void setMenuQueryService(MenuQueryService menuQueryService) {
        this.menuQueryService = menuQueryService;
    }
}
