package com.elitescloud.cloudt.system.controller.mng.common;

import com.elitescloud.boot.common.annotation.BusinessObject;
import com.elitescloud.boot.common.annotation.BusinessObjectOperation;
import com.elitescloud.boot.common.annotation.businessobject.OperationTypeEnum;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.system.model.vo.query.user.UserListQueryVO;
import com.elitescloud.cloudt.system.model.vo.query.user.UserQueryVO;
import com.elitescloud.cloudt.system.model.vo.resp.user.UserListRespVO;
import com.elitescloud.cloudt.system.model.vo.resp.user.UserQueryRespVO;
import com.elitescloud.cloudt.system.service.UserMngService;
import com.elitescloud.cloudt.system.service.UserQueryService;
import com.elitescloud.cloudt.system.constant.BusinessObjectConstant;
import com.elitescloud.cloudt.system.service.model.entity.SysUserDO;
import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.http.MediaType;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * 用户账号相关通用接口.
 *
 * @author Kaiser（wang shao）
 * 2022/9/20
 */
@BusinessObject(businessType = BusinessObjectConstant.SYS_USER, businessDoClass = SysUserDO.class, publicResource = true)
@Api(tags = "通用用户账号接口")
@RestController
@RequestMapping(value = "/mng/common/user", produces = MediaType.APPLICATION_JSON_VALUE)
@Validated
public class CommonUserController {

    private final UserMngService userMngService;
    private final UserQueryService userQueryService;

    public CommonUserController(UserMngService userMngService, UserQueryService userQueryService) {
        this.userMngService = userMngService;
        this.userQueryService = userQueryService;
    }

    /**
     * 分页查询账号
     *
     * @param queryVO 查询参数
     * @return 分页数据
     */
    @BusinessObjectOperation(operationType = OperationTypeEnum.SELECT_PAGE, operationDescription = "通用分页查询账号", dataPermissionEnabled = true)
    @ApiOperation(value = "分页查询账号")
    @ApiOperationSupport(order = 1)
    @PostMapping(value = "/page")
    public ApiResult<PagingVO<UserQueryRespVO>> page(@RequestBody UserQueryVO queryVO) {
        return userQueryService.pageQuery(queryVO);
    }

    /**
     * 查询账号列表
     *
     * @param queryVO 查询参数
     * @return 账号列表
     */
    @BusinessObjectOperation(operationType = OperationTypeEnum.SELECT, operationDescription = "通用查询账号列表", dataPermissionEnabled = true)
    @ApiOperation(value = "查询账号列表")
    @ApiOperationSupport(order = 2)
    @GetMapping(value = "/list")
    public ApiResult<List<UserListRespVO>> list(UserListQueryVO queryVO) {
        return userQueryService.listUser(queryVO);
    }

    /**
     * 重置密码
     *
     * @param id 账号ID
     * @return 新增结果
     */
    @ApiOperation(value = "重置密码")
    @ApiOperationSupport(order = 11)
    @PatchMapping(value = "/reset/{id}/password")
    public ApiResult<Long> updatePassword(@PathVariable("id") Long id) {
        return userMngService.updatePassword(id);
    }
}
