package com.elitescloud.cloudt.system.controller.mng.dpr;

import cn.zhxu.bs.BeanSearcher;
import cn.zhxu.bs.FieldOps;
import cn.zhxu.bs.MapSearcher;
import cn.zhxu.bs.SearchResult;
import cn.zhxu.bs.util.MapUtils;
import com.elitescloud.boot.common.annotation.BusinessObject;
import com.elitescloud.boot.common.annotation.BusinessObjectOperation;
import com.elitescloud.boot.common.annotation.businessobject.OperationTypeEnum;
import com.elitescloud.boot.datasecurity.common.DataSecurityUtil;
import com.elitescloud.boot.datasecurity.dpr.beansearcher.BeanSearcherFactory;
import com.elitescloud.boot.datasecurity.dpr.beansearcher.CloudBeanSearcherEnum;
import com.elitescloud.boot.datasecurity.dpr.service.RoleDataPermissionRuleService;
import com.elitescloud.boot.datasecurity.jpa.strategy.RoleRuleJpaService;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.system.constant.BusinessObjectConstant;
import com.elitescloud.cloudt.system.model.vo.query.dpr.EmployeePagedRespParam;
import com.elitescloud.cloudt.system.model.vo.sbean.EmployeePagedRespBean;
import com.elitescloud.cloudt.system.service.model.entity.QSysEmployeeDO;
import com.elitescloud.cloudt.system.service.model.entity.SysEmployeeDO;
import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import com.querydsl.core.types.Predicate;
import com.querydsl.jpa.impl.JPAQueryFactory;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.http.MediaType;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;
import springfox.documentation.annotations.ApiIgnore;

import java.util.List;
import java.util.Map;

/**
 * 员工管理数据权限API接口
 *
 * @author niuchen
 * 2023/1/28
 */
@BusinessObject(businessType = BusinessObjectConstant.SYS_TEST, businessDoClass = SysEmployeeDO.class)
@ApiIgnore
@Api(tags = "【调试】员工管理数据权限API接口-实例接口")
@RestController
@RequestMapping(value = "/mng/employee/searcher", produces = MediaType.APPLICATION_JSON_VALUE)
@Validated
public class EmployeeMngSearcherController {

    private final BeanSearcher beanSearcher;

    private final MapSearcher mapSearcher;
    private final BeanSearcherFactory beanSearcherFactory;
    private final JPAQueryFactory jpaQueryFactory;
    private final RoleDataPermissionRuleService roleDataPermissionRuleService;

    public EmployeeMngSearcherController(BeanSearcherFactory beanSearcherFactory,
                                         RoleDataPermissionRuleService roleDataPermissionRuleService,
                                         JPAQueryFactory jpaQueryFactory,
                                         RoleRuleJpaService roleService) {
        this.beanSearcherFactory = beanSearcherFactory;
        this.beanSearcher = beanSearcherFactory.getBeanSearcherService(CloudBeanSearcherEnum.BS_TENANT_AUTH);
        this.mapSearcher = beanSearcherFactory.getMapBeanSearcherService(CloudBeanSearcherEnum.BS_TENANT_AUTH);
        this.roleDataPermissionRuleService = roleDataPermissionRuleService;
        this.jpaQueryFactory = jpaQueryFactory;
    }

    /**
     * 分页查询员工
     * ApiResult<PagingVO<EmployeePagedRespVO>>
     *
     * @param params 查询参数
     * @return 分页数据
     */
    @ApiOperation(value = "返回当前用户的数据权限集合")
    @ApiOperationSupport(order = 1)
    @PostMapping(value = "/getUserRoleDpr")
    public ApiResult getUserRoleDpr(@RequestBody Map<String, Object> params) {
        var obj = roleDataPermissionRuleService.getOriginalDataPermission();
        return ApiResult.ok(obj);
    }

    /**
     * 分页查询员工
     * ApiResult<PagingVO<EmployeePagedRespVO>>
     *
     * @param params 查询参数
     * @return 分页数据
     */
    @ApiOperation(value = "分页查询员工，按照租户查询")
    @ApiOperationSupport(order = 1)
    @PostMapping(value = "/page2")
    public ApiResult<SearchResult<EmployeePagedRespBean>> page(@RequestBody Map<String, Object> params) {
        var obj = beanSearcher.search(EmployeePagedRespBean.class, params);
        return ApiResult.ok(obj);
    }

    /**
     * 分页查询员工
     * ApiResult<PagingVO<EmployeePagedRespVO>>
     *
     * @param params 查询参数
     * @return 分页数据
     */
    @ApiOperation(value = "分页查询员工，按照租户查询")
    @ApiOperationSupport(order = 1)
    @PostMapping(value = "/page")
    public ApiResult<SearchResult<Map<String, Object>>> mapPage(@RequestBody Map<String, Object> params) {
        var obj = mapSearcher.search(EmployeePagedRespBean.class, params);
        return ApiResult.ok(obj);
    }

    @ApiOperation(value = " 查询员工")
    @ApiOperationSupport(order = 1)
    @PostMapping(value = "/page/{userId}")
    public ApiResult<SearchResult<EmployeePagedRespBean>> getById(
            @PathVariable Long userId) {
        var wereSqlMapBuilder = MapUtils.builder()
                .field(EmployeePagedRespBean::getUserId, userId).op(FieldOps.Equal);

        var obj = beanSearcher.search(EmployeePagedRespBean.class, wereSqlMapBuilder.build());

        return ApiResult.ok(obj);
    }

    @BusinessObjectOperation(businessObjectType = BusinessObjectConstant.SYS_EMPLOYEE, operationType = OperationTypeEnum.SELECT_PAGE, operationDescription = "BeanSearcher分页查询员工", dataPermissionEnabled = true)
    @ApiOperation(value = "分页查询员工，按照租户查询 EmployeePagedRespParam")
    @ApiOperationSupport(order = 1)
    @PostMapping(value = "/paramPage")
    public ApiResult<SearchResult<Map<String, Object>>> paramPage(@RequestBody EmployeePagedRespParam params) {
        var wereSqlMapBuilder = MapUtils.builder()
                .page(params.getCurrent(), params.getSize())
                .field(EmployeePagedRespBean::getCode, params.getCode()).op(FieldOps.Contain)
                .field(EmployeePagedRespBean::getServed, params.getServed()).op(FieldOps.Equal)
                .orderBy("id").desc();

        var obj = mapSearcher.search(EmployeePagedRespBean.class, wereSqlMapBuilder.build());
        return ApiResult.ok(obj);
    }

    @BusinessObjectOperation(businessObjectType = BusinessObjectConstant.SYS_EMPLOYEE, operationType = OperationTypeEnum.SELECT_PAGE, operationDescription = "JPA分页查询员工", dataPermissionEnabled = true)
    @ApiOperation(value = " 查询员工getJpaParamPage")
    @ApiOperationSupport(order = 1)
    @PostMapping(value = "/jpa/paramPage")
    public ApiResult<List<SysEmployeeDO>> getJpaParamPage() {
        QSysEmployeeDO QDO = QSysEmployeeDO.sysEmployeeDO;
        Predicate authWhere = DataSecurityUtil.predicateForJPA(SysEmployeeDO.class);

        var dataList = jpaQueryFactory.selectFrom(QDO)
                .where(authWhere)
                .fetch();
        return ApiResult.ok(dataList);
    }
}
