package com.elitescloud.cloudt.system.controller.mng.extend;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.system.model.vo.query.extend.NoticePageMngQueryVO;
import com.elitescloud.cloudt.system.model.vo.resp.extend.NoticeEditRespVO;
import com.elitescloud.cloudt.system.model.vo.resp.extend.NoticePageRespVO;
import com.elitescloud.cloudt.system.model.vo.save.extend.NoticeSaveVO;
import com.elitescloud.cloudt.system.service.NoticeMngService;
import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiOperation;
import org.springframework.http.MediaType;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.util.Set;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2024/4/22
 */
@Api(tags = "公告管理")
@RestController
@RequestMapping(value = "/mng/notice", produces = MediaType.APPLICATION_JSON_VALUE)
@Validated
public class NoticeMngController {
    private final NoticeMngService service;

    public NoticeMngController(NoticeMngService service) {
        this.service = service;
    }

    @ApiOperation(value = "保存公告")
    @ApiOperationSupport(order = 1)
    @PostMapping(value = "/save")
    public ApiResult<Long> save(@RequestBody @Valid NoticeSaveVO saveVO) {
        if (Boolean.TRUE.equals(saveVO.getSys())) {
            return service.saveSys(saveVO);
        }
        return service.save(saveVO);
    }

    @ApiOperation(value = "假删除公告")
    @ApiOperationSupport(order = 2)
    @DeleteMapping(value = "/deleteFake")
    public ApiResult<Set<Long>> deleteFake(@RequestBody @NotEmpty(message = "公告ID为空") Set<Long> ids) {
        return service.delete(ids, false);
    }

    @ApiOperation(value = "删除公告")
    @ApiOperationSupport(order = 2)
    @DeleteMapping(value = "/delete")
    public ApiResult<Set<Long>> delete(@RequestBody @NotEmpty(message = "公告ID为空") Set<Long> ids) {
        return service.delete(ids, true);
    }

    @ApiOperation(value = "发布公告")
    @ApiOperationSupport(order = 3)
    @PatchMapping(value = "/publish")
    public ApiResult<Set<Long>> execPublish(@RequestBody @NotEmpty(message = "公告ID为空") Set<Long> ids) {
        return service.execPublish(ids);
    }

    @ApiOperation(value = "撤回公告")
    @ApiOperationSupport(order = 4)
    @PatchMapping(value = "/revoke")
    public ApiResult<Set<Long>> execRevoke(@RequestBody @NotEmpty(message = "公告ID为空") Set<Long> ids) {
        return service.execRevoke(ids);
    }

    @ApiOperation(value = "获取公告编辑信息")
    @ApiOperationSupport(order = 5)
    @ApiImplicitParam(name = "id", value = "公告ID", dataType = "long", required = true)
    @GetMapping(value = "/edit")
    public ApiResult<NoticeEditRespVO> getEditVO(@RequestParam(name = "id") @NotNull(message = "公告ID为空") Long id) {
        return service.getEditVO(id);
    }

    @ApiOperation(value = "分页查询")
    @ApiOperationSupport(order = 6)
    @PostMapping(value = "/pageMng")
    public ApiResult<PagingVO<NoticePageRespVO>> pageMng(@RequestBody NoticePageMngQueryVO queryVO) {
        if (Boolean.TRUE.equals(queryVO.getSys())) {
            return service.pageSysMng(queryVO);
        }
        return service.pageMng(queryVO);
    }
}
