package com.elitescloud.cloudt.system.controller.mng.extend;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.system.model.vo.resp.extend.WechatMiniProgramRespVO;
import com.elitescloud.cloudt.system.model.vo.resp.extend.WechatServiceRespVO;
import com.elitescloud.cloudt.system.model.vo.resp.extend.WechatSubscriptionRespVO;
import com.elitescloud.cloudt.system.model.vo.save.extend.WechatMiniProgramSaveVO;
import com.elitescloud.cloudt.system.model.vo.save.extend.WechatServiceSaveVO;
import com.elitescloud.cloudt.system.model.vo.save.extend.WechatSubscriptionSaveVO;
import com.elitescloud.cloudt.system.service.ThirdPartAccountMngService;
import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.http.MediaType;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2/10/2023
 */
@Api(tags = "第三方账号管理")
@RestController
@RequestMapping(value = "/mng/third_party_account", produces = MediaType.APPLICATION_JSON_VALUE)
@Validated
public class ThirdPartyAccountController {

    private final ThirdPartAccountMngService service;

    public ThirdPartyAccountController(ThirdPartAccountMngService service) {
        this.service = service;
    }

    /**
     * 微信小程序保存
     *
     * @param saveVO 保存信息
     * @return 记录ID
     */
    @PostMapping(value = "/wechat/miniProgram/{businessType}")
    @ApiOperation(value = "微信小程序保存")
    @ApiOperationSupport(order = 1)
    public ApiResult<Long> saveWechatMiniApp(@RequestBody @Valid WechatMiniProgramSaveVO saveVO, @PathVariable("businessType") String businessType) {
        return service.saveWechatMiniApp(saveVO, businessType);
    }

    /**
     * 获取微信小程序配置
     *
     * @return 微信小程序配置
     */
    @GetMapping(value = "/wechat/miniProgram/{businessType}")
    @ApiOperation(value = "微信小程序获取")
    @ApiOperationSupport(order = 2)
    public ApiResult<WechatMiniProgramRespVO> getWechatMiniApp(@PathVariable("businessType") String businessType) {
        return service.getWechatMiniApp(businessType);
    }

    /**
     * 微信服务号保存
     *
     * @param saveVO 保存信息
     * @return 记录ID
     */
    @PostMapping(value = "/wechat/service/{businessType}")
    @ApiOperation(value = "微信服务号保存")
    @ApiOperationSupport(order = 3)
    public ApiResult<Long> saveWechatService(@RequestBody @Valid WechatServiceSaveVO saveVO, @PathVariable("businessType") String businessType) {
        return service.saveWechatService(saveVO, businessType);
    }

    /**
     * 获取微信服务号配置
     *
     * @return 微信服务号配置
     */
    @GetMapping(value = "/wechat/service/{businessType}")
    @ApiOperation(value = "微信服务号获取")
    @ApiOperationSupport(order = 4)
    public ApiResult<WechatServiceRespVO> getWechatService(@PathVariable("businessType") String businessType) {
        return service.getWechatService(businessType);
    }

    /**
     * 微信订阅号保存
     *
     * @param saveVO 保存信息
     * @return 记录ID
     */
    @PostMapping(value = "/wechat/subscription/{businessType}")
    @ApiOperation(value = "微信订阅号保存")
    @ApiOperationSupport(order = 5)
    public ApiResult<Long> saveWechatSubscription(@RequestBody @Valid WechatSubscriptionSaveVO saveVO, @PathVariable("businessType") String businessType) {
        return service.saveWechatSubscription(saveVO, businessType);
    }

    /**
     * 获取微信订阅号配置
     *
     * @return 微信订阅号配置
     */
    @GetMapping(value = "/wechat/subscription/{businessType}")
    @ApiOperation(value = "微信订阅号获取")
    @ApiOperationSupport(order = 6)
    public ApiResult<WechatSubscriptionRespVO> getWechatSubscription(@PathVariable("businessType") String businessType) {
        return service.getWechatSubscription(businessType);
    }
}
