package com.elitescloud.cloudt.system.controller.mng.extend;


import com.el.coordinator.boot.fsm.model.vo.FileObjRespVO;
import com.elitescloud.boot.common.annotation.BusinessObject;
import com.elitescloud.boot.common.annotation.BusinessObjectOperation;
import com.elitescloud.boot.common.annotation.businessobject.OperationTypeEnum;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.system.model.vo.query.extend.TmplImportQueryParam;
import com.elitescloud.cloudt.system.model.vo.query.extend.TmplQueryParam;
import com.elitescloud.cloudt.system.model.vo.resp.extend.TmplImportRecordRespVO;
import com.elitescloud.cloudt.system.model.vo.resp.extend.TmplPageQueryRespVO;
import com.elitescloud.cloudt.system.service.TmplImportRecordService;
import com.elitescloud.cloudt.system.service.TmplQueryService;
import com.elitescloud.cloudt.system.constant.BusinessObjectConstant;
import com.elitescloud.cloudt.system.service.model.entity.SysTmplDO;
import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import com.github.xiaoymin.knife4j.annotations.ApiSupport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.MediaType;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.servlet.mvc.method.annotation.StreamingResponseBody;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.util.List;

/**
 * 导入导出模板管理.
 *
 * @author Kaiser（wang shao）
 * @date 2021/5/28
 */
@RestController
@RequestMapping(value = "/api/tmplRecord", produces = MediaType.APPLICATION_JSON_VALUE)
@Api(tags = "导入导出记录")
@ApiSupport(author = "wang shao", order = 12)
@Validated
@Slf4j
@BusinessObject(businessType = BusinessObjectConstant.SYS_TMPL, businessDoClass = SysTmplDO.class)
public class TmplRecordController {

    @Autowired
    private TmplQueryService tmplService;
    @Autowired
    private TmplImportRecordService tmplImportRecordService;

    @PostMapping("/tmpl/search")
    @ApiOperation(value = "分页查询导入导出记录")
    @ApiOperationSupport(order = 1)
    @BusinessObjectOperation(operationType = OperationTypeEnum.SELECT_PAGE, operationDescription = "分页查询导入导出记录", dataPermissionEnabled = true
    )
    public ApiResult<PagingVO<TmplPageQueryRespVO>> search(@RequestBody @NotNull(message = "查询参数为空") TmplQueryParam queryParam) {
        return tmplService.search(queryParam);
    }

    @GetMapping(value = "/tmpl/file")
    @ApiOperation(value = "下载模板文件", produces = MediaType.APPLICATION_OCTET_STREAM_VALUE)
    @ApiOperationSupport(order = 8)
    @ApiImplicitParams({
            @ApiImplicitParam(name = "fileCode", value = "模板文件的唯一标识", required = true, paramType = "query")
    })
    @BusinessObjectOperation(operationType = OperationTypeEnum.DOWNLOAD, operationDescription = "下载模板文件"
    )
    public HttpEntity<StreamingResponseBody> download(@RequestParam(name = "fileCode") @NotBlank(message = "文件编码为空") String fileCode) {
        return tmplService.downloadByFileCode(fileCode);
    }

    @GetMapping(value = "/tmpl/file/byTmplCode")
    @ApiOperation(value = "根据模板编码下载模板文件", produces = MediaType.APPLICATION_OCTET_STREAM_VALUE)
    @ApiOperationSupport(order = 8)
    @ApiImplicitParams({
            @ApiImplicitParam(name = "tmplCode", value = "模板文件编码", required = true, paramType = "query")
    })
    @BusinessObjectOperation(operationType = OperationTypeEnum.SELECT, operationDescription = "根据模板编码下载模板文件"
    )
    public HttpEntity<StreamingResponseBody> downloadByTmplCode(@RequestParam(name = "tmplCode") @NotBlank(message = "模板编码为空") String tmplCode) {
        return tmplService.downloadByCode(tmplCode);
    }

    @PostMapping("/tmpl/{id}/import")
    @ApiOperation(value = "分页查询导入（导出）记录")
    @ApiOperationSupport(order = 21)
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "模板ID", required = true, paramType = "path", dataType = "long")
    })
    @BusinessObjectOperation(operationType = OperationTypeEnum.SELECT_PAGE, operationDescription = "分页查询导入（导出）记录"
    )
    public ApiResult<PagingVO<TmplImportRecordRespVO>> searchImport(@PathVariable Long id, @RequestBody @NotNull(message = "查询参数为空") TmplImportQueryParam queryParam) {
        return tmplImportRecordService.searchImport(id, queryParam);
    }

    @GetMapping("/tmpl/record/{recordId}/files")
    @ApiOperation(value = "获取导出的文件列表")
    @ApiOperationSupport(order = 22)
    @ApiImplicitParams({
            @ApiImplicitParam(name = "importId", value = "导出记录ID", required = true, paramType = "path", dataType = "long")
    })
    @BusinessObjectOperation(operationType = OperationTypeEnum.SELECT_PAGE, operationDescription = "获取导出的文件列表（导出）记录"
    )
    public ApiResult<List<FileObjRespVO<String>>> listFileOfExport(@PathVariable("recordId") Long recordId) {
        return tmplImportRecordService.listFileOfExport(recordId);
    }
}
