package com.elitescloud.cloudt.system.convert;

import com.elitescloud.boot.model.dto.SysBusinessOperationDTO;
import com.elitescloud.cloudt.core.common.BaseMapperConfig;
import com.elitescloud.cloudt.system.model.bo.BusinessObjectConvertBO;
import com.elitescloud.cloudt.system.model.bo.BusinessOperationParamBO;
import com.elitescloud.cloudt.system.model.vo.resp.businessobject.*;
import com.elitescloud.cloudt.system.model.vo.save.businessobject.BusinessObjectSaveVO;
import com.elitescloud.cloudt.system.model.vo.save.businessobject.BusinessOperationSaveVO;
import com.elitescloud.cloudt.system.service.model.entity.SysBusinessObjectDO;
import com.elitescloud.cloudt.system.service.model.entity.SysBusinessOperationDO;
import com.elitescloud.cloudt.system.service.model.entity.SysBusinessOperationParamDO;
import com.elitescloud.cloudt.system.service.model.entity.SysBusinessParamDO;
import org.mapstruct.Mapper;
import org.mapstruct.MappingTarget;
import org.mapstruct.factory.Mappers;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2024/3/11
 */
@Mapper(config = BaseMapperConfig.class)
public interface BusinessObjectConvert {
    BusinessObjectConvert INSTANCE = Mappers.getMapper(BusinessObjectConvert.class);

    SysBusinessObjectDO bo2Do(BusinessObjectConvertBO bo, @MappingTarget SysBusinessObjectDO objectDO);

    SysBusinessParamDO bo2Do(BusinessObjectConvertBO.BusinessParam bo, @MappingTarget SysBusinessParamDO paramDO);

    SysBusinessOperationDO bo2Do(BusinessObjectConvertBO.Operation bo, @MappingTarget SysBusinessOperationDO objectDO);

    SysBusinessOperationParamDO bo2Do(BusinessObjectConvertBO.OperationParam bo, @MappingTarget SysBusinessOperationParamDO objectDO);

    BusinessObjectPageRespVO do2PageRespVO(SysBusinessObjectDO businessObjectDO);

    SysBusinessObjectDO copySaveVO(BusinessObjectSaveVO saveVO, @MappingTarget SysBusinessObjectDO businessObjectDO);

    SysBusinessOperationDO copySaveVO(BusinessOperationSaveVO saveVO, @MappingTarget SysBusinessOperationDO operationDO);

    BusinessOperationPageRespVO do2PageRespVO(SysBusinessOperationDO businessObjectDO);

    BusinessObjectDetailRespVO do2DetailVO(SysBusinessObjectDO businessObjectDO);

    BusinessOperationRespVO do2DetailVO(SysBusinessOperationDO businessObjectDO);

    BusinessObjectParamRespVO do2DetailVO(SysBusinessParamDO businessParamDO);

    BusinessPermissionParamRespVO do2PermissionVO(SysBusinessParamDO businessParamDO);

    BusinessOperationRespVO.OperationParam bo2DetailVO(BusinessOperationParamBO operationParamBO);

    SysBusinessOperationDTO do2Dto(SysBusinessOperationDO operationDO);
}
