package com.elitescloud.cloudt.system.model.bo;

import com.elitescloud.cloudt.common.annotation.Comment;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import java.io.Serializable;

/**
 * 业务对象参数.
 *
 * @author Kaiser（wang shao）
 * @date 2024/3/27
 */
@Getter
@Setter
public class BusinessParamBO implements Serializable {
    private static final long serialVersionUID = 3762803996874177205L;

    /**
     * ID
     */
    private Long id;

    /**
     * 是否启用
     */
    private Boolean enabled;

    /**
     * entity类的名称
     */
    private String entityClassName;

    /**
     * 表名
     */
    private String tableName;

    /**
     * 字段名称
     */
    private String fieldName;

    /**
     * 字段类型
     */
    private String fieldJavaType;

    /**
     * 字段描述
     */
    private String fieldDescription;

    /**
     * 自定义描述
     */
    private String customDescription;

    /**
     * 关联的业务对象
     */
    private String relatedBusinessObject;

    /**
     * 关联的业务对象的字段
     */
    private String relatedField;

    /**
     * 可用值列表
     */
    private String valuesJson;

    /**
     * 账户类型
     */
    private String userType;

    /**
     * 是否用于数据权限过滤
     */
    private Boolean dataPermissionEnabled;

    /**
     * 是否应于字段权限过滤
     */
    private Boolean fieldPermissionEnabled;

    /**
     * 是否基础字段
     */
    private Boolean baseField;
}
