package com.elitescloud.cloudt.system.model.bo;

import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;
import java.util.Map;

/**
 * 数据关系值的查询参数.
 *
 * @author Kaiser（wang shao）
 * @date 2024/5/15
 */
@Getter
@Setter
public class DataRelationInstQueryBO implements Serializable {
    private static final long serialVersionUID = 1512405498812568492L;

    /**
     * 数据关系编码
     */
    @NotBlank(message = "数据关系编码为空")
    private String drCode;
    /**
     * 分类编码
     */
    private String catCode;

    /**
     * 业务数据的标识
     */
    @NotBlank(message = "业务数据的标识为空")
    private String dataKey;

    /**
     * 数据的主属性
     */
    private String dataAttribute;

    /**
     * 数据的其它属性
     */
    private Map<String, String> dataExt;
}
