package com.elitescloud.cloudt.system.model.bo;

import com.elitescloud.cloudt.system.constant.PlatformMenusOuterLinkTypeEnum;
import lombok.Data;

import java.io.Serializable;

/**
 * 权限菜单.
 * <p>
 * 包含菜单和按钮
 *
 * @author Kaiser（wang shao）
 * 2022/10/19
 */
@Data
public class PermissionMenuBO implements Serializable {
    private static final long serialVersionUID = 5990226226210741367L;

    /**
     * 菜单名称
     */
    private String menusName;

    /**
     * 应用编码
     */
    private String appCode;

    /**
     * 节点类型 菜单,按钮
     */
    private String nodeType;

    /**
     * 数据类型
     */
    private String dataType;

    /**
     * 菜单编码
     */
    private String menusCode;

    /**
     * 排序
     */
    private Integer menusOrder;

    /**
     * 上级菜单编码
     */
    private String menusParentCode;

    /**
     * 菜单路由
     */
    private String menusRoute;

    /**
     * 图标
     */
    private String menusIcon;

    /**
     * 是否展示
     */
    private Boolean display;

    /**
     * 是否外链接
     */
    private Boolean outerLink;

    /**
     * 外链接类型
     */
    private PlatformMenusOuterLinkTypeEnum outerLinkType;
}
