package com.elitescloud.cloudt.system.model.bo;

import com.elitescloud.cloudt.system.service.common.constant.BelongType;
import com.elitescloud.cloudt.system.service.common.constant.SubUserPermissionTypeEnum;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;

/**
 * 子账号信息.
 *
 * @author Kaiser（wang shao）
 * @date 2024/5/30
 */
@Getter
@Setter
public class SubUserBO implements Serializable {
    private static final long serialVersionUID = -3442494747527746933L;

    /**
     * 子账号ID
     */
    private Long subUserId;

    /**
     * 归属类型
     * {@link BelongType}
     */
    private String type;

    /**
     * 归属类型标识
     */
    private String typeId;

    /**
     * 权限类型
     * <p>
     * {@link com.elitescloud.cloudt.system.service.common.constant.SubUserPermissionTypeEnum}
     */
    private String permissionType;

    public BelongType getBelongType() {
        return BelongType.valueOf(type);
    }

    public BelongType.Belonger getBelonger() {
        return new BelongType.Belonger(getBelongType(), typeId);
    }

    public SubUserPermissionTypeEnum getPermissionTypeEnum() {
        return SubUserPermissionTypeEnum.valueOf(permissionType);
    }
}
