package com.elitescloud.cloudt.system.model.bo;

import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * 下一序号.
 *
 * @author Kaiser（wang shao）
 * 2022/11/14
 */
@Data
public class SysSeqNextNumberBO implements Serializable {
    private static final long serialVersionUID = 8706770968679696487L;

    /**
     * ID
     */
    private Long id;

    /**
     * 应用编码
     */
    private String appCode;

    /**
     * 编号代码
     */
    private String code;

    /**
     * 下一编号名称
     */
    private String name;

    /**
     * 步长
     */
    private Integer step;

    /**
     * 下一编号取值
     */
    private Long nextNumber;

    /**
     * 下一编号周期
     */
    private String nnPeriod;

    /**
     * 发号时间
     */
    private LocalDateTime nnTime;

    /**
     * 乐观锁标记
     */
    private Integer version;

    /**
     * 是否启用
     */
    private Boolean enabled;

    /**
     * 备注
     */
    private String remark;
}
