package com.elitescloud.cloudt.system.model.bo;

import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;

/**
 * 租户自定义菜单.
 *
 * @author Kaiser（wang shao）
 * @date 2024/6/3
 */
@Getter
@Setter
public class TenantMenuBO implements Serializable {
    private static final long serialVersionUID = -9058147402641360885L;

    /**
     * 自定义菜单ID
     */
    private Long id;

    /**
     * 菜单编码
     */
    private String menuCode;

    /**
     * 菜单名称
     */
    private String menuName;

    /**
     * 节点类型
     * <p>
     * {@link com.elitescloud.cloudt.system.service.common.constant.MenuTreeNodeType}
     */
    private String nodeType;

    /**
     * 父菜单编码
     */
    private String parentMenuCode;

    /**
     * 菜单图标
     */
    private String icon;

    /**
     * 顺序
     */
    private Integer sortNo;

    /**
     * 是否启用
     */
    private Boolean enabled;

    private transient String appCode;
}
