package com.elitescloud.cloudt.system.model.entity;

import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.time.LocalDateTime;

/**
 * 三方接口调用重试记录.
 *
 * @author Kaiser（wang shao）
 * @date 2023/9/4
 */
@Entity
@Table(name = "sys_third_api_business", indexes = {
        @Index(name = "idx_thirdapi_bus_type", columnList = "businessType"),
        @Index(name = "idx_thirdapi_bus_key", columnList = "businessKey"),
})
@Comment("三方接口调用重试记录")
@DynamicUpdate
@DynamicInsert
@Getter
@Setter
@Accessors(chain = true)
public class SysThirdApiBusinessDO extends BaseModel {
    private static final long serialVersionUID = 1230998193088176738L;

    @Column()
    @Comment(value = "租户ID")
    private Long sysTenantId;

    @Column()
    @Comment(value = "业务类型")
    private String businessType;

    @Column()
    @Comment(value = "业务数据key")
    private String businessKey;

    @Column()
    @Comment(value = "是否成功", defaultValue = "0")
    private Boolean success;

    @Column()
    @Comment(value = "请求成功时间")
    private LocalDateTime successTime;
}
