package com.elitescloud.cloudt.system.model.vo.query.datarelation;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 * 数据关系实例查询参数.
 *
 * @author Kaiser（wang shao）
 * @date 2024/5/15
 */
@Getter
@Setter
@ApiModel(description = "数据关系实例查询参数")
public class DataRelationInstEditQueryVO implements Serializable {
    private static final long serialVersionUID = -6922875877783385785L;

    @NotBlank(message = "数据关系编码为空")
    @ApiModelProperty(value = "数据关系编码", position = 1, required = true)
    private String drCode;

    @NotBlank(message = "主数据的标识为空")
    @ApiModelProperty(value = "主数据的标识", position = 3, required = true)
    private String dataKey;
}
