package com.elitescloud.cloudt.system.model.vo.query.extend;

import com.elitescloud.boot.common.param.AbstractOrderQueryParam;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.time.LocalDateTime;

/**
 * 公告管理分页查询参数.
 *
 * @author Kaiser（wang shao）
 * @date 2024/4/22
 */
@Getter
@Setter
@ApiModel(description = "公告管理分页查询参数")
public class NoticePageMngQueryVO extends AbstractOrderQueryParam {
    private static final long serialVersionUID = -4852451627144753175L;

    @ApiModelProperty(value = "公告标题")
    private String title;

    @ApiModelProperty(value = "作者ID")
    private Long authorId;

    @ApiModelProperty(value = "分类")
    private String category;

    @ApiModelProperty(value = "公告类型")
    private String noticeType;

    @ApiModelProperty(value = "是否置顶")
    private Boolean top;

    @ApiModelProperty(value = "是否已发布")
    private Boolean published;

    @ApiModelProperty(value = "发布时间-起始")
    private LocalDateTime publishTimeStart;

    @ApiModelProperty(value = "发布时间-截止")
    private LocalDateTime publishTimeEnd;

    @ApiModelProperty(value = "是否是系统公告")
    private Boolean sys;
}
