package com.elitescloud.cloudt.system.model.vo.query.extend;

import com.elitescloud.boot.common.param.AbstractOrderQueryParam;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.time.LocalDateTime;

/**
 * 三方接口日志查询参数.
 *
 * @author Kaiser（wang shao）
 * @date 2023/9/15
 */
@Data
@ApiModel(description = "三方接口日志查询参数")
public class ThirdApiLogQueryVO extends AbstractOrderQueryParam {
    private static final long serialVersionUID = 2211006530909929149L;

    /**
     * 应用编码
     */
    @ApiModelProperty(value = "应用编码", position = 1)
    private String appCode;

    /**
     * 源系统
     */
    @ApiModelProperty(value = "源系统", position = 2)
    private String sourceSystem;

    /**
     * 是否内部调用
     */
    @ApiModelProperty(value = "目标系统", position = 3)
    private String targetSystem;

    /**
     * 业务类型
     */
    @ApiModelProperty(value = "业务类型", position = 3)
    private String businessType;

    /**
     * 业务数据标识
     */
    @ApiModelProperty(value = "业务数据标识", position = 4)
    private String businessKey;

    /**
     * 请求的接口地址
     */
    @ApiModelProperty(value = "请求的接口地址", position = 5)
    private String uri;

    /**
     * 是否响应成功
     */
    @ApiModelProperty(value = "是否响应成功", position = 7)
    private Boolean respSuccess;

    /**
     * 请求时间-起始
     */
    @ApiModelProperty(value = "请求时间-起始", position = 8)
    private LocalDateTime reqTimeStart;

    /**
     * 请求时间-截止
     */
    @ApiModelProperty(value = "请求时间-截止", position = 9)
    private LocalDateTime reqTimeEnd;
}
